/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.app.table;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import nextapp.echo2.app.event.EventListenerList;
import nextapp.echo2.app.event.TableColumnModelEvent;
import nextapp.echo2.app.event.TableColumnModelListener;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;

public class DefaultTableColumnModel
implements Serializable,
TableColumnModel {
    private List columns = new ArrayList();
    protected EventListenerList listenerList = new EventListenerList();

    @Override
    public void addColumn(TableColumn column) {
        this.columns.add(column);
        this.fireColumnAdded(new TableColumnModelEvent(this, -1, this.columns.size() - 1));
    }

    @Override
    public void addColumnModelListener(TableColumnModelListener l) {
        this.listenerList.addListener(TableColumnModelListener.class, l);
    }

    protected void fireColumnAdded(TableColumnModelEvent e) {
        EventListener[] listeners = this.listenerList.getListeners(TableColumnModelListener.class);
        for (int index = 0; index < listeners.length; ++index) {
            ((TableColumnModelListener)listeners[index]).columnAdded(e);
        }
    }

    protected void fireColumnMoved(TableColumnModelEvent e) {
        EventListener[] listeners = this.listenerList.getListeners(TableColumnModelListener.class);
        for (int index = 0; index < listeners.length; ++index) {
            ((TableColumnModelListener)listeners[index]).columnMoved(e);
        }
    }

    protected void fireColumnRemoved(TableColumnModelEvent e) {
        EventListener[] listeners = this.listenerList.getListeners(TableColumnModelListener.class);
        for (int index = 0; index < listeners.length; ++index) {
            ((TableColumnModelListener)listeners[index]).columnRemoved(e);
        }
    }

    @Override
    public TableColumn getColumn(int index) {
        if (this.getColumnCount() - 1 < index) {
            return null;
        }
        return (TableColumn)this.columns.get(index);
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public int getColumnIndex(Object identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("Null not allowed as identifier value.");
        }
        Iterator it = this.columns.iterator();
        int index = 0;
        while (it.hasNext()) {
            TableColumn column = (TableColumn)it.next();
            if (identifier.equals(column.getIdentifier())) {
                return index;
            }
            ++index;
        }
        throw new IllegalArgumentException("No column found with specified identifier: " + identifier);
    }

    @Override
    public Iterator getColumns() {
        return this.columns.iterator();
    }

    @Override
    public void moveColumn(int columnIndex, int newIndex) {
        if (columnIndex < 0 || columnIndex >= this.columns.size()) {
            throw new IllegalArgumentException("No column exists at index: " + columnIndex);
        }
        if (newIndex < 0 || newIndex >= this.columns.size()) {
            throw new IllegalArgumentException("Attempt to move column to invalid index: " + newIndex);
        }
        TableColumn column = (TableColumn)this.columns.remove(columnIndex);
        this.columns.add(newIndex, column);
        this.fireColumnMoved(new TableColumnModelEvent(this, columnIndex, newIndex));
    }

    @Override
    public void removeColumn(TableColumn column) {
        int columnIndex = this.columns.indexOf(column);
        if (columnIndex == -1) {
            return;
        }
        this.columns.remove(columnIndex);
        this.fireColumnAdded(new TableColumnModelEvent(this, columnIndex, -1));
    }

    @Override
    public void removeColumnModelListener(TableColumnModelListener l) {
        this.listenerList.removeListener(TableColumnModelListener.class, l);
    }
}

