/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.app.table;

import java.io.Serializable;
import java.util.EventListener;
import nextapp.echo2.app.event.EventListenerList;
import nextapp.echo2.app.event.TableModelEvent;
import nextapp.echo2.app.event.TableModelListener;
import nextapp.echo2.app.table.TableModel;

public abstract class AbstractTableModel
implements Serializable,
TableModel {
    private EventListenerList listenerList = new EventListenerList();

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listenerList.addListener(TableModelListener.class, l);
    }

    public void fireTableCellUpdated(int column, int row) {
        this.fireTableChanged(new TableModelEvent(this, column, row, row, 3));
    }

    public void fireTableDataChanged() {
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, -2, firstRow, lastRow, 1));
    }

    public void fireTableRowsInserted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, -2, firstRow, lastRow, 2));
    }

    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, -2, firstRow, lastRow, 3));
    }

    public void fireTableStructureChanged() {
        this.fireTableChanged(new TableModelEvent(this, -2, -1, -1, 4));
    }

    public void fireTableChanged(TableModelEvent e) {
        EventListener[] listeners = this.listenerList.getListeners(TableModelListener.class);
        for (int index = 0; index < listeners.length; ++index) {
            ((TableModelListener)listeners[index]).tableChanged(e);
        }
    }

    @Override
    public Class getColumnClass(int column) {
        return Object.class;
    }

    @Override
    public String getColumnName(int column) {
        StringBuffer sb = new StringBuffer();
        int value = column;
        do {
            int digit = value % 26;
            sb.insert(0, (char)(65 + digit));
        } while ((value = value / 26 - 1) >= 0);
        return sb.toString();
    }

    public EventListenerList getEventListenerList() {
        return this.listenerList;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listenerList.removeListener(TableModelListener.class, l);
    }
}

