/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.app.filetransfer;

import java.io.InputStream;
import java.util.TooManyListenersException;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.filetransfer.UploadEvent;
import nextapp.echo2.app.filetransfer.UploadListener;

public class UploadSelect
extends Component {
    public static final String PROPERTY_HEIGHT = "height";
    public static final String PROPERTY_WIDTH = "width";
    public static final String PROPERTY_ENABLED_SEND_TEXT = "enabledSendText";
    public static final String PROPERTY_DISABLED_SEND_TEXT = "disabledSendText";
    public static final String PROPERTY_DISPLAY_SEND_BUTTON = "displaySendButton";
    public static final String UPLOAD_LISTENER_CHANGED_PROPERTY = "uploadListener";
    private UploadListener uploadListener = null;

    public void addUploadListener(UploadListener l) throws TooManyListenersException {
        if (this.uploadListener != null) {
            throw new TooManyListenersException();
        }
        this.uploadListener = l;
        this.firePropertyChange(UPLOAD_LISTENER_CHANGED_PROPERTY, null, l);
    }

    public void fileUpload(InputStream in, int size, String contentType, String filename) {
        if (this.uploadListener != null) {
            UploadEvent e = new UploadEvent(this, in, size, contentType, filename);
            if (size == 0) {
                this.uploadListener.invalidFileUpload(e);
            } else {
                this.uploadListener.fileUpload(e);
            }
        }
    }

    public Extent getHeight() {
        return (Extent)this.getProperty(PROPERTY_HEIGHT);
    }

    public String getDisabledSendButtonText() {
        return (String)this.getProperty(PROPERTY_DISABLED_SEND_TEXT);
    }

    public String getEnabledSendButtonText() {
        return (String)this.getProperty(PROPERTY_ENABLED_SEND_TEXT);
    }

    public UploadListener getUploadListener() {
        return this.uploadListener;
    }

    public Extent getWidth() {
        return (Extent)this.getProperty(PROPERTY_WIDTH);
    }

    public void removeUploadListener(UploadListener l) {
        if (l.equals(this.uploadListener)) {
            this.uploadListener = null;
        }
    }

    public void setHeight(Extent newValue) {
        this.setProperty(PROPERTY_HEIGHT, newValue);
    }

    public void setUploadListener(UploadListener newValue) {
        UploadListener oldValue = this.uploadListener;
        this.uploadListener = newValue;
        this.firePropertyChange(UPLOAD_LISTENER_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setWidth(Extent newValue) {
        this.setProperty(PROPERTY_WIDTH, newValue);
    }

    public void setDisabledSendButtonText(String string) {
        this.setProperty(PROPERTY_DISABLED_SEND_TEXT, string);
    }

    public void setEnabledSendButtonText(String string) {
        this.setProperty(PROPERTY_ENABLED_SEND_TEXT, string);
    }

    public boolean isSendButtonDisplayed() {
        Boolean displayed = (Boolean)this.getProperty(PROPERTY_DISPLAY_SEND_BUTTON);
        if (displayed == null) {
            displayed = Boolean.TRUE;
        }
        return displayed;
    }

    public void setSendButtonDisplayed(boolean b) {
        this.setProperty(PROPERTY_DISPLAY_SEND_BUTTON, b);
    }
}

