/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.app.componentxml.propertypeer;

import java.util.StringTokenizer;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.componentxml.InvalidPropertyException;
import nextapp.echo2.app.componentxml.PropertyXmlPeer;
import nextapp.echo2.app.componentxml.propertypeer.ExtentPeer;
import org.w3c.dom.Element;

public class InsetsPeer
implements PropertyXmlPeer {
    public static Insets toInsets(String value) throws InvalidPropertyException {
        StringTokenizer st = new StringTokenizer(value, " ");
        int count = st.countTokens();
        switch (count) {
            case 1: {
                Extent extent = ExtentPeer.toExtent(st.nextToken());
                return new Insets(extent);
            }
            case 2: {
                Extent horizontal = ExtentPeer.toExtent(st.nextToken());
                Extent vertical = ExtentPeer.toExtent(st.nextToken());
                return new Insets(horizontal, vertical);
            }
            case 4: {
                Extent left = ExtentPeer.toExtent(st.nextToken());
                Extent top = ExtentPeer.toExtent(st.nextToken());
                Extent right = ExtentPeer.toExtent(st.nextToken());
                Extent bottom = ExtentPeer.toExtent(st.nextToken());
                return new Insets(left, top, right, bottom);
            }
        }
        throw new InvalidPropertyException("Invalid Insets value: " + value, null);
    }

    @Override
    public Object getValue(ClassLoader classLoader, Class objectClass, Element propertyElement) throws InvalidPropertyException {
        String value = propertyElement.getAttribute("value");
        return InsetsPeer.toInsets(value);
    }
}

