/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.app.componentxml.propertypeer;

import nextapp.echo2.app.Extent;
import nextapp.echo2.app.FillImage;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.componentxml.InvalidPropertyException;
import nextapp.echo2.app.componentxml.PropertyLoader;
import nextapp.echo2.app.componentxml.PropertyXmlPeer;
import nextapp.echo2.app.componentxml.propertypeer.ExtentPeer;
import nextapp.echo2.app.util.DomUtil;
import org.w3c.dom.Element;

public class FillImagePeer
implements PropertyXmlPeer {
    @Override
    public Object getValue(ClassLoader classLoader, Class objectClass, Element propertyElement) throws InvalidPropertyException {
        Class<?> propertyClass;
        Element fillImageElement = DomUtil.getChildElementByTagName(propertyElement, "fill-image");
        if (fillImageElement == null) {
            throw new InvalidPropertyException("Invalid FillImage property.", null);
        }
        Extent offsetX = fillImageElement.hasAttribute("horizontal") ? ExtentPeer.toExtent(fillImageElement.getAttribute("horizontal")) : null;
        Extent offsetY = fillImageElement.hasAttribute("vertical") ? ExtentPeer.toExtent(fillImageElement.getAttribute("vertical")) : null;
        String repeatString = fillImageElement.getAttribute("repeat");
        int repeat = "horizontal".equals(repeatString) ? 1 : ("vertical".equals(repeatString) ? 2 : ("none".equals(repeatString) ? 0 : 3));
        Element imageElement = DomUtil.getChildElementByTagName(fillImageElement, "image");
        if (imageElement == null) {
            throw new InvalidPropertyException("Invalid FillImage property.", null);
        }
        String imageType = imageElement.getAttribute("type");
        PropertyLoader propertyLoader = PropertyLoader.forClassLoader(classLoader);
        try {
            propertyClass = Class.forName(imageType, true, classLoader);
        }
        catch (ClassNotFoundException ex) {
            throw new InvalidPropertyException("Invalid FillImage property (type \"" + imageType + "\" not found.", ex);
        }
        Object imagePropertyValue = propertyLoader.getPropertyValue(FillImage.class, propertyClass, imageElement);
        if (!(imagePropertyValue instanceof ImageReference)) {
            throw new InvalidPropertyException("Invalid FillImage property (type \"" + imageType + "\" is not an ImageReference.", null);
        }
        ImageReference imageReference = (ImageReference)imagePropertyValue;
        FillImage fillImage = new FillImage(imageReference, offsetX, offsetY, repeat);
        return fillImage;
    }
}

