/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.app.componentxml.propertypeer;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.componentxml.InvalidPropertyException;
import nextapp.echo2.app.componentxml.PropertyXmlPeer;
import nextapp.echo2.app.componentxml.propertypeer.ColorPeer;
import nextapp.echo2.app.componentxml.propertypeer.ExtentPeer;
import nextapp.echo2.app.util.DomUtil;
import org.w3c.dom.Element;

public class BorderPeer
implements PropertyXmlPeer {
    private static final Map STYLE_TEXT_TO_CONSTANT;

    @Override
    public Object getValue(ClassLoader classLoader, Class objectClass, Element propertyElement) throws InvalidPropertyException {
        int style;
        Element borderElement = DomUtil.getChildElementByTagName(propertyElement, "border");
        Color color = borderElement.hasAttribute("color") ? ColorPeer.toColor(borderElement.getAttribute("color")) : null;
        Extent size = borderElement.hasAttribute("size") ? ExtentPeer.toExtent(borderElement.getAttribute("size")) : null;
        String styleString = borderElement.getAttribute("style");
        if (styleString == null) {
            style = 0;
        } else {
            if (!STYLE_TEXT_TO_CONSTANT.containsKey(styleString)) {
                throw new IllegalArgumentException("Invalid border style: " + styleString);
            }
            style = (Integer)STYLE_TEXT_TO_CONSTANT.get(styleString);
        }
        return new Border(size, color, style);
    }

    static {
        HashMap<String, Integer> constantMap = new HashMap<String, Integer>();
        constantMap.put("dashed", new Integer(8));
        constantMap.put("dotted", new Integer(7));
        constantMap.put("double", new Integer(6));
        constantMap.put("groove", new Integer(4));
        constantMap.put("inset", new Integer(2));
        constantMap.put("none", new Integer(0));
        constantMap.put("outset", new Integer(3));
        constantMap.put("ridge", new Integer(5));
        constantMap.put("solid", new Integer(1));
        STYLE_TEXT_TO_CONSTANT = Collections.unmodifiableMap(constantMap);
    }
}

