/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.app.componentxml.propertypeer;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.componentxml.InvalidPropertyException;
import nextapp.echo2.app.componentxml.PropertyXmlPeer;
import nextapp.echo2.app.util.DomUtil;
import org.w3c.dom.Element;

public class AlignmentPeer
implements PropertyXmlPeer {
    private static final Map HORIZONTAL_CONSTANTS;
    private static final Map VERTICAL_CONSTANTS;

    @Override
    public Object getValue(ClassLoader classLoader, Class objectClass, Element propertyElement) throws InvalidPropertyException {
        Integer verticalValue;
        Integer horizontalValue;
        Element alignmentElement = DomUtil.getChildElementByTagName(propertyElement, "alignment");
        int horizontal = 0;
        int vertical = 0;
        if (alignmentElement.hasAttribute("horizontal") && (horizontalValue = (Integer)HORIZONTAL_CONSTANTS.get(alignmentElement.getAttribute("horizontal"))) != null) {
            horizontal = horizontalValue;
        }
        if (alignmentElement.hasAttribute("vertical") && (verticalValue = (Integer)VERTICAL_CONSTANTS.get(alignmentElement.getAttribute("vertical"))) != null) {
            vertical = verticalValue;
        }
        return new Alignment(horizontal, vertical);
    }

    static {
        HashMap<String, Integer> constantMap = new HashMap<String, Integer>();
        constantMap.put("leading", new Integer(1));
        constantMap.put("trailing", new Integer(2));
        constantMap.put("left", new Integer(3));
        constantMap.put("center", new Integer(4));
        constantMap.put("right", new Integer(5));
        HORIZONTAL_CONSTANTS = Collections.unmodifiableMap(constantMap);
        constantMap = new HashMap();
        constantMap.put("top", new Integer(6));
        constantMap.put("center", new Integer(4));
        constantMap.put("bottom", new Integer(7));
        VERTICAL_CONSTANTS = Collections.unmodifiableMap(constantMap);
    }
}

