/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.app.componentxml;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import nextapp.echo2.app.DerivedMutableStyle;
import nextapp.echo2.app.MutableStyleSheet;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.StyleSheet;
import nextapp.echo2.app.componentxml.ComponentXmlException;
import nextapp.echo2.app.componentxml.PropertyLoader;
import nextapp.echo2.app.util.DomUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class StyleSheetLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StyleSheet load(String resourceName, ClassLoader classLoader) throws ComponentXmlException {
        InputStream in = null;
        in = classLoader.getResourceAsStream(resourceName);
        if (in == null) {
            StyleSheet styleSheet = null;
            return styleSheet;
        }
        StyleSheet styleSheet = StyleSheetLoader.load(in, classLoader);
        return styleSheet;
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static StyleSheet load(InputStream in, ClassLoader classLoader) throws ComponentXmlException {
        Class<?> componentClass;
        String type;
        String name;
        int i;
        Document document;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    throw new SAXException("External entities not supported.");
                }
            });
            document = builder.parse(in);
        }
        catch (IOException ex) {
            throw new ComponentXmlException("Failed to parse InputStream.", ex);
        }
        catch (ParserConfigurationException ex) {
            throw new ComponentXmlException("Failed to parse InputStream.", ex);
        }
        catch (SAXException ex) {
            throw new ComponentXmlException("Failed to parse InputStream.", ex);
        }
        PropertyLoader propertyLoader = PropertyLoader.forClassLoader(classLoader);
        HashMap namedStyleMap = new HashMap();
        MutableStyleSheet styleSheet = new MutableStyleSheet();
        Element styleSheetElement = document.getDocumentElement();
        Element[] styleElements = DomUtil.getChildElementsByTagName(styleSheetElement, "style");
        for (i = 0; i < styleElements.length; ++i) {
            name = styleElements[i].getAttribute("name");
            if (!styleElements[i].hasAttribute("type")) {
                throw new ComponentXmlException("Component type not specified in style: " + name, null);
            }
            type = styleElements[i].getAttribute("type");
            try {
                componentClass = Class.forName(type, true, classLoader);
            }
            catch (ClassNotFoundException ex) {
                continue;
            }
            DerivedMutableStyle style = new DerivedMutableStyle();
            Element propertiesElement = DomUtil.getChildElementByTagName(styleElements[i], "properties");
            Style propertyStyle = propertyLoader.createStyle(propertiesElement, type);
            style.addStyleContent(propertyStyle);
            HashMap classToStyleMap = (HashMap)namedStyleMap.get(name);
            if (classToStyleMap == null) {
                classToStyleMap = new HashMap();
                namedStyleMap.put(name, classToStyleMap);
            }
            classToStyleMap.put(componentClass, style);
            styleSheet.addStyle(componentClass, name, style);
        }
        for (i = 0; i < styleElements.length; ++i) {
            if (!styleElements[i].hasAttribute("base-name")) continue;
            name = styleElements[i].getAttribute("name");
            type = styleElements[i].getAttribute("type");
            try {
            }
            catch (ClassNotFoundException ex) {
                continue;
            }
            Map classToStyleMap = (Map)namedStyleMap.get(name);
            DerivedMutableStyle style = (DerivedMutableStyle)classToStyleMap.get(componentClass);
            String baseName = styleElements[i].getAttribute("base-name");
            classToStyleMap = (Map)namedStyleMap.get(baseName);
            if (classToStyleMap == null) {
                throw new ComponentXmlException("Invalid base style name for style name " + name + ".", null);
            }
            Style baseStyle = (Style)classToStyleMap.get(componentClass);
            for (componentClass = Class.forName(type, true, classLoader); baseStyle == null && componentClass != Object.class; componentClass = componentClass.getSuperclass()) {
                baseStyle = (Style)classToStyleMap.get(componentClass);
            }
            if (baseStyle == null) {
                throw new ComponentXmlException("Invalid base style name for style name " + name + ".", null);
            }
            style.setParentStyle(baseStyle);
        }
        return styleSheet;
    }
}

