/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.app.button;

import java.util.EventListener;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.button.AbstractButton;
import nextapp.echo2.app.button.ButtonModel;
import nextapp.echo2.app.button.ToggleButtonModel;
import nextapp.echo2.app.event.ChangeEvent;
import nextapp.echo2.app.event.ChangeListener;

public abstract class ToggleButton
extends AbstractButton {
    public static final String PROPERTY_PRESSED_STATE_ICON = "pressedStateIcon";
    public static final String PROPERTY_PRESSED_SELECTED_STATE_ICON = "pressedSelectedStateIcon";
    public static final String PROPERTY_ROLLOVER_STATE_ICON = "rolloverStateIcon";
    public static final String PROPERTY_ROLLOVER_SELECTED_STATE_ICON = "rolloverSelectedStateIcon";
    public static final String PROPERTY_STATE_ALIGNMENT = "stateAlignment";
    public static final String PROPERTY_STATE_ICON = "stateIcon";
    public static final String PROPERTY_STATE_MARGIN = "stateMargin";
    public static final String PROPERTY_STATE_POSITION = "statePosition";
    public static final String PROPERTY_SELECTED_STATE_ICON = "selectedStateIcon";
    public static final String SELECTED_CHANGED_PROPERTY = "selected";
    private ChangeListener changeForwarder = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            ToggleButton.this.fireStateChanged();
            if (ToggleButton.this.isSelected()) {
                ToggleButton.this.firePropertyChange(ToggleButton.SELECTED_CHANGED_PROPERTY, Boolean.FALSE, Boolean.TRUE);
            } else {
                ToggleButton.this.firePropertyChange(ToggleButton.SELECTED_CHANGED_PROPERTY, Boolean.TRUE, Boolean.FALSE);
            }
        }
    };

    public void addChangeListener(ChangeListener l) {
        this.getEventListenerList().addListener(ChangeListener.class, l);
    }

    public void fireStateChanged() {
        EventListener[] listeners = this.getEventListenerList().getListeners(ChangeListener.class);
        ChangeEvent e = new ChangeEvent(this);
        for (int index = 0; index < listeners.length; ++index) {
            ((ChangeListener)listeners[index]).stateChanged(e);
        }
    }

    public ImageReference getPressedSelectedStateIcon() {
        return (ImageReference)this.getProperty(PROPERTY_PRESSED_SELECTED_STATE_ICON);
    }

    public ImageReference getPressedStateIcon() {
        return (ImageReference)this.getProperty(PROPERTY_PRESSED_STATE_ICON);
    }

    public ImageReference getRolloverSelectedStateIcon() {
        return (ImageReference)this.getProperty(PROPERTY_ROLLOVER_SELECTED_STATE_ICON);
    }

    public ImageReference getRolloverStateIcon() {
        return (ImageReference)this.getProperty(PROPERTY_ROLLOVER_STATE_ICON);
    }

    public ImageReference getSelectedStateIcon() {
        return (ImageReference)this.getProperty(PROPERTY_SELECTED_STATE_ICON);
    }

    public Alignment getStateAlignment() {
        return (Alignment)this.getProperty(PROPERTY_STATE_ALIGNMENT);
    }

    public ImageReference getStateIcon() {
        return (ImageReference)this.getProperty(PROPERTY_STATE_ICON);
    }

    public Extent getStateMargin() {
        return (Extent)this.getProperty(PROPERTY_STATE_MARGIN);
    }

    public Alignment getStatePosition() {
        return (Alignment)this.getProperty(PROPERTY_STATE_POSITION);
    }

    public boolean isSelected() {
        return ((ToggleButtonModel)this.getModel()).isSelected();
    }

    @Override
    public void processInput(String name, Object value) {
        super.processInput(name, value);
        if (SELECTED_CHANGED_PROPERTY.equals(name)) {
            this.setSelected((Boolean)value);
        }
    }

    public void removeChangeListener(ChangeListener l) {
        this.getEventListenerList().removeListener(ChangeListener.class, l);
    }

    @Override
    public void setModel(ButtonModel newValue) {
        if (!(newValue instanceof ToggleButtonModel)) {
            throw new IllegalArgumentException("Model is not a ToggleButtonModel.");
        }
        ToggleButtonModel oldValue = (ToggleButtonModel)this.getModel();
        if (oldValue != null) {
            oldValue.removeChangeListener(this.changeForwarder);
        }
        super.setModel(newValue);
        ((ToggleButtonModel)newValue).addChangeListener(this.changeForwarder);
    }

    public void setPressedSelectedStateIcon(ImageReference newValue) {
        this.setProperty(PROPERTY_PRESSED_SELECTED_STATE_ICON, newValue);
    }

    public void setPressedStateIcon(ImageReference newValue) {
        this.setProperty(PROPERTY_PRESSED_STATE_ICON, newValue);
    }

    public void setRolloverSelectedStateIcon(ImageReference newValue) {
        this.setProperty(PROPERTY_ROLLOVER_SELECTED_STATE_ICON, newValue);
    }

    public void setRolloverStateIcon(ImageReference newValue) {
        this.setProperty(PROPERTY_ROLLOVER_STATE_ICON, newValue);
    }

    public void setSelectedStateIcon(ImageReference newValue) {
        this.setProperty(PROPERTY_SELECTED_STATE_ICON, newValue);
    }

    public void setSelected(boolean newValue) {
        ((ToggleButtonModel)this.getModel()).setSelected(newValue);
    }

    public void setStateAlignment(Alignment newValue) {
        this.setProperty(PROPERTY_STATE_ALIGNMENT, newValue);
    }

    public void setStateIcon(ImageReference newValue) {
        this.setProperty(PROPERTY_STATE_ICON, newValue);
    }

    public void setStateMargin(Extent newValue) {
        this.setProperty(PROPERTY_STATE_MARGIN, newValue);
    }

    public void setStatePosition(Alignment newValue) {
        this.setProperty(PROPERTY_STATE_POSITION, newValue);
    }
}

