/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.app;

import java.util.EventListener;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.ContentPane;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.FillImage;
import nextapp.echo2.app.FillImageBorder;
import nextapp.echo2.app.FloatingPane;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.ModalSupport;
import nextapp.echo2.app.PaneContainer;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;

public class WindowPane
extends Component
implements FloatingPane,
ModalSupport,
PaneContainer {
    public static final String INPUT_CLOSE = "input_close";
    public static final String PROPERTY_BACKGROUND_IMAGE = "backgroundImage";
    public static final String PROPERTY_BORDER = "border";
    public static final String PROPERTY_CLOSABLE = "closable";
    public static final String PROPERTY_CLOSE_ICON = "closeIcon";
    public static final String PROPERTY_CLOSE_ICON_INSETS = "closeIconInsets";
    public static final String PROPERTY_DEFAULT_CLOSE_OPERATION = "defaultCloseOperation";
    public static final String PROPERTY_HEIGHT = "height";
    public static final String PROPERTY_ICON = "icon";
    public static final String PROPERTY_ICON_INSETS = "iconInsets";
    public static final String PROPERTY_INSETS = "insets";
    public static final String PROPERTY_MAXIMUM_HEIGHT = "maximumHeight";
    public static final String PROPERTY_MAXIMUM_WIDTH = "maximumWidth";
    public static final String PROPERTY_MINIMUM_HEIGHT = "minimumHeight";
    public static final String PROPERTY_MINIMUM_WIDTH = "minimumWidth";
    public static final String PROPERTY_MOVABLE = "movable";
    public static final String PROPERTY_POSITION_X = "positionX";
    public static final String PROPERTY_POSITION_Y = "positionY";
    public static final String PROPERTY_RESIZABLE = "resizable";
    public static final String PROPERTY_TITLE = "title";
    public static final String PROPERTY_TITLE_BACKGROUND = "titleBackground";
    public static final String PROPERTY_TITLE_BACKGROUND_IMAGE = "titleBackgroundImage";
    public static final String PROPERTY_TITLE_BAR_INSETS = "titleBarInsets";
    public static final String PROPERTY_TITLE_FONT = "titleFont";
    public static final String PROPERTY_TITLE_FOREGROUND = "titleForeground";
    public static final String PROPERTY_TITLE_HEIGHT = "titleHeight";
    public static final String PROPERTY_TITLE_INSETS = "titleInsets";
    public static final String PROPERTY_WIDTH = "width";
    public static final String Z_INDEX_CHANGED_PROPERTY = "zIndex";
    public static final int DO_NOTHING_ON_CLOSE = 0;
    public static final int HIDE_ON_CLOSE = 1;
    public static final int DISPOSE_ON_CLOSE = 2;
    private boolean modal = false;
    private int zIndex = 0;

    public WindowPane() {
        this(null, null, null);
    }

    public WindowPane(String title, Extent width, Extent height) {
        if (title != null) {
            this.setTitle(title);
        }
        if (width != null) {
            this.setWidth(width);
        }
        if (height != null) {
            this.setHeight(height);
        }
    }

    public void addWindowPaneListener(WindowPaneListener l) {
        this.getEventListenerList().addListener(WindowPaneListener.class, l);
    }

    protected void fireWindowClosing() {
        if (!this.hasEventListenerList()) {
            return;
        }
        EventListener[] listeners = this.getEventListenerList().getListeners(WindowPaneListener.class);
        if (listeners.length == 0) {
            return;
        }
        WindowPaneEvent e = new WindowPaneEvent(this);
        for (int i = 0; i < listeners.length; ++i) {
            ((WindowPaneListener)listeners[i]).windowPaneClosing(e);
        }
    }

    public FillImage getBackgroundImage() {
        return (FillImage)this.getProperty(PROPERTY_BACKGROUND_IMAGE);
    }

    public FillImageBorder getBorder() {
        return (FillImageBorder)this.getProperty(PROPERTY_BORDER);
    }

    public ImageReference getCloseIcon() {
        return (ImageReference)this.getProperty(PROPERTY_CLOSE_ICON);
    }

    public Insets getCloseIconInsets() {
        return (Insets)this.getProperty(PROPERTY_CLOSE_ICON_INSETS);
    }

    public int getDefaultCloseOperation() {
        Integer defaultCloseOperationValue = (Integer)this.getProperty(PROPERTY_DEFAULT_CLOSE_OPERATION);
        return defaultCloseOperationValue == null ? 0 : defaultCloseOperationValue;
    }

    public Extent getHeight() {
        return (Extent)this.getProperty(PROPERTY_HEIGHT);
    }

    public ImageReference getIcon() {
        return (ImageReference)this.getProperty(PROPERTY_ICON);
    }

    public Insets getIconInsets() {
        return (Insets)this.getProperty(PROPERTY_ICON_INSETS);
    }

    public Insets getInsets() {
        return (Insets)this.getProperty(PROPERTY_INSETS);
    }

    public Extent getMaximumHeight() {
        return (Extent)this.getProperty(PROPERTY_MAXIMUM_HEIGHT);
    }

    public Extent getMaximumWidth() {
        return (Extent)this.getProperty(PROPERTY_MAXIMUM_WIDTH);
    }

    public Extent getMinimumHeight() {
        return (Extent)this.getProperty(PROPERTY_MINIMUM_HEIGHT);
    }

    public Extent getMinimumWidth() {
        return (Extent)this.getProperty(PROPERTY_MINIMUM_WIDTH);
    }

    public Extent getPositionX() {
        return (Extent)this.getProperty(PROPERTY_POSITION_X);
    }

    public Extent getPositionY() {
        return (Extent)this.getProperty(PROPERTY_POSITION_Y);
    }

    public String getTitle() {
        return (String)this.getProperty(PROPERTY_TITLE);
    }

    public Color getTitleBackground() {
        return (Color)this.getProperty(PROPERTY_TITLE_BACKGROUND);
    }

    public FillImage getTitleBackgroundImage() {
        return (FillImage)this.getProperty(PROPERTY_TITLE_BACKGROUND_IMAGE);
    }

    public Insets getTitleBarInsets() {
        return (Insets)this.getProperty(PROPERTY_TITLE_BAR_INSETS);
    }

    public Font getTitleFont() {
        return (Font)this.getProperty(PROPERTY_TITLE_FONT);
    }

    public Color getTitleForeground() {
        return (Color)this.getProperty(PROPERTY_TITLE_FOREGROUND);
    }

    public Extent getTitleHeight() {
        return (Extent)this.getProperty(PROPERTY_TITLE_HEIGHT);
    }

    public Insets getTitleInsets() {
        return (Insets)this.getProperty(PROPERTY_TITLE_INSETS);
    }

    public Extent getWidth() {
        return (Extent)this.getProperty(PROPERTY_WIDTH);
    }

    public int getZIndex() {
        return this.zIndex;
    }

    public boolean isClosable() {
        Boolean value = (Boolean)this.getProperty(PROPERTY_CLOSABLE);
        return value == null ? true : value;
    }

    @Override
    public boolean isModal() {
        return this.modal;
    }

    public boolean isMovable() {
        Boolean value = (Boolean)this.getProperty(PROPERTY_MOVABLE);
        return value == null ? true : value;
    }

    public boolean isResizable() {
        Boolean value = (Boolean)this.getProperty(PROPERTY_RESIZABLE);
        return value == null ? true : value;
    }

    @Override
    public boolean isValidChild(Component component) {
        return this.getComponentCount() == 0;
    }

    @Override
    public boolean isValidParent(Component parent) {
        return parent instanceof ContentPane;
    }

    @Override
    public void processInput(String inputName, Object inputValue) {
        if (INPUT_CLOSE.equals(inputName)) {
            this.userClose();
        } else if (PROPERTY_POSITION_X.equals(inputName)) {
            this.setPositionX((Extent)inputValue);
        } else if (PROPERTY_POSITION_Y.equals(inputName)) {
            this.setPositionY((Extent)inputValue);
        } else if (PROPERTY_WIDTH.equals(inputName)) {
            this.setWidth((Extent)inputValue);
        } else if (PROPERTY_HEIGHT.equals(inputName)) {
            this.setHeight((Extent)inputValue);
        } else if (Z_INDEX_CHANGED_PROPERTY.equals(inputName)) {
            this.setZIndex((Integer)inputValue);
        }
    }

    public void setBackgroundImage(FillImage newValue) {
        this.setProperty(PROPERTY_BACKGROUND_IMAGE, newValue);
    }

    public void setBorder(FillImageBorder newValue) {
        this.setProperty(PROPERTY_BORDER, newValue);
    }

    public void setClosable(boolean newValue) {
        this.setProperty(PROPERTY_CLOSABLE, newValue);
    }

    public void setCloseIcon(ImageReference newValue) {
        this.setProperty(PROPERTY_CLOSE_ICON, newValue);
    }

    public void setCloseIconInsets(Insets newValue) {
        this.setProperty(PROPERTY_CLOSE_ICON_INSETS, newValue);
    }

    public void setDefaultCloseOperation(int newValue) {
        this.setProperty(PROPERTY_DEFAULT_CLOSE_OPERATION, new Integer(newValue));
    }

    public void setHeight(Extent newValue) {
        Extent.validate(newValue, 1);
        this.setProperty(PROPERTY_HEIGHT, newValue);
    }

    public void setIcon(ImageReference newValue) {
        this.setProperty(PROPERTY_ICON, newValue);
    }

    public void setIconInsets(Insets newValue) {
        this.setProperty(PROPERTY_ICON_INSETS, newValue);
    }

    public void setInsets(Insets newValue) {
        this.setProperty(PROPERTY_INSETS, newValue);
    }

    public void setMaximumHeight(Extent newValue) {
        Extent.validate(newValue, 1);
        this.setProperty(PROPERTY_MAXIMUM_HEIGHT, newValue);
    }

    public void setMaximumWidth(Extent newValue) {
        Extent.validate(newValue, 1);
        this.setProperty(PROPERTY_MAXIMUM_WIDTH, newValue);
    }

    public void setMinimumHeight(Extent newValue) {
        Extent.validate(newValue, 1);
        this.setProperty(PROPERTY_MINIMUM_HEIGHT, newValue);
    }

    public void setMinimumWidth(Extent newValue) {
        Extent.validate(newValue, 1);
        this.setProperty(PROPERTY_MINIMUM_WIDTH, newValue);
    }

    @Override
    public void setModal(boolean newValue) {
        boolean oldValue = this.modal;
        this.modal = newValue;
        this.firePropertyChange("modal", oldValue, newValue);
    }

    public void setMovable(boolean newValue) {
        this.setProperty(PROPERTY_MOVABLE, newValue);
    }

    public void setPositionX(Extent newValue) {
        Extent.validate(newValue, 1);
        this.setProperty(PROPERTY_POSITION_X, newValue);
    }

    public void setPositionY(Extent newValue) {
        Extent.validate(newValue, 1);
        this.setProperty(PROPERTY_POSITION_Y, newValue);
    }

    public void setResizable(boolean newValue) {
        this.setProperty(PROPERTY_RESIZABLE, newValue);
    }

    public void setTitle(String newValue) {
        this.setProperty(PROPERTY_TITLE, newValue);
    }

    public void setTitleBackground(Color newValue) {
        this.setProperty(PROPERTY_TITLE_BACKGROUND, newValue);
    }

    public void setTitleBackgroundImage(FillImage newValue) {
        this.setProperty(PROPERTY_TITLE_BACKGROUND_IMAGE, newValue);
    }

    public void setTitleBarInsets(Insets newValue) {
        this.setProperty(PROPERTY_TITLE_BAR_INSETS, newValue);
    }

    public void setTitleFont(Font newValue) {
        this.setProperty(PROPERTY_TITLE_FONT, newValue);
    }

    public void setTitleForeground(Color newValue) {
        this.setProperty(PROPERTY_TITLE_FOREGROUND, newValue);
    }

    public void setTitleHeight(Extent newValue) {
        Extent.validate(newValue, 1);
        this.setProperty(PROPERTY_TITLE_HEIGHT, newValue);
    }

    public void setTitleInsets(Insets newValue) {
        this.setProperty(PROPERTY_TITLE_INSETS, newValue);
    }

    public void setWidth(Extent newValue) {
        Extent.validate(newValue, 1);
        this.setProperty(PROPERTY_WIDTH, newValue);
    }

    public void setZIndex(int newValue) {
        int oldValue = this.zIndex;
        this.zIndex = newValue;
        this.firePropertyChange(Z_INDEX_CHANGED_PROPERTY, new Integer(oldValue), new Integer(newValue));
    }

    public void removeWindowPaneListener(WindowPaneListener l) {
        if (!this.hasEventListenerList()) {
            return;
        }
        this.getEventListenerList().removeListener(WindowPaneListener.class, l);
    }

    public void userClose() {
        this.fireWindowClosing();
        Integer defaultCloseOperationValue = (Integer)this.getRenderProperty(PROPERTY_DEFAULT_CLOSE_OPERATION);
        int defaultCloseOperation = defaultCloseOperationValue == null ? 2 : defaultCloseOperationValue;
        switch (defaultCloseOperation) {
            case 2: {
                this.getParent().remove(this);
                break;
            }
            case 1: {
                this.setVisible(false);
            }
        }
    }
}

