/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.app;

import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.FillImage;
import nextapp.echo2.app.Pane;
import nextapp.echo2.app.PaneContainer;

public class SplitPane
extends Component
implements Pane,
PaneContainer {
    public static final int ORIENTATION_HORIZONTAL_LEADING_TRAILING = 1;
    public static final int ORIENTATION_HORIZONTAL_TRAILING_LEADING = 2;
    public static final int ORIENTATION_HORIZONTAL_LEFT_RIGHT = 3;
    public static final int ORIENTATION_HORIZONTAL_RIGHT_LEFT = 4;
    public static final int ORIENTATION_VERTICAL_TOP_BOTTOM = 5;
    public static final int ORIENTATION_VERTICAL_BOTTOM_TOP = 6;
    public static final int ORIENTATION_HORIZONTAL = 1;
    public static final int ORIENTATION_VERTICAL = 5;
    public static final String PROPERTY_ORIENTATION = "orientation";
    public static final String PROPERTY_RESIZABLE = "resizable";
    public static final String PROPERTY_SEPARATOR_COLOR = "separatorColor";
    public static final String PROPERTY_SEPARATOR_HEIGHT = "separatorHeight";
    public static final String PROPERTY_SEPARATOR_HORIZONTAL_IMAGE = "separatorHorizontalImage";
    public static final String PROPERTY_SEPARATOR_POSITION = "separatorPosition";
    public static final String PROPERTY_SEPARATOR_WIDTH = "separatorWidth";
    public static final String PROPERTY_SEPARATOR_VERTICAL_IMAGE = "separatorVerticalImage";

    public SplitPane() {
    }

    public SplitPane(int orientation) {
        this.setOrientation(orientation);
    }

    public SplitPane(int orientation, Extent separatorPosition) {
        this.setOrientation(orientation);
        if (separatorPosition != null) {
            this.setSeparatorPosition(separatorPosition);
        }
    }

    public int getOrientation() {
        Integer orientation = (Integer)this.getProperty(PROPERTY_ORIENTATION);
        return orientation == null ? 5 : orientation;
    }

    public Color getSeparatorColor() {
        return (Color)this.getProperty(PROPERTY_SEPARATOR_COLOR);
    }

    public Extent getSeparatorHeight() {
        return (Extent)this.getProperty(PROPERTY_SEPARATOR_HEIGHT);
    }

    public FillImage getSeparatorHorizontalImage() {
        return (FillImage)this.getProperty(PROPERTY_SEPARATOR_HORIZONTAL_IMAGE);
    }

    public Extent getSeparatorPosition() {
        return (Extent)this.getProperty(PROPERTY_SEPARATOR_POSITION);
    }

    public FillImage getSeparatorVerticalImage() {
        return (FillImage)this.getProperty(PROPERTY_SEPARATOR_VERTICAL_IMAGE);
    }

    public Extent getSeparatorWidth() {
        return (Extent)this.getProperty(PROPERTY_SEPARATOR_WIDTH);
    }

    public boolean isResizable() {
        Boolean value = (Boolean)this.getProperty(PROPERTY_RESIZABLE);
        return value == null ? false : value;
    }

    @Override
    public boolean isValidChild(Component component) {
        return this.getComponentCount() <= 1;
    }

    @Override
    public boolean isValidParent(Component parent) {
        return parent instanceof PaneContainer;
    }

    @Override
    public void processInput(String inputName, Object inputValue) {
        if (PROPERTY_SEPARATOR_POSITION.equals(inputName)) {
            this.setSeparatorPosition((Extent)inputValue);
        }
    }

    public void setOrientation(int newValue) {
        this.setProperty(PROPERTY_ORIENTATION, new Integer(newValue));
    }

    public void setResizable(boolean newValue) {
        this.setProperty(PROPERTY_RESIZABLE, new Boolean(newValue));
    }

    public void setSeparatorColor(Color newValue) {
        this.setProperty(PROPERTY_SEPARATOR_COLOR, newValue);
    }

    public void setSeparatorHeight(Extent newValue) {
        Extent.validate(newValue, 1);
        this.setProperty(PROPERTY_SEPARATOR_HEIGHT, newValue);
    }

    public void setSeparatorHorizontalImage(FillImage newValue) {
        this.setProperty(PROPERTY_SEPARATOR_HORIZONTAL_IMAGE, newValue);
    }

    public void setSeparatorPosition(Extent newValue) {
        Extent.validate(newValue, 1);
        if (newValue != null && newValue.getValue() < 0) {
            throw new IllegalArgumentException("Extent value may not be negative.");
        }
        this.setProperty(PROPERTY_SEPARATOR_POSITION, newValue);
    }

    public void setSeparatorVerticalImage(FillImage newValue) {
        this.setProperty(PROPERTY_SEPARATOR_VERTICAL_IMAGE, newValue);
    }

    public void setSeparatorWidth(Extent newValue) {
        Extent.validate(newValue, 1);
        this.setProperty(PROPERTY_SEPARATOR_WIDTH, newValue);
    }
}

