/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.app;

import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.button.ButtonGroup;
import nextapp.echo2.app.button.ButtonModel;
import nextapp.echo2.app.button.DefaultToggleButtonModel;
import nextapp.echo2.app.button.ToggleButton;
import nextapp.echo2.app.button.ToggleButtonModel;
import nextapp.echo2.app.event.ChangeEvent;
import nextapp.echo2.app.event.ChangeListener;

public class RadioButton
extends ToggleButton {
    public static final String BUTTON_GROUP_CHANGED_PROPERTY = "buttonGroup";
    private ChangeListener changeMonitor = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            if (RadioButton.this.buttonGroup != null) {
                RadioButton.this.buttonGroup.updateSelection(RadioButton.this);
            }
        }
    };
    private ButtonGroup buttonGroup;

    public RadioButton() {
        this(null, null);
    }

    public RadioButton(String text) {
        this(text, null);
    }

    public RadioButton(ImageReference icon) {
        this(null, icon);
    }

    public RadioButton(String text, ImageReference icon) {
        this.setModel(new DefaultToggleButtonModel());
        this.setIcon(icon);
        this.setText(text);
    }

    public ButtonGroup getGroup() {
        return this.buttonGroup;
    }

    public void setGroup(ButtonGroup newValue) {
        ButtonGroup oldValue = this.buttonGroup;
        this.buttonGroup = newValue;
        if (oldValue != null) {
            oldValue.removeButton(this);
        }
        if (newValue != null) {
            newValue.addButton(this);
        }
        this.firePropertyChange(BUTTON_GROUP_CHANGED_PROPERTY, oldValue, newValue);
    }

    @Override
    public void setModel(ButtonModel newValue) {
        ButtonModel oldValue = this.getModel();
        super.setModel(newValue);
        if (oldValue != null) {
            ((ToggleButtonModel)oldValue).removeChangeListener(this.changeMonitor);
        }
        ((ToggleButtonModel)newValue).addChangeListener(this.changeMonitor);
        if (this.buttonGroup != null) {
            this.buttonGroup.updateSelection(this);
        }
    }
}

