/*
 * Decompiled with CFR 0.152.
 */
package echopointng.util.collections;

import echopointng.util.collections.ExpiryCache;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public class TimerExpiryCache
extends ExpiryCache {
    public static final long DEFAULT_REAPER_INTERVAL = 120000L;
    private static List allExpiryCaches = new ArrayList();
    private static Timer reaperTimer = new Timer(true);

    public TimerExpiryCache() {
        this(3600000L, 300000L, true);
    }

    public TimerExpiryCache(long timeToLive, long accessTimeout) {
        this(timeToLive, accessTimeout, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimerExpiryCache(long timeToLive, long accessTimeout, boolean softReferences) {
        super(timeToLive, accessTimeout, softReferences);
        List list = allExpiryCaches;
        synchronized (list) {
            allExpiryCaches.add(new WeakReference<TimerExpiryCache>(this));
        }
    }

    static {
        reaperTimer.schedule((TimerTask)new ReaperTimerTask(), 120000L, 120000L);
    }

    private static class ReaperTimerTask
    extends TimerTask {
        private ReaperTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread currentThread = Thread.currentThread();
            if (currentThread.getPriority() != 1) {
                currentThread.setPriority(1);
            }
            List list = allExpiryCaches;
            synchronized (list) {
                Iterator iter = allExpiryCaches.iterator();
                while (iter.hasNext()) {
                    WeakReference weakRef = (WeakReference)iter.next();
                    TimerExpiryCache expiryCache = weakRef == null ? null : weakRef.get();
                    if (expiryCache == null) {
                        iter.remove();
                        continue;
                    }
                    ArrayList list2 = new ArrayList();
                    TimerExpiryCache timerExpiryCache = expiryCache;
                    synchronized (timerExpiryCache) {
                        long now = System.currentTimeMillis();
                        Set keys = expiryCache.keySet();
                        for (Object key : keys) {
                            if (!expiryCache.hasExpired(key, now)) continue;
                            list2.add(key);
                        }
                        for (Object key : list2) {
                            expiryCache.put(key, (Object)null);
                        }
                    }
                }
            }
        }
    }
}

