/*
 * Decompiled with CFR 0.152.
 */
package echopointng.util;

import echopointng.util.ExtentKit;
import echopointng.util.TokenizerKit;
import echopointng.util.collections.ConcurrentReaderHashMap;
import java.awt.Font;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Font;

public class FontKit {
    private static Map fontMap = new ConcurrentReaderHashMap();
    private static final Map FONTSTYLE_TEXT_TO_CONSTANT;
    private static final Map TYPEFACE_TEXT_TO_CONSTANT;

    private FontKit() {
    }

    public static Font makeAwtFont(nextapp.echo2.app.Font echoFont, Font awtDefaultFont) {
        if (echoFont == null) {
            return awtDefaultFont;
        }
        int size = echoFont.getSize() == null ? 12 : echoFont.getSize().getValue();
        int style = 0;
        if (echoFont.isBold()) {
            style |= 1;
        }
        if (echoFont.isItalic()) {
            style |= 2;
        }
        if (echoFont.isUnderline()) {
            // empty if block
        }
        if (style == 0) {
            style = 0;
        }
        return new Font(echoFont.getTypeface().getName(), style, size);
    }

    public static String makeCSSFont(nextapp.echo2.app.Font font) {
        StringBuffer sb = new StringBuffer();
        if (font.isBold()) {
            sb.append("bold ");
        }
        if (font.isItalic()) {
            sb.append("italic ");
        }
        if (font.isUnderline()) {
            sb.append("underline ");
        }
        sb.append(font.getSize());
        sb.append(" ");
        int i = 0;
        Font.Typeface face = font.getTypeface();
        while (face != null) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("'");
            sb.append(face.getName());
            sb.append("'");
            face = face.getAlternate();
            ++i;
        }
        return sb.toString();
    }

    public static void addBold(Component c) {
        nextapp.echo2.app.Font font = FontKit.findFont(c);
        font = FontKit.addBold(font);
        c.setFont(font);
    }

    public static void addItalic(Component c) {
        nextapp.echo2.app.Font font = FontKit.findFont(c);
        c.setFont(FontKit.addItalic(font));
    }

    public static void addUnderline(Component c) {
        nextapp.echo2.app.Font font = FontKit.findFont(c);
        c.setFont(FontKit.addUnderline(font));
    }

    public static void addStyle(Component c, int style) {
        nextapp.echo2.app.Font font = FontKit.findFont(c);
        c.setFont(FontKit.addStyle(font, style));
    }

    public static void addSize(Component c, int sizeDelta) {
        nextapp.echo2.app.Font font = FontKit.findFont(c);
        c.setFont(FontKit.addSize(font, sizeDelta));
    }

    public static void setBold(Component c) {
        nextapp.echo2.app.Font font = FontKit.findFont(c);
        c.setFont(FontKit.setStyle(font, 1));
    }

    public static void setItalic(Component c) {
        nextapp.echo2.app.Font font = FontKit.findFont(c);
        c.setFont(FontKit.setStyle(font, 2));
    }

    public static void setUnderline(Component c) {
        nextapp.echo2.app.Font font = FontKit.findFont(c);
        c.setFont(FontKit.setStyle(font, 4));
    }

    public static void setSize(Component c, int size) {
        nextapp.echo2.app.Font font = FontKit.findFont(c);
        c.setFont(FontKit.addSize(font, size));
    }

    public static nextapp.echo2.app.Font findFont(Component comp) {
        while (comp != null) {
            nextapp.echo2.app.Font fnt = comp.getFont();
            if (fnt != null) {
                return fnt;
            }
            comp = comp.getParent();
        }
        return new nextapp.echo2.app.Font(nextapp.echo2.app.Font.SANS_SERIF, 0, new Extent(10, 4));
    }

    public static nextapp.echo2.app.Font makeFont(String fontString) {
        nextapp.echo2.app.Font newFont;
        if (fontString == null) {
            throw new IllegalArgumentException("The fontString must be non null");
        }
        nextapp.echo2.app.Font font = FontKit._getCachedFont(fontString);
        if (font != null) {
            return font;
        }
        if (!FontKit.isFont(fontString)) {
            throw new IllegalArgumentException("The font string is invalid : " + fontString);
        }
        int index = 0;
        String[] tokens = TokenizerKit.tokenize(fontString, "(,)|");
        if (fontString.indexOf("font(") == 0) {
            index = 1;
        }
        String fontName = tokens[index].trim();
        Font.Typeface fontNameVal = FontKit.makeTypeface(fontName);
        int fontStyleVal = 0;
        String fontStyleString = tokens[++index];
        for (int i = index; i < tokens.length && !FontKit._isInteger(fontStyleString = tokens[i].trim()) && !ExtentKit.isExtent(fontStyleString); ++i) {
            String[] arr = TokenizerKit.tokenize(fontStyleString, "|");
            for (int j = 0; j < arr.length; ++j) {
                fontStyleString = arr[j].trim();
                int k = FontKit._getFontStyle(fontStyleString);
                if (k < 0) continue;
                fontStyleVal |= k;
            }
        }
        String fontSize = fontStyleString;
        if (ExtentKit.isExtent(fontSize)) {
            newFont = new nextapp.echo2.app.Font(fontNameVal, fontStyleVal, ExtentKit.makeExtent(fontSize));
        } else {
            int fontSizeVal = Integer.parseInt(fontSize);
            newFont = new nextapp.echo2.app.Font(fontNameVal, fontStyleVal, new Extent(fontSizeVal, 4));
        }
        return FontKit._putCachedFont(fontString, newFont);
    }

    public static nextapp.echo2.app.Font font(String fontString) {
        return FontKit.makeFont(fontString);
    }

    public static boolean isFont(String fontString) {
        if (fontString == null) {
            return false;
        }
        int index = 0;
        String[] tokens = TokenizerKit.tokenize(fontString, "(,)|");
        if (fontString.indexOf("font(") == 0) {
            index = 1;
        }
        if (tokens.length < 2) {
            return false;
        }
        String font = tokens[++index];
        while (index < tokens.length && !FontKit._isInteger(font = tokens[index].trim()) && !ExtentKit.isExtent(font)) {
            String[] arr = TokenizerKit.tokenize(font, "|");
            for (int i = 0; i < arr.length; ++i) {
                font = arr[i].trim();
                if (FontKit._getFontStyle(font) != -1) continue;
                return false;
            }
            ++index;
        }
        String fontSize = font;
        if (!ExtentKit.isExtent(fontSize) && !FontKit._isInteger(fontSize)) {
            return false;
        }
        return index == tokens.length - 1;
    }

    public static Font.Typeface makeTypeface(String typeFaceNames) {
        String[] tokens;
        if (typeFaceNames.charAt(0) == '\'' && typeFaceNames.charAt(typeFaceNames.length() - 1) == '\'') {
            typeFaceNames = typeFaceNames.substring(1, typeFaceNames.length() - 1);
        }
        if ((tokens = TokenizerKit.tokenizeStrict(typeFaceNames, ",")).length == 0) {
            return null;
        }
        Font.Typeface typeFace = FontKit.getSystemTypeface(tokens[0].toUpperCase());
        if (tokens.length == 1 && typeFace != null) {
            return typeFace;
        }
        if (FontKit._exactMatchingTypeFace(typeFace, tokens)) {
            return typeFace;
        }
        typeFace = null;
        for (int i = tokens.length - 1; i >= 0; --i) {
            typeFace = new Font.Typeface(tokens[i], typeFace);
        }
        return typeFace;
    }

    private static boolean _exactMatchingTypeFace(Font.Typeface typeFace, String[] fontNames) {
        if (typeFace == null) {
            return false;
        }
        int i = 0;
        while (typeFace != null) {
            if (i >= fontNames.length) {
                return false;
            }
            if (!fontNames[i].equalsIgnoreCase(typeFace.getName())) {
                return false;
            }
            typeFace = typeFace.getAlternate();
            ++i;
        }
        return true;
    }

    private static nextapp.echo2.app.Font _getCachedFont(String fontString) {
        fontString = fontString.trim().toLowerCase();
        nextapp.echo2.app.Font font = (nextapp.echo2.app.Font)fontMap.get(fontString);
        return font;
    }

    private static nextapp.echo2.app.Font _putCachedFont(String fontString, nextapp.echo2.app.Font font) {
        fontString = fontString.trim().toLowerCase();
        fontMap.put(fontString, font);
        return font;
    }

    private static boolean _isInteger(String propertyValue) {
        try {
            Integer.parseInt(propertyValue.trim());
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static String makeFontString(nextapp.echo2.app.Font font) {
        return FontKit._buildFontString(font.getTypeface(), FontKit._getStyle(font), font.getSize());
    }

    public static Font.Typeface getSystemTypeface(String name) {
        if (TYPEFACE_TEXT_TO_CONSTANT.containsKey(name.toUpperCase())) {
            return (Font.Typeface)TYPEFACE_TEXT_TO_CONSTANT.get(name.toUpperCase());
        }
        return null;
    }

    private static int _getFontStyle(String styleName) {
        Integer styleInt = (Integer)FONTSTYLE_TEXT_TO_CONSTANT.get(styleName.toUpperCase());
        if (styleInt == null) {
            return -1;
        }
        return styleInt;
    }

    private static String _buildFontString(Font.Typeface typeFace, int style, Extent sizeExtent) {
        StringBuffer sb = new StringBuffer();
        sb.append("font(");
        int i = 0;
        while (typeFace != null) {
            if (i > 0) {
                sb.append(", ");
            } else {
                sb.append("'");
            }
            sb.append(typeFace.getName());
            ++i;
            if ((typeFace = typeFace.getAlternate()) != null) continue;
            sb.append("'");
        }
        boolean isplain = true;
        boolean needsOr = false;
        sb.append(",");
        if ((style & 1) == 1) {
            if (needsOr) {
                sb.append("|");
            }
            sb.append("BOLD");
            needsOr = true;
            isplain = false;
        }
        if ((style & 2) == 2) {
            if (needsOr) {
                sb.append("|");
            }
            sb.append("ITALIC");
            needsOr = true;
            isplain = false;
        }
        if ((style & 4) == 4) {
            if (needsOr) {
                sb.append("|");
            }
            sb.append("UNDERLINE");
            needsOr = true;
            isplain = false;
        }
        if ((style & 8) == 8) {
            if (needsOr) {
                sb.append("|");
            }
            sb.append("OVERLINE");
            needsOr = true;
            isplain = false;
        }
        if ((style & 0x10) == 16) {
            if (needsOr) {
                sb.append("|");
            }
            sb.append("LINETHROUGH");
            needsOr = true;
            isplain = false;
        }
        if (isplain) {
            sb.append("PLAIN");
        }
        if (sizeExtent != null) {
            sb.append(",");
            sb.append(sizeExtent.toString());
        }
        sb.append(")");
        return sb.toString();
    }

    private static nextapp.echo2.app.Font _buildFontObj(Font.Typeface typeface, int style, Extent sizeExtent) {
        String fontString = FontKit._buildFontString(typeface, style, sizeExtent);
        return FontKit.makeFont(fontString);
    }

    private static int _addFontStyle(nextapp.echo2.app.Font font, int newStyle) {
        int style = 0;
        if (font.isBold()) {
            style |= 1;
        }
        if (font.isItalic()) {
            style |= 2;
        }
        if (font.isUnderline()) {
            style |= 4;
        }
        return style |= newStyle;
    }

    private static int _getStyle(nextapp.echo2.app.Font font) {
        return FontKit._addFontStyle(font, 0);
    }

    public static nextapp.echo2.app.Font addBold(nextapp.echo2.app.Font font) {
        return FontKit.addStyle(font, 1);
    }

    public static nextapp.echo2.app.Font addItalic(nextapp.echo2.app.Font font) {
        if (font == null) {
            return null;
        }
        return FontKit.addStyle(font, 2);
    }

    public static nextapp.echo2.app.Font addUnderline(nextapp.echo2.app.Font font) {
        return FontKit.addStyle(font, 4);
    }

    public static nextapp.echo2.app.Font addStyle(nextapp.echo2.app.Font font, int style) {
        if (font == null) {
            return null;
        }
        return FontKit._buildFontObj(font.getTypeface(), FontKit._addFontStyle(font, style), font.getSize());
    }

    public static nextapp.echo2.app.Font addSize(nextapp.echo2.app.Font font, int sizeDelta) {
        if (font == null) {
            return null;
        }
        Extent now = font.getSize();
        if (now != null) {
            now = new Extent(now.getValue() + sizeDelta, now.getUnits());
        }
        return FontKit._buildFontObj(font.getTypeface(), FontKit._getStyle(font), now);
    }

    public static nextapp.echo2.app.Font setSize(nextapp.echo2.app.Font font, int size) {
        if (font == null) {
            return null;
        }
        Extent now = font.getSize();
        if (now != null) {
            now = new Extent(size, now.getUnits());
        }
        return FontKit._buildFontObj(font.getTypeface(), FontKit._getStyle(font), now);
    }

    public static nextapp.echo2.app.Font setStyle(nextapp.echo2.app.Font font, int style) {
        if (font == null) {
            return null;
        }
        return FontKit._buildFontObj(font.getTypeface(), style, font.getSize());
    }

    public static nextapp.echo2.app.Font setNames(nextapp.echo2.app.Font font, Font.Typeface typeFace) {
        if (font == null) {
            return null;
        }
        return FontKit._buildFontObj(typeFace, FontKit._getStyle(font), font.getSize());
    }

    public static nextapp.echo2.app.Font setName(nextapp.echo2.app.Font font, String fontName) {
        if (font == null) {
            return null;
        }
        Font.Typeface typeFace = FontKit.makeTypeface(fontName);
        return FontKit._buildFontObj(typeFace, FontKit._getStyle(font), font.getSize());
    }

    static {
        HashMap<String, Serializable> constantMap = new HashMap<String, Serializable>();
        constantMap.put("PLAIN", new Integer(0));
        constantMap.put("FONT.PLAIN", new Integer(0));
        constantMap.put("BOLD", new Integer(1));
        constantMap.put("FONT.BOLD", new Integer(1));
        constantMap.put("ITALIC", new Integer(2));
        constantMap.put("FONT.ITALIC", new Integer(2));
        constantMap.put("LINETHROUGH", new Integer(16));
        constantMap.put("FONT.LINETHROUGH", new Integer(16));
        constantMap.put("OVERLINE", new Integer(8));
        constantMap.put("FONT.OVERLINE", new Integer(8));
        constantMap.put("UNDERLINE", new Integer(4));
        constantMap.put("FONT.UNDERLINE", new Integer(4));
        FONTSTYLE_TEXT_TO_CONSTANT = Collections.unmodifiableMap(constantMap);
        constantMap = new HashMap();
        constantMap.put("HELVETICA", nextapp.echo2.app.Font.HELVETICA);
        constantMap.put("ARIAL", nextapp.echo2.app.Font.ARIAL);
        constantMap.put("VERDANA", nextapp.echo2.app.Font.VERDANA);
        constantMap.put("TIMES", nextapp.echo2.app.Font.TIMES);
        constantMap.put("TIMES ROMAN", nextapp.echo2.app.Font.TIMES_ROMAN);
        constantMap.put("TIMES NEW ROMAN", nextapp.echo2.app.Font.TIMES_NEW_ROMAN);
        constantMap.put("COURIER", nextapp.echo2.app.Font.COURIER);
        constantMap.put("COURIER NEW", nextapp.echo2.app.Font.COURIER_NEW);
        TYPEFACE_TEXT_TO_CONSTANT = Collections.unmodifiableMap(constantMap);
    }
}

