/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.util.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;

public class CapturedPrintWriter
extends PrintWriter {
    private ByteArrayOutputStream out;
    private String characterEncoding;

    public CapturedPrintWriter(ByteArrayOutputStream out, String characterEncoding) {
        super(new StringWriter());
        this.out = out;
        this.characterEncoding = characterEncoding;
    }

    @Override
    public boolean checkError() {
        return false;
    }

    @Override
    public void close() {
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void print(boolean b) {
        this.print(String.valueOf(b));
    }

    @Override
    public void print(char c) {
        this.write(c);
    }

    @Override
    public void print(char[] arr) {
        this.write(arr);
    }

    @Override
    public void print(double d) {
        this.print(String.valueOf(d));
    }

    @Override
    public void print(float f) {
        this.print(String.valueOf(f));
    }

    @Override
    public void print(int i) {
        this.print(String.valueOf(i));
    }

    @Override
    public void print(long l) {
        this.print(String.valueOf(l));
    }

    @Override
    public void print(Object obj) {
        this.print(String.valueOf(obj));
    }

    @Override
    public void print(String s) {
        this.writeBytes(this.toEncodedBytes(s));
    }

    @Override
    public void println() {
        this.write(10);
    }

    @Override
    public void println(boolean x) {
        this.println(String.valueOf(x));
    }

    @Override
    public void println(char x) {
        this.println(String.valueOf(x));
    }

    @Override
    public void println(char[] x) {
        this.write(x);
        this.write(10);
    }

    @Override
    public void println(double x) {
        this.println(String.valueOf(x));
    }

    @Override
    public void println(float x) {
        this.println(String.valueOf(x));
    }

    @Override
    public void println(int x) {
        this.println(String.valueOf(x));
    }

    @Override
    public void println(long x) {
        this.println(String.valueOf(x));
    }

    @Override
    public void println(Object x) {
        this.println(String.valueOf(x));
    }

    @Override
    public void println(String x) {
        this.println(x.toCharArray());
    }

    @Override
    protected void setError() {
    }

    @Override
    public void write(char[] buf, int off, int len) {
        for (int i = off; i < len; ++i) {
            this.write(buf[i]);
        }
    }

    @Override
    public void write(char[] buf) {
        this.write(buf, 0, buf.length);
    }

    @Override
    public void write(int c) {
        this.out.write(c);
    }

    @Override
    public void write(String s, int off, int len) {
        this.writeBytes(this.toEncodedBytes(s), off, len);
    }

    @Override
    public void write(String s) {
        this.writeBytes(this.toEncodedBytes(s));
    }

    private void writeBytes(byte[] buf) {
        this.writeBytes(buf, 0, buf.length);
    }

    private void writeBytes(byte[] buf, int off, int len) {
        for (int i = 0; i < len; ++i) {
            this.write(buf[i + off]);
        }
    }

    private byte[] toEncodedBytes(String s) {
        if (this.characterEncoding != null) {
            try {
                return s.getBytes(this.characterEncoding);
            }
            catch (UnsupportedEncodingException e) {
                return s.getBytes();
            }
        }
        return s.getBytes();
    }
}

