/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.util;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;

public class HtmlNodeLexer {
    private static final String STATE_START = "STATE_START";
    private static final String STATE_ELEMENT = "STATE_ELEMENT";
    private static final String STATE_COMMENT = "STATE_COMMENT";
    private static final String STATE_TEXT = "STATE_TEXT";

    public static String lex(String htmlText, HtmlLexerCallBack callBack) {
        return HtmlNodeLexer.doTokenize(htmlText, callBack, "<>", 0, 0, 1, 255, false, false);
    }

    private static String doTokenize(String str, HtmlLexerCallBack callBack, String delims, int loWhiteSpace, int hiWhiteSpace, int loWordChar, int hiWordChar, boolean useQuotes, boolean noCommonWhiteSpace) {
        StringReader sr = new StringReader(str);
        StreamTokenizer st = new StreamTokenizer(sr);
        st.resetSyntax();
        st.whitespaceChars(loWhiteSpace, hiWhiteSpace);
        st.wordChars(loWordChar, hiWordChar);
        for (int i = 0; i < delims.length(); ++i) {
            st.ordinaryChar(delims.charAt(i));
        }
        if (useQuotes) {
            st.quoteChar(39);
            st.quoteChar(34);
        }
        if (noCommonWhiteSpace) {
            st.wordChars(32, 32);
            st.wordChars(9, 9);
            st.wordChars(10, 10);
            st.wordChars(13, 13);
        }
        try {
            return HtmlNodeLexer.doTokenizeInternal(st, callBack);
        }
        catch (Exception e) {
            return str;
        }
    }

    private static String doTokenizeInternal(StreamTokenizer st, HtmlLexerCallBack callBack) throws IOException {
        StringBuffer sbTextNode = null;
        StringBuffer sbElement = null;
        StringBuffer sbComment = null;
        String state = STATE_START;
        String token = "";
        String prevToken = "";
        StringBuffer sbOut = new StringBuffer();
        int tt = st.nextToken();
        while (tt != -1) {
            prevToken = token;
            token = "";
            switch (tt) {
                case -3: {
                    token = st.sval;
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    token = new String(new char[]{(char)tt});
                }
            }
            if (state == STATE_START) {
                if (token.equals("<")) {
                    state = STATE_ELEMENT;
                    sbElement = new StringBuffer(token);
                } else {
                    state = STATE_TEXT;
                    sbTextNode = new StringBuffer(token);
                }
            } else if (state == STATE_ELEMENT) {
                if (prevToken.equals("<") && token.indexOf("!--") == 0) {
                    sbComment = new StringBuffer();
                    sbComment.append(sbElement);
                    sbComment.append(token);
                    sbElement = null;
                    state = STATE_COMMENT;
                } else if (token.equals(">")) {
                    sbElement.append(token);
                    StringBuffer newElementBuffer = HtmlNodeLexer.nvl(callBack.onElementNode(sbElement));
                    sbOut.append(newElementBuffer);
                    sbElement = null;
                    state = STATE_TEXT;
                    sbTextNode = new StringBuffer();
                } else {
                    sbElement.append(token);
                }
            } else if (state == STATE_COMMENT) {
                if (token.equals(">")) {
                    sbComment.append(token);
                    int endIndex = prevToken.lastIndexOf("--");
                    if (endIndex == prevToken.length() - 2) {
                        StringBuffer newCommentBuffer = HtmlNodeLexer.nvl(callBack.onCommentNode(sbComment));
                        sbOut.append(newCommentBuffer);
                        sbComment = null;
                        state = STATE_TEXT;
                        sbTextNode = new StringBuffer();
                    }
                } else {
                    sbComment.append(token);
                }
            } else if (state == STATE_TEXT) {
                if (token.equals("<")) {
                    if (sbTextNode.length() > 0) {
                        StringBuffer newTextBuffer = HtmlNodeLexer.nvl(callBack.onTextNode(sbTextNode));
                        sbOut.append(newTextBuffer);
                    }
                    sbTextNode = null;
                    sbElement = new StringBuffer(token);
                    state = STATE_ELEMENT;
                } else {
                    sbTextNode.append(token);
                }
            }
            tt = st.nextToken();
        }
        if (sbTextNode != null && sbTextNode.length() > 0) {
            sbTextNode = HtmlNodeLexer.nvl(callBack.onTextNode(sbTextNode));
            sbOut.append(sbTextNode);
        }
        if (sbElement != null && sbElement.length() > 0) {
            sbElement = HtmlNodeLexer.nvl(callBack.onElementNode(sbElement));
            sbOut.append(sbElement);
        }
        if (sbComment != null && sbComment.length() > 0) {
            sbComment = HtmlNodeLexer.nvl(callBack.onCommentNode(sbComment));
            sbOut.append(sbComment);
        }
        return sbOut.toString();
    }

    private static StringBuffer nvl(StringBuffer sb) {
        return sb == null ? new StringBuffer() : sb;
    }

    public static interface HtmlLexerCallBack {
        public StringBuffer onTextNode(StringBuffer var1);

        public StringBuffer onElementNode(StringBuffer var1);

        public StringBuffer onCommentNode(StringBuffer var1);
    }
}

