/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.util;

import echopointng.able.Borderable;
import echopointng.able.Heightable;
import echopointng.able.Insetable;
import echopointng.able.MouseCursorable;
import echopointng.able.Positionable;
import echopointng.able.Scrollable;
import echopointng.able.Widthable;
import echopointng.ui.util.CssKit;
import echopointng.ui.util.CssStyleEx;
import echopointng.ui.util.Render;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.PartialUpdateManager;
import nextapp.echo2.webcontainer.PartialUpdateParticipant;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webrender.servermessage.DomUpdate;

public class AblePartialUpdater
implements PartialUpdateParticipant {
    private static Set handledPropertyNames = new HashSet();
    private static Map handlers = new HashMap();
    private String targetPropertyName;

    private static void initHandler(String propertyName) {
        handledPropertyNames.add(propertyName);
        handlers.put(propertyName, new AblePartialUpdater(propertyName));
    }

    public AblePartialUpdater(String targetPropertyName) {
        this.targetPropertyName = targetPropertyName;
    }

    public static void addToUpdateManager(PartialUpdateManager partialUpdateManager) {
        for (String propertyName : handledPropertyNames) {
            partialUpdateManager.add(propertyName, (PartialUpdateParticipant)handlers.get(propertyName));
        }
    }

    @Override
    public boolean canRenderProperty(RenderContext rc, ServerComponentUpdate update) {
        String[] propertyNames = update.getUpdatedPropertyNames();
        for (int i = 0; i < propertyNames.length; ++i) {
            if (!propertyNames[i].equals(this.targetPropertyName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void renderProperty(RenderContext rc, ServerComponentUpdate update) {
        Component component = update.getParent();
        String elementId = ContainerInstance.getElementId(component);
        String[] propertyNames = update.getUpdatedPropertyNames();
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName = propertyNames[i];
            if (!propertyName.equals(this.targetPropertyName)) continue;
            Object value = update.getParent().getRenderProperty(propertyName);
            if (value == null) {
                this.renderNullUpdate(rc, elementId, component, propertyName);
                continue;
            }
            this.renderUpdatesViaCssStyle(rc, elementId, component, propertyName);
        }
    }

    private void removeBorderStyles(RenderContext rc, String elementId) {
        DomUpdate.renderStyleUpdate(rc.getServerMessage(), elementId, "borderWidth", "");
        DomUpdate.renderStyleUpdate(rc.getServerMessage(), elementId, "borderStyle", "");
        DomUpdate.renderStyleUpdate(rc.getServerMessage(), elementId, "borderColor", "");
    }

    private void renderNullUpdate(RenderContext rc, String elementId, Component component, String propertyName) {
        if (component instanceof Borderable && propertyName.equals("border")) {
            this.removeBorderStyles(rc, elementId);
        } else if (component instanceof Insetable) {
            if (propertyName.equals("insets")) {
                DomUpdate.renderStyleUpdate(rc.getServerMessage(), elementId, "padding", "");
            }
            if (propertyName.equals("outsets")) {
                DomUpdate.renderStyleUpdate(rc.getServerMessage(), elementId, "margin", "");
            }
        } else if (component instanceof MouseCursorable) {
            DomUpdate.renderStyleUpdate(rc.getServerMessage(), elementId, "cursor", "");
            this.renderUpdatesViaCssStyle(rc, elementId, component, propertyName);
        } else {
            DomUpdate.renderStyleUpdate(rc.getServerMessage(), elementId, propertyName, "");
        }
    }

    private void renderUpdatesViaCssStyle(RenderContext rc, String elementId, Component component, String propertyName) {
        boolean ok;
        CssStyleEx styleEx = new CssStyleEx();
        boolean handled = false;
        if (component instanceof Borderable && propertyName.equals("border")) {
            this.removeBorderStyles(rc, elementId);
            Render.asBorderable(styleEx, (Borderable)((Object)component));
            handled = true;
        } else if (component instanceof Heightable && propertyName.equals("height")) {
            Render.asHeightable(styleEx, (Heightable)((Object)component));
            handled = true;
        } else if (component instanceof Insetable && propertyName.equals("insets")) {
            Render.asInsetable(styleEx, (Insetable)((Object)component));
            handled = true;
        } else if (component instanceof Insetable && propertyName.equals("outsets")) {
            Render.asInsetable(styleEx, (Insetable)((Object)component));
            handled = true;
        } else if (component instanceof MouseCursorable && propertyName.equals("mouseCursor")) {
            Render.asMouseCursorable(styleEx, (MouseCursorable)((Object)component));
            handled = true;
        } else if (component instanceof MouseCursorable && propertyName.equals("mouseCursorUri")) {
            Render.asMouseCursorable(styleEx, (MouseCursorable)((Object)component));
            handled = true;
        } else if (component instanceof Widthable && propertyName.equals("width")) {
            Render.asWidthable(styleEx, (Widthable)((Object)component));
            handled = true;
        }
        if (!handled && component instanceof Positionable) {
            ok = false;
            if (propertyName.equals("bottom")) {
                ok = true;
            } else if (propertyName.equals("left")) {
                ok = true;
            } else if (propertyName.equals("position")) {
                ok = true;
            } else if (propertyName.equals("right")) {
                ok = true;
            } else if (propertyName.equals("top")) {
                ok = true;
            } else if (propertyName.equals("zIndex")) {
                ok = true;
            }
            if (ok) {
                Render.asPositionable(styleEx, (Positionable)((Object)component));
                handled = true;
            }
        }
        if (!handled && component instanceof Scrollable) {
            ok = false;
            if (propertyName.equals("scrollBarBaseColor")) {
                ok = true;
            } else if (propertyName.equals("scrollBarPolicy")) {
                ok = true;
            } else if (propertyName.equals("scrollBarProperties")) {
                ok = true;
            }
            if (ok) {
                Render.asScrollable(styleEx, (Scrollable)((Object)component));
                handled = true;
            }
        }
        StringTokenizer st1 = new StringTokenizer(styleEx.renderInline(), ":;");
        while (st1.hasMoreTokens()) {
            String cssAttributeName = st1.nextToken();
            if (!st1.hasMoreTokens()) continue;
            String cssAttributeValue = st1.nextToken();
            cssAttributeName = CssKit.cssAttributeNameToPropertyName(cssAttributeName);
            DomUpdate.renderStyleUpdate(rc.getServerMessage(), elementId, cssAttributeName, cssAttributeValue);
        }
    }

    static {
        AblePartialUpdater.initHandler("border");
        AblePartialUpdater.initHandler("height");
        AblePartialUpdater.initHandler("insets");
        AblePartialUpdater.initHandler("outsets");
        AblePartialUpdater.initHandler("mouseCursor");
        AblePartialUpdater.initHandler("mouseCursorUri");
        AblePartialUpdater.initHandler("bottom");
        AblePartialUpdater.initHandler("left");
        AblePartialUpdater.initHandler("position");
        AblePartialUpdater.initHandler("right");
        AblePartialUpdater.initHandler("top");
        AblePartialUpdater.initHandler("zIndex");
        AblePartialUpdater.initHandler("width");
        AblePartialUpdater.initHandler("scrollBarBaseColor");
        AblePartialUpdater.initHandler("scrollBarPolicy");
        AblePartialUpdater.initHandler("scrollBarProperties");
    }
}

