/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.syncpeer;

import echopointng.TemplatePanel;
import echopointng.stylesheet.CssStyleSheetException;
import echopointng.stylesheet.CssStyleSheetLoader;
import echopointng.template.TemplateCachingHints;
import echopointng.template.TemplateDataSource;
import echopointng.template.TemplateTextSubstitution;
import echopointng.ui.resource.Resources;
import echopointng.ui.syncpeer.AbstractEchoPointContainerPeer;
import echopointng.ui.template.TemplateCompiler;
import echopointng.ui.template.TemplateCompilerLoader;
import echopointng.ui.util.CssStyleEx;
import echopointng.ui.util.Render;
import echopointng.ui.util.RenderingContext;
import echopointng.ui.util.io.StringInputStream;
import echopointng.util.HtmlKit;
import echopointng.util.collections.ExpiryCache;
import echopointng.util.reflect.ReflectionKit;
import java.util.ArrayList;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.StyleSheet;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.ContainerContext;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.DomUpdateSupport;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.SynchronizePeerFactory;
import nextapp.echo2.webrender.ClientProperties;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.output.CssStyle;
import nextapp.echo2.webrender.servermessage.DomUpdate;
import nextapp.echo2.webrender.service.JavaScriptService;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class TemplatePanelPeer
extends AbstractEchoPointContainerPeer {
    public static final Service TEMPLATE_JS_SERVICE = JavaScriptService.forResource("EPNG.TemplatePanel", "/echopointng/ui/resource/js/templatepanel.js");
    public static final ExpiryCache COMPILED_TEMPLATE_CACHE;

    @Override
    public void renderHtml(RenderingContext rc, Node parent, Component component) {
        TemplatePanel templatePanel = (TemplatePanel)component;
        TemplateResult compiledTemplate = this.renderTemplateData(rc, templatePanel);
        if (compiledTemplate != null) {
            this.createInitDirective(rc, templatePanel, compiledTemplate);
            rc.addLibrary(Resources.EP_SCRIPT_SERVICE);
            rc.addLibrary(TEMPLATE_JS_SERVICE);
            compiledTemplate.markupE.setAttribute("id", ContainerInstance.getElementId(templatePanel));
            compiledTemplate.markupE.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
            rc.addStandardWebSupport(compiledTemplate.markupE);
            if (!compiledTemplate.markupE.hasAttribute("style")) {
                CssStyleEx cssStyle = new CssStyleEx(component);
                compiledTemplate.markupE.setAttribute("style", cssStyle.renderInline());
            }
            parent.appendChild(compiledTemplate.markupE);
        }
    }

    @Override
    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        super.renderDispose(rc, update, component);
        rc.getServerMessage().addLibrary(Resources.EP_SCRIPT_SERVICE.getId());
        rc.getServerMessage().addLibrary(TEMPLATE_JS_SERVICE.getId());
        this.createDisposeDirective(rc.getServerMessage(), (TemplatePanel)component);
    }

    protected void createDisposeDirective(ServerMessage serverMessage, TemplatePanel templatePanel) {
        serverMessage.addLibrary(Resources.EP_SCRIPT_SERVICE.getId());
        serverMessage.addLibrary(TEMPLATE_JS_SERVICE.getId());
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("preremove", "EPTemplatePanel.MessageProcessor", "dispose", new String[0], new String[0]);
        Element itemElement = serverMessage.getDocument().createElement("item");
        itemizedUpdateElement.appendChild(itemElement);
        itemElement.setAttribute("eid", ContainerInstance.getElementId(templatePanel));
    }

    protected void createInitDirective(RenderingContext rc, TemplatePanel templatePanel, TemplateResult templateResult) {
        Element itemizedUpdateElement = rc.getServerMessage().getItemizedDirective("postupdate", "EPTemplatePanel.MessageProcessor", "init", new String[0], new String[0]);
        Element itemElement = rc.getServerMessage().getDocument().createElement("item");
        itemizedUpdateElement.appendChild(itemElement);
        itemElement.setAttribute("eid", ContainerInstance.getElementId(templatePanel));
        ApplicationInstance app = ApplicationInstance.getActive();
        ContainerContext containerContext = (ContainerContext)app.getContextProperty(ContainerContext.CONTEXT_PROPERTY_NAME);
        ClientProperties clientProperties = containerContext.getClientProperties();
        String userAgent = clientProperties.getString("navigatorUserAgent");
        Element externalStyleContainerE = rc.getServerMessage().getDocument().createElement("externalStyleContainer");
        for (int i = 0; i < templateResult.externalStyles.length; ++i) {
            externalStyleContainerE.appendChild(templateResult.externalStyles[i]);
        }
        itemElement.appendChild(externalStyleContainerE);
        Element externalScriptContainerE = rc.getServerMessage().getDocument().createElement("externalScriptContainer");
        for (int i = 0; i < templateResult.externalScripts.length; ++i) {
            externalScriptContainerE.appendChild(templateResult.externalScripts[i]);
        }
        itemElement.appendChild(externalScriptContainerE);
        Element inlineStyleContainerE = rc.getServerMessage().getDocument().createElement("inlineStyleContainer");
        itemElement.appendChild(inlineStyleContainerE);
        if (userAgent.indexOf("Gecko") != -1) {
            Element styleParentE = templateResult.markupE;
            if (this.getElementsByTag(styleParentE, "body").length > 0) {
                styleParentE = this.getElementsByTag(styleParentE, "body")[0];
            }
            for (int i = 0; i < templateResult.inlineStyles.length; ++i) {
                styleParentE.insertBefore(templateResult.inlineStyles[i], styleParentE.getFirstChild());
            }
        } else {
            for (int i = 0; i < templateResult.inlineStyles.length; ++i) {
                inlineStyleContainerE.appendChild(templateResult.inlineStyles[i]);
            }
        }
    }

    private TemplateResult renderTemplateData(RenderingContext rc, TemplatePanel templatePanel) {
        TemplateDataSource tds = (TemplateDataSource)rc.getRP("templateDataSource");
        try {
            CompilationResult compileResult = this.getCompiledTemplate(rc, tds);
            Element markup = compileResult.compiledXHTML;
            if (markup == null) {
                return null;
            }
            boolean doStyleProcessing = compileResult.wasCompiled || !templatePanel.isStyleApplied();
            markup = (Element)rc.getDocument().importNode(markup, true);
            Element[] componentElements = this.getElementsByTags(markup, new String[]{"component", "input", "button", "select"});
            for (int i = 0; i < componentElements.length; ++i) {
                Element newComponentElement;
                Component child;
                Element componentElement = componentElements[i];
                String componentName = componentElement.getAttribute("name");
                String componentId = componentElement.getAttribute("id");
                String componentStyleValue = componentElement.getAttribute("style");
                String componentStyleNameValue = componentElement.getAttribute("styleName");
                if (componentName.length() == 0) {
                    componentName = componentId;
                }
                if ((child = templatePanel.getNamedComponent(componentName)) != null) {
                    if (doStyleProcessing) {
                        if (componentStyleNameValue != null && componentStyleNameValue.length() > 0) {
                            child.setStyleName(componentStyleNameValue);
                        }
                        this.applyStyle(templatePanel, child, componentStyleValue);
                        templatePanel.setStyleApplied(true);
                        if (rc.getRP("invokeSetText", false)) {
                            String textToBeSet = this.getChildText(componentElement);
                            if (textToBeSet.length() == 0) {
                                textToBeSet = componentElement.getAttribute("value");
                            }
                            if (textToBeSet.length() > 0) {
                                ReflectionKit.invokeIfPresent("setText", new Class[]{String.class}, Void.TYPE, child, new Object[]{textToBeSet});
                            }
                        }
                    }
                    newComponentElement = this.renderChild(rc, child, componentName);
                } else {
                    newComponentElement = null;
                    if (componentName.length() > 0) {
                        if (rc.getRP("exceptionOnFailure", false)) {
                            throw new RuntimeException("A component named '" + componentName + "' could not be found in TemplateDataSource " + tds.getCanonicalName() + " could not be compiled.");
                        }
                        newComponentElement = this.createErrorElement(rc, "Component named '" + componentName + "' could not be found!");
                    }
                }
                if (newComponentElement == null) continue;
                Element componentContainerElement = (Element)componentElement.getParentNode();
                componentContainerElement.replaceChild(newComponentElement, componentElement);
            }
            TemplateTextSubstitution textSubstitution = (TemplateTextSubstitution)rc.getRP("templateTextSubstition");
            Element[] textElements = this.getElementsByTag(markup, "text");
            for (int i = 0; i < textElements.length; ++i) {
                Element textMarkerElement = textElements[i];
                String textName = textMarkerElement.getAttribute("name");
                String textValue = textSubstitution == null ? "" : textSubstitution.getSubstitutionText(textName);
                Element textContainerElement = (Element)textMarkerElement.getParentNode();
                Text newText = rc.createText(textValue);
                textContainerElement.replaceChild(newText, textMarkerElement);
            }
            TemplateResult transResult = this.transmogrifyMarkup(markup);
            return transResult;
        }
        catch (Exception e) {
            String errorStr = "TemplateDataSource " + tds.getCanonicalName() + " could not be compiled : " + e.toString();
            if (rc.getRP("exceptionOnFailure", false)) {
                throw new RuntimeException(errorStr, e);
            }
            Element errorE = this.createErrorElement(rc, errorStr);
            return new TemplateResult(errorE);
        }
    }

    private CompilationResult getCompiledTemplate(RenderingContext rc, TemplateDataSource tds) throws Exception {
        Element compiledXHTML;
        if (tds == null) {
            return new CompilationResult(null, false);
        }
        long startMS = System.currentTimeMillis();
        String canonicalName = tds.getCanonicalName();
        TemplateCachingHints hints = tds.getCachingHints();
        if (hints != null && (compiledXHTML = (Element)COMPILED_TEMPLATE_CACHE.get(canonicalName, hints.getLastModified())) != null) {
            CompilationResult compilationResult = new CompilationResult(compiledXHTML, false);
            compilationResult.compilationTime = System.currentTimeMillis() - startMS;
            return compilationResult;
        }
        TemplateCompilerLoader loader = TemplateCompilerLoader.forClassLoader(Thread.currentThread().getContextClassLoader());
        TemplateCompiler compiler = loader.getTemplateCompiler(tds.getContentType());
        if (compiler == null) {
            throw new IllegalStateException("A TemplateCompiler cannot be found for content type : " + tds.getContentType());
        }
        compiledXHTML = compiler.compileTemplateDataIntoXHTML(rc, tds);
        if (hints != null) {
            long ato = hints.getAccessTimeout();
            long ttl = hints.getTimeToLive();
            long version = hints.getLastModified();
            COMPILED_TEMPLATE_CACHE.put(canonicalName, compiledXHTML, ttl, ato, version);
        }
        CompilationResult compilationResult = new CompilationResult(compiledXHTML, true);
        compilationResult.compilationTime = System.currentTimeMillis() - startMS;
        return compilationResult;
    }

    private TemplateResult transmogrifyMarkup(Element markup) {
        int j;
        int i;
        Element[] heads = this.getElementsByTag(markup, "head");
        Element[] bodys = this.getElementsByTag(markup, "body");
        if (markup.getTagName().equals("body") || markup.getTagName().equals("html") || bodys.length > 0) {
            if (bodys.length > 0) {
                markup = bodys[0];
            }
            markup = this.reparentElement(markup, "div");
        }
        ArrayList<Element> cssLinksList = new ArrayList<Element>();
        ArrayList<Element> stylesList = new ArrayList<Element>();
        ArrayList<Element> scriptsList = new ArrayList<Element>();
        Element[] styles = this.getAllStylesFromMarkup(markup, heads);
        for (int j2 = 0; j2 < styles.length; ++j2) {
            stylesList.add(styles[j2]);
            styles[j2].getParentNode().removeChild(styles[j2]);
        }
        for (i = 0; i < heads.length; ++i) {
            Element[] links = this.getElementsByTag(heads[i], "link");
            for (j = 0; j < links.length; ++j) {
                if (!"text/css".equalsIgnoreCase(links[j].getAttribute("type"))) continue;
                cssLinksList.add(links[j]);
                links[j].getParentNode().removeChild(links[j]);
            }
        }
        for (i = 0; i < heads.length; ++i) {
            Element[] scripts = this.getElementsByTag(heads[i], "script");
            for (j = 0; j < scripts.length; ++j) {
                scriptsList.add(scripts[j]);
                scripts[j].getParentNode().removeChild(scripts[j]);
            }
        }
        markup.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
        TemplateResult transResult = new TemplateResult(markup);
        transResult.externalStyles = cssLinksList.toArray(new Element[cssLinksList.size()]);
        transResult.inlineStyles = stylesList.toArray(new Element[stylesList.size()]);
        transResult.externalScripts = scriptsList.toArray(new Element[scriptsList.size()]);
        return transResult;
    }

    private Element[] getAllStylesFromMarkup(Element markupBody, Element[] heads) {
        Element[] styles;
        ArrayList<Element> styleList = new ArrayList<Element>();
        for (int i = 0; i < heads.length; ++i) {
            styles = this.getElementsByTag(heads[0], "style");
            for (int j = 0; j < styles.length; ++j) {
                styleList.add(styles[j]);
            }
        }
        styles = this.getElementsByTag(markupBody, "style");
        for (int j = 0; j < styles.length; ++j) {
            styleList.add(styles[j]);
        }
        return styleList.toArray(new Element[styleList.size()]);
    }

    private Element createErrorElement(RenderingContext rc, String errorMessage) {
        Element div = rc.createE("div");
        div.setAttribute("style", "background:red;color:white;font-size:8pt;border-width:1; border-style:solid; border-color:black; padding:4; margin:4");
        div.appendChild(rc.createE("b")).appendChild(rc.createE("p")).appendChild(rc.createText("Template Error : " + errorMessage));
        return div;
    }

    private Element[] getElementsByTag(Element parent, String tagName) {
        NodeList nodeList = parent.getElementsByTagName(tagName);
        Element[] elements = new Element[nodeList.getLength()];
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = (Element)nodeList.item(i);
        }
        return elements;
    }

    private Element[] getElementsByTags(Element parent, String[] tagNames) {
        ArrayList<Node> elementsList = new ArrayList<Node>();
        for (int i = 0; i < tagNames.length; ++i) {
            NodeList nodeList = parent.getElementsByTagName(tagNames[i]);
            int nllen = nodeList.getLength();
            for (int j = 0; j < nllen; ++j) {
                elementsList.add(nodeList.item(j));
            }
        }
        return elementsList.toArray(new Element[elementsList.size()]);
    }

    private Node[] getChildNodes(Element parentE) {
        NodeList nodeList = parentE.getChildNodes();
        int len = nodeList.getLength();
        Node[] nodes = new Node[len];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = nodeList.item(i);
        }
        return nodes;
    }

    private String getChildText(Element parentE) {
        StringBuffer sb = new StringBuffer();
        Node[] nodes = this.getChildNodes(parentE);
        for (int i = 0; i < nodes.length; ++i) {
            if (!(nodes[i] instanceof Text)) continue;
            sb.append(nodes[i].getNodeValue());
        }
        return sb.toString();
    }

    private Element reparentElement(Element sourceElement, String tag) {
        Document doc = sourceElement.getOwnerDocument();
        Element newParent = doc.createElement(tag);
        NamedNodeMap attrs = sourceElement.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            Attr newAttr = doc.createAttribute(attr.getName());
            newAttr.setValue(attr.getValue());
            newParent.setAttributeNode(newAttr);
        }
        Node[] children = this.getChildNodes(sourceElement);
        for (int i = 0; i < children.length; ++i) {
            newParent.appendChild(children[i]);
        }
        return newParent;
    }

    private void applyStyle(TemplatePanel templatePanel, Component child, String styleValue) throws CssStyleSheetException {
        if (styleValue.length() > 0) {
            StringBuffer cssText = new StringBuffer();
            cssText.append(child.getClass().getName());
            cssText.append("{");
            cssText.append(styleValue);
            cssText.append("}");
            StringInputStream sis = new StringInputStream(cssText.toString());
            StyleSheet styleSheet = CssStyleSheetLoader.load(sis, Thread.currentThread().getContextClassLoader());
            Style style = styleSheet.getStyle(child.getClass(), null);
            child.setStyle(style);
        }
    }

    private Element renderChild(RenderingContext rc, Component child, String componentName) {
        Element childContainerE = rc.createE("bdo");
        childContainerE.setAttribute("id", this.getMarkerContainerId(child.getParent(), componentName));
        this.renderReplaceableChild(rc, rc.getServerComponentUpdate(), childContainerE, child);
        return childContainerE;
    }

    private String getMarkerContainerId(Component parent, String componentName) {
        String parentId = ContainerInstance.getElementId(parent);
        return parentId + "_marks_" + HtmlKit.encode(componentName);
    }

    @Override
    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        boolean fullReplace = false;
        if (update.hasUpdatedLayoutDataChildren()) {
            fullReplace = true;
        } else if (update.hasUpdatedProperties()) {
            if (this.partialUpdateManager.canProcess(rc, update)) {
                this.partialUpdateManager.process(rc, update);
            } else {
                fullReplace = true;
            }
        }
        if (update.hasAddedChildren() || update.hasRemovedChildren()) {
            this.renderUpdateRemoveChildren(rc, update);
            Element domAddElementDirective = DomUpdate.renderElementAdd(rc.getServerMessage());
            TemplatePanel panel = (TemplatePanel)update.getParent();
            Component[] addedChildren = update.getAddedChildren();
            for (int i = 0; i < addedChildren.length; ++i) {
                Component newChild = addedChildren[i];
                String[] componentNames = panel.getNamedComponents();
                for (int j = 0; j < componentNames.length; ++j) {
                    Component testComponent = panel.getNamedComponent(componentNames[j]);
                    if (!newChild.equals(testComponent) || !newChild.isRenderVisible()) continue;
                    String outerElementId = this.getMarkerContainerId(panel, componentNames[j]);
                    DocumentFragment htmlFragment = rc.getServerMessage().getDocument().createDocumentFragment();
                    this.renderReplaceableChild(rc, update, htmlFragment, newChild);
                    DomUpdate.renderElementAddContent(rc.getServerMessage(), domAddElementDirective, outerElementId, htmlFragment);
                }
            }
            fullReplace = false;
        }
        if (fullReplace) {
            String removeTagetId = ContainerInstance.getElementId(update.getParent());
            DomUpdate.renderElementRemove(rc.getServerMessage(), removeTagetId);
            this.renderAdd(rc, update, targetId, update.getParent());
        }
        return fullReplace;
    }

    @Override
    protected Element renderReplaceableChild(RenderContext rc, ServerComponentUpdate update, Node parentNode, Component child) {
        Document doc = parentNode.getOwnerDocument();
        Element childContainerE = doc.createElement("bdo");
        CssStyle containerStyle = Render.itsDisplayLayoutData(rc, child);
        if (containerStyle.hasAttributes()) {
            childContainerE = doc.createElement("div");
            childContainerE.setAttribute("style", containerStyle.renderInline());
            Render.itsDisplayLayoutData(rc, child, childContainerE);
        }
        String containerId = this.getContainerId(child);
        childContainerE.setAttribute("id", containerId);
        parentNode.appendChild(childContainerE);
        ComponentSynchronizePeer syncPeer = SynchronizePeerFactory.getPeerForComponent(child.getClass());
        if (syncPeer instanceof DomUpdateSupport) {
            ((DomUpdateSupport)((Object)syncPeer)).renderHtml(rc, update, childContainerE, child);
        } else {
            syncPeer.renderAdd(rc, update, containerId, child);
        }
        return childContainerE;
    }

    static {
        WebRenderServlet.getServiceRegistry().add(TEMPLATE_JS_SERVICE);
        COMPILED_TEMPLATE_CACHE = new ExpiryCache(3600000L, 300000L, false);
    }

    private static class TemplateResult {
        Element markupE;
        Element[] externalStyles;
        Element[] inlineStyles;
        Element[] externalScripts;

        public TemplateResult(Element markupE) {
            this.markupE = markupE;
            this.externalStyles = new Element[0];
            this.inlineStyles = new Element[0];
            this.externalScripts = new Element[0];
        }
    }

    private static class CompilationResult {
        private Element compiledXHTML;
        private boolean wasCompiled;
        private long compilationTime;

        CompilationResult(Element compiledXHTML, boolean wasCompiled) {
            this.compiledXHTML = compiledXHTML;
            this.wasCompiled = wasCompiled;
            this.compilationTime = 0L;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Compilation time ms : ");
            sb.append(this.compilationTime);
            return sb.toString();
        }
    }
}

