/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.syncpeer;

import echopointng.EPNG;
import echopointng.TableEx;
import echopointng.layout.TableLayoutDataEx;
import echopointng.ui.resource.Resources;
import echopointng.ui.util.CssStyleEx;
import echopointng.ui.util.Render;
import echopointng.ui.util.RenderingContext;
import echopointng.xhtml.XhtmlFragment;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.FillImage;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.Table;
import nextapp.echo2.app.layout.CellLayoutData;
import nextapp.echo2.app.layout.TableLayoutData;
import nextapp.echo2.app.list.ListSelectionModel;
import nextapp.echo2.app.table.TableColumnModel;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ActionProcessor;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.DomUpdateSupport;
import nextapp.echo2.webcontainer.PartialUpdateManager;
import nextapp.echo2.webcontainer.PropertyUpdateProcessor;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.SynchronizePeerFactory;
import nextapp.echo2.webcontainer.image.ImageRenderSupport;
import nextapp.echo2.webcontainer.propertyrender.BorderRender;
import nextapp.echo2.webcontainer.propertyrender.CellLayoutDataRender;
import nextapp.echo2.webcontainer.propertyrender.ColorRender;
import nextapp.echo2.webcontainer.propertyrender.ExtentRender;
import nextapp.echo2.webcontainer.propertyrender.FillImageRender;
import nextapp.echo2.webcontainer.propertyrender.FontRender;
import nextapp.echo2.webcontainer.propertyrender.InsetsRender;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.output.CssStyle;
import nextapp.echo2.webrender.servermessage.DomUpdate;
import nextapp.echo2.webrender.service.JavaScriptService;
import nextapp.echo2.webrender.util.DomUtil;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TableExPeer
implements ActionProcessor,
ComponentSynchronizePeer,
DomUpdateSupport,
PropertyUpdateProcessor,
ImageRenderSupport {
    private static final String[] TABLE_INIT_KEYS = new String[]{"rollover-style", "selection-style"};
    private static final String PROPERTY_SELECTION = "selection";
    private static final String IMAGE_ID_ROLLOVER_BACKGROUND = "rolloverBackground";
    private static final String IMAGE_ID_SELECTION_BACKGROUND = "selectionBackground";
    private static final Service TABLEEX_SERVICE = JavaScriptService.forResource("EPNG.TableEx", "/echopointng/ui/resource/js/tableex.js");
    protected PartialUpdateManager propertyRenderRegistry;

    @Override
    public String getContainerId(Component child) {
        return ContainerInstance.getElementId(child.getParent()) + "_cell_" + child.getRenderId();
    }

    @Override
    public ImageReference getImage(Component component, String imageId) {
        if (IMAGE_ID_ROLLOVER_BACKGROUND.equals(imageId)) {
            FillImage backgroundImage = (FillImage)component.getRenderProperty("rolloverBackgroundImage");
            if (backgroundImage == null) {
                return null;
            }
            return backgroundImage.getImage();
        }
        if (IMAGE_ID_SELECTION_BACKGROUND.equals(imageId)) {
            FillImage backgroundImage = (FillImage)component.getRenderProperty("selectionBackgroundImage");
            if (backgroundImage == null) {
                return null;
            }
            return backgroundImage.getImage();
        }
        return CellLayoutDataRender.getCellLayoutDataBackgroundImage(component, imageId);
    }

    private TableLayoutData getLayoutData(Component child) {
        LayoutData layoutData = (LayoutData)child.getRenderProperty("layoutData");
        if (layoutData == null) {
            return null;
        }
        if (layoutData instanceof TableLayoutData) {
            return (TableLayoutData)layoutData;
        }
        throw new RuntimeException("Invalid LayoutData for Table Child: " + layoutData.getClass().getName());
    }

    private TableLayoutData getLayoutData(XhtmlFragment fragment) {
        LayoutData layoutData = fragment.getLayoutData();
        if (layoutData == null) {
            return null;
        }
        if (layoutData instanceof TableLayoutData) {
            return (TableLayoutData)layoutData;
        }
        throw new RuntimeException("Invalid LayoutData for Table: " + layoutData.getClass().getName());
    }

    @Override
    public void processAction(ContainerInstance ci, Component component, Element actionElement) {
        String value = actionElement.getAttribute("value");
        ci.getUpdateManager().getClientUpdateManager().setComponentAction(component, "action", value);
    }

    @Override
    public void processPropertyUpdate(ContainerInstance ci, Component component, Element propertyElement) {
        int i;
        String propertyName = propertyElement.getAttribute("name");
        if (PROPERTY_SELECTION.equals(propertyName)) {
            Element[] optionElements = DomUtil.getChildElementsByTagName(propertyElement, "row");
            int[] selectedIndices = new int[optionElements.length];
            for (i = 0; i < optionElements.length; ++i) {
                selectedIndices[i] = Integer.parseInt(optionElements[i].getAttribute("index"));
            }
            ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, PROPERTY_SELECTION, selectedIndices);
        }
        if ("columnWidths".equals(propertyName)) {
            Element[] widthElements = DomUtil.getChildElementsByTagName(propertyElement, "columnWidth");
            int[] widths = new int[widthElements.length];
            for (i = 0; i < widthElements.length; ++i) {
                widths[i] = Integer.parseInt(widthElements[i].getAttribute("width"));
            }
            ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, "columnWidthsChanged", widths);
        }
    }

    @Override
    public void renderAdd(RenderContext rc, ServerComponentUpdate update, String targetId, Component component) {
        Element domAddElement = DomUpdate.renderElementAdd(rc.getServerMessage());
        DocumentFragment htmlFragment = rc.getServerMessage().getDocument().createDocumentFragment();
        this.renderHtml(rc, update, htmlFragment, component);
        DomUpdate.renderElementAddContent(rc.getServerMessage(), domAddElement, targetId, htmlFragment);
    }

    private void renderAddChild(RenderingContext rc, Element parentElement, Component child) {
        if (!child.isVisible()) {
            return;
        }
        ServerComponentUpdate update = rc.getServerComponentUpdate();
        ComponentSynchronizePeer syncPeer = SynchronizePeerFactory.getPeerForComponent(child.getClass());
        if (syncPeer instanceof DomUpdateSupport) {
            ((DomUpdateSupport)((Object)syncPeer)).renderHtml(rc, update, parentElement, child);
        } else {
            syncPeer.renderAdd(rc, update, this.getContainerId(child), child);
        }
    }

    @Override
    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        rc.getServerMessage().addLibrary(Resources.EP_SCRIPT_SERVICE.getId());
        rc.getServerMessage().addLibrary(Resources.EP_DRAG_SERVICE.getId());
        rc.getServerMessage().addLibrary(TABLEEX_SERVICE.getId());
        this.renderDisposeDirective(rc, (Table)component);
    }

    private void renderDisposeDirective(RenderContext rc, Table table) {
        ServerMessage serverMessage = rc.getServerMessage();
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("preremove", "EPTableEx.MessageProcessor", "dispose", new String[0], new String[0]);
        Element itemElement = serverMessage.getDocument().createElement("item");
        itemElement.setAttribute("eid", ContainerInstance.getElementId(table));
        itemizedUpdateElement.appendChild(itemElement);
    }

    @Override
    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        Table table = (Table)update.getParent();
        this.renderDisposeDirective(rc, table);
        DomUpdate.renderElementRemove(rc.getServerMessage(), ContainerInstance.getElementId(table));
        this.renderAdd(rc, update, targetId, table);
        return true;
    }

    @Override
    public void renderHtml(RenderContext rcOrig, ServerComponentUpdate update, Node parentNode, Component component) {
        String defaultInsetsAttributeValue;
        RenderingContext rc = new RenderingContext(rcOrig, update, component);
        Style fallbackStyle = EPNG.getFallBackStyle(component);
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(Resources.EP_SCRIPT_SERVICE.getId());
        serverMessage.addLibrary(Resources.EP_DRAG_SERVICE.getId());
        serverMessage.addLibrary(TABLEEX_SERVICE.getId());
        TableEx table = (TableEx)component;
        String elementId = ContainerInstance.getElementId(table);
        Element itemXML = this.renderInitDirective(rc, table, fallbackStyle);
        Document document = parentNode.getOwnerDocument();
        Border border = (Border)rc.getRP("border", fallbackStyle);
        Extent borderSize = border == null ? null : border.getSize();
        Extent width = (Extent)rc.getRP("width", fallbackStyle);
        Extent height = (Extent)rc.getRP("height", fallbackStyle);
        boolean selectionEnabled = rc.getRP("selectionEnabled", fallbackStyle, false);
        boolean headerVisible = table.isHeaderVisible();
        boolean footerVisible = table.isFooterVisible();
        int rowCount = table.getModel().getRowCount();
        Insets tableInsets = (Insets)rc.getRP("insets", fallbackStyle);
        String string = defaultInsetsAttributeValue = tableInsets == null ? "0px" : InsetsRender.renderCssAttributeValue(tableInsets);
        if (rc.getRP("scrollable", fallbackStyle, false)) {
            Element outerDivE = document.createElement("div");
            outerDivE.setAttribute("id", elementId);
            outerDivE.setAttribute("style", "padding:0px;margin:0px");
            rc.addStandardWebSupport(component, outerDivE);
            if (headerVisible) {
                Element headerDivE = this.renderResizeableHeaderFooterAreas(rc, table, fallbackStyle, border, defaultInsetsAttributeValue, itemXML, -1, headerVisible, "header", rowCount);
                outerDivE.appendChild(headerDivE);
            }
            Element contentDivE = document.createElement("div");
            CssStyleEx style = new CssStyleEx(component, fallbackStyle);
            style.setAttribute("overflow", "auto");
            style.setAttribute("padding", "0px");
            style.setAttribute("margin", "0px");
            ExtentRender.renderToStyle(style, "width", width);
            if (rowCount > 0) {
                ExtentRender.renderToStyle(style, "height", height);
                Render.asBorder(style, border);
                if (headerVisible) {
                    style.setAttribute("border-top-width", "0px");
                }
            }
            contentDivE.setAttribute("style", style.renderInline());
            contentDivE.setAttribute("id", elementId + "_contentDiv");
            Element contentTableE = document.createElement("table");
            style = new CssStyleEx();
            style.setAttribute("table-layout", "fixed");
            style.setAttribute("width", "100%");
            if (selectionEnabled && rowCount > 0) {
                style.setAttribute("cursor", "pointer");
            }
            contentTableE.setAttribute("style", style.renderInline());
            contentTableE.setAttribute("id", elementId + "_contentTable");
            contentTableE.setAttribute("cellpadding", "0");
            contentTableE.setAttribute("cellspacing", "0");
            contentTableE.setAttribute("border", "0");
            Element colgroupE = this.renderColGroup(table, document);
            if (colgroupE != null) {
                contentTableE.appendChild(colgroupE);
            }
            Element contentTbodyElement = document.createElement("tbody");
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                this.renderRow(rc, contentTbodyElement, table, rowIndex, defaultInsetsAttributeValue, itemXML, fallbackStyle);
            }
            contentTableE.appendChild(contentTbodyElement);
            contentDivE.appendChild(contentTableE);
            outerDivE.appendChild(contentDivE);
            if (footerVisible) {
                Element footerDivE = this.renderResizeableHeaderFooterAreas(rc, table, fallbackStyle, border, defaultInsetsAttributeValue, itemXML, -2, footerVisible, "footer", rowCount);
                outerDivE.appendChild(footerDivE);
            }
            parentNode.appendChild(outerDivE);
        } else {
            Element tableElement = document.createElement("table");
            tableElement.setAttribute("id", elementId);
            rc.addStandardWebSupport(component, tableElement);
            CssStyleEx tableCssStyle = new CssStyleEx(component, fallbackStyle);
            tableCssStyle.setAttribute("border-collapse", "collapse");
            if (selectionEnabled) {
                tableCssStyle.setAttribute("cursor", "pointer");
            }
            ColorRender.renderToStyle(tableCssStyle, component);
            FontRender.renderToStyle((CssStyle)tableCssStyle, component);
            BorderRender.renderToStyle(tableCssStyle, border);
            if (borderSize != null && !rc.getContainerInstance().getClientProperties().getBoolean("quirkCssBorderCollapseInside")) {
                tableCssStyle.setAttribute("margin", ExtentRender.renderCssAttributeValueHalf(borderSize));
            }
            if (rc.getContainerInstance().getClientProperties().getBoolean("quirkIETablePercentWidthScrollbarError") && width != null && width.getUnits() == 2 && width.getValue() > 95) {
                width = new Extent(95, 2);
            }
            ExtentRender.renderToStyle(tableCssStyle, "width", width);
            tableElement.setAttribute("style", tableCssStyle.renderInline());
            parentNode.appendChild(tableElement);
            Element colgroupE = this.renderColGroup(table, document);
            if (colgroupE != null) {
                tableElement.appendChild(colgroupE);
            }
            Element tbodyElement = document.createElement("tbody");
            tbodyElement.setAttribute("id", elementId + "_tbody");
            tableElement.appendChild(tbodyElement);
            if (table.isHeaderVisible()) {
                this.renderRow(rc, tbodyElement, table, -1, defaultInsetsAttributeValue, itemXML, fallbackStyle);
            }
            int rows = table.getModel().getRowCount();
            for (int rowIndex = 0; rowIndex < rows; ++rowIndex) {
                this.renderRow(rc, tbodyElement, table, rowIndex, defaultInsetsAttributeValue, itemXML, fallbackStyle);
            }
            if (table.isFooterVisible()) {
                this.renderRow(rc, tbodyElement, table, -2, defaultInsetsAttributeValue, itemXML, fallbackStyle);
            }
        }
    }

    private Element renderResizeableHeaderFooterAreas(RenderingContext rc, TableEx table, Style fallbackStyle, Border border, String defaultInsetsAttributeValue, Element itemXML, int rowIndex, boolean isVisible, String prefixName, int rowCount) {
        Document document = rc.getDocument();
        Element headerFooterDivE = document.createElement("div");
        CssStyleEx style = new CssStyleEx(table, fallbackStyle);
        style.setAttribute("width", "100%");
        style.setAttribute("overflow", "hidden");
        style.setAttribute("position", "relative");
        style.setAttribute("padding", "0px");
        style.setAttribute("margin", "0px");
        if (isVisible) {
            if (rowIndex == -1) {
                Render.asColor(style, (Color)rc.getRP("headerBackground", fallbackStyle), "background");
            }
            if (rowIndex == -2) {
                Render.asColor(style, (Color)rc.getRP("footerBackground", fallbackStyle), "background");
            }
            if (isVisible && rowIndex == -1) {
                Render.asBorder(style, border);
                if (rowCount > 0) {
                    style.setAttribute("border-bottom-width", style.getAttribute("border-top-width"));
                    style.setAttribute("border-bottom-color", style.getAttribute("border-top-color"));
                    style.setAttribute("border-bottom-style", style.getAttribute("border-top-style"));
                }
            }
            if (isVisible && rowIndex == -2) {
                Render.asBorder(style, border);
                if (rowCount > 0) {
                    style.setAttribute("border-top-width", "0px");
                }
            }
        }
        headerFooterDivE.setAttribute("style", style.renderInline());
        headerFooterDivE.setAttribute("id", rc.getElementId() + "_" + prefixName + "Div");
        Element headerFooterScrollerDivE = document.createElement("div");
        style = new CssStyleEx();
        style.setAttribute("width", "100%");
        style.setAttribute("position", "relative");
        style.setAttribute("padding", "0px");
        style.setAttribute("margin", "0px");
        headerFooterScrollerDivE.setAttribute("style", style.renderInline());
        headerFooterScrollerDivE.setAttribute("id", rc.getElementId() + "_" + prefixName + "ScrollerDiv");
        Element headerFooterTableE = document.createElement("table");
        style = new CssStyleEx();
        style.setAttribute("table-layout", "fixed");
        style.setAttribute("width", "100%");
        headerFooterTableE.setAttribute("style", style.renderInline());
        headerFooterTableE.setAttribute("id", rc.getElementId() + "_" + prefixName + "Table");
        headerFooterTableE.setAttribute("cellpadding", "0");
        headerFooterTableE.setAttribute("cellspacing", "0");
        headerFooterTableE.setAttribute("border", "0");
        Element headerFooterTbodyElement = document.createElement("tbody");
        headerFooterTableE.appendChild(headerFooterTbodyElement);
        if (isVisible) {
            this.renderRow(rc, headerFooterTbodyElement, table, rowIndex, defaultInsetsAttributeValue, itemXML, fallbackStyle);
        }
        headerFooterTableE.appendChild(headerFooterTbodyElement);
        headerFooterScrollerDivE.appendChild(headerFooterTableE);
        headerFooterDivE.appendChild(headerFooterScrollerDivE);
        return headerFooterDivE;
    }

    protected Element renderColGroup(TableEx table, Document document) {
        TableColumnModel columnModel = table.getColumnModel();
        int columnCount = columnModel.getColumnCount();
        boolean someColumnsHaveWidths = false;
        for (int i = 0; i < columnCount; ++i) {
            if (columnModel.getColumn(i).getWidth() == null) continue;
            someColumnsHaveWidths = true;
        }
        Element colGroupElement = null;
        if (someColumnsHaveWidths) {
            colGroupElement = document.createElement("colgroup");
            for (int i = 0; i < columnCount; ++i) {
                Element colElement = document.createElement("col");
                Extent columnWidth = columnModel.getColumn(i).getWidth();
                if (columnWidth != null) {
                    colElement.setAttribute("width", ExtentRender.renderCssAttributeValue(columnWidth));
                }
                colGroupElement.appendChild(colElement);
            }
        }
        return colGroupElement;
    }

    protected void renderRow(RenderingContext rc, Element tbodyElement, TableEx table, int rowIndex, String defaultInsetsAttributeValue, Element itemXML, Style fallbackStyle) {
        Document document = tbodyElement.getOwnerDocument();
        String elementId = ContainerInstance.getElementId(table);
        boolean isScrollable = rc.getRP("scrollable", fallbackStyle, false);
        Element trElement = document.createElement("tr");
        if (rowIndex == -1) {
            trElement.setAttribute("id", elementId + "_tr_header");
        } else if (rowIndex == -2) {
            trElement.setAttribute("id", elementId + "_tr_footer");
        } else {
            trElement.setAttribute("id", elementId + "_tr_" + rowIndex);
        }
        tbodyElement.appendChild(trElement);
        int columns = table.getColumnModel().getColumnCount();
        int rowCount = table.getModel().getRowCount();
        for (int columnIndex = 0; columnIndex < columns; ++columnIndex) {
            Object cellContent = table.getCellContent(columnIndex, rowIndex);
            if (cellContent == null || cellContent == TableEx.CELL_SPANNER) continue;
            Element tdCellE = document.createElement("td");
            tdCellE.setAttribute("c", String.valueOf(columnIndex));
            trElement.appendChild(tdCellE);
            Element cellContentE = tdCellE;
            CssStyle style = new CssStyle();
            if (!isScrollable) {
                BorderRender.renderToStyle(style, (Border)rc.getRP("border", fallbackStyle));
            } else {
                Element cellDivE = document.createElement("div");
                tdCellE.appendChild(cellDivE);
                cellContentE = cellDivE;
            }
            String cellId = null;
            Component renderComponent = table;
            Component childComponent = null;
            CellLayoutData tableLayoutData = null;
            TableLayoutDataEx tableLayoutDataEx = null;
            if (cellContent instanceof XhtmlFragment) {
                XhtmlFragment fragment = (XhtmlFragment)cellContent;
                cellId = elementId + "_cell_col" + columnIndex + "row" + rowIndex;
                tableLayoutData = this.getLayoutData(fragment);
                if (tableLayoutData instanceof TableLayoutDataEx) {
                    tableLayoutDataEx = (TableLayoutDataEx)tableLayoutData;
                }
                this.renderXhtmlFragment(rc, cellContentE, itemXML, cellId, fragment, rowCount);
            }
            if (cellContent instanceof Component) {
                childComponent = (Component)cellContent;
                renderComponent = childComponent;
                cellId = elementId + "_cell_" + childComponent.getRenderId();
                tableLayoutData = this.getLayoutData(childComponent);
                if (tableLayoutData instanceof TableLayoutDataEx) {
                    tableLayoutDataEx = (TableLayoutDataEx)tableLayoutData;
                }
            }
            if (childComponent != null) {
                this.renderAddChild(rc, cellContentE, childComponent);
            }
            if (rowIndex == -1) {
                Render.asColor(style, (Color)rc.getRP("headerBackground", fallbackStyle), "background");
            }
            if (rowIndex == -2) {
                Render.asColor(style, (Color)rc.getRP("footerBackground", fallbackStyle), "background");
            }
            CellLayoutDataRender.renderToElementAndStyle(cellContentE, style, renderComponent, tableLayoutData, defaultInsetsAttributeValue);
            if (tableLayoutData != null && tableLayoutData.getBackgroundImage() != null) {
                Render.asBackgroundImage(rc, style, tableLayoutData.getBackgroundImage());
            }
            if (isScrollable) {
                style.setAttribute("overflow", "hidden");
                style.setAttribute("white-space", "nowrap");
            }
            cellContentE.setAttribute("style", style.renderInline());
            cellContentE.setAttribute("id", cellId);
            if (tableLayoutDataEx == null) continue;
            if (tableLayoutDataEx.getToolTipText() != null) {
                cellContentE.setAttribute("title", tableLayoutDataEx.getToolTipText());
            }
            int colSpan = tableLayoutDataEx.getColSpan();
            int rowSpan = tableLayoutDataEx.getRowSpan();
            if (colSpan > 1) {
                tdCellE.setAttribute("colspan", String.valueOf(colSpan));
            }
            if (rowSpan <= 1) continue;
            tdCellE.setAttribute("rowspan", String.valueOf(rowSpan));
        }
        boolean statusQuo = true;
        for (int columnIndex = 0; columnIndex < columns; ++columnIndex) {
            if (table.isActionCausingCell(columnIndex, rowIndex) && table.isSelectionCausingCell(columnIndex, rowIndex)) continue;
            statusQuo = false;
            break;
        }
        if (!statusQuo) {
            StringBuffer actionCausingStr = new StringBuffer();
            StringBuffer selectionCausingStr = new StringBuffer();
            for (int columnIndex = 0; columnIndex < columns; ++columnIndex) {
                if (!table.isActionCausingCell(columnIndex, rowIndex)) {
                    actionCausingStr.append("c:");
                    actionCausingStr.append(columnIndex);
                    actionCausingStr.append(";");
                }
                if (table.isSelectionCausingCell(columnIndex, rowIndex)) continue;
                selectionCausingStr.append("c:");
                selectionCausingStr.append(columnIndex);
                selectionCausingStr.append(";");
            }
            Document documentXML = itemXML.getOwnerDocument();
            if (actionCausingStr.length() > 0) {
                Element actionElement = documentXML.createElement("actionCausingCell");
                itemXML.appendChild(actionElement);
                actionElement.setAttribute("row", String.valueOf(rowIndex));
                actionElement.setAttribute("cells", actionCausingStr.toString());
            }
            if (selectionCausingStr.length() > 0) {
                Element selectionElement = documentXML.createElement("selectionCausingCell");
                itemXML.appendChild(selectionElement);
                selectionElement.setAttribute("row", String.valueOf(rowIndex));
                selectionElement.setAttribute("cells", selectionCausingStr.toString());
            }
        }
    }

    protected Element renderInitDirective(RenderingContext rc, TableEx table, Style fallbackStyle) {
        String elementId = ContainerInstance.getElementId(table);
        ServerMessage serverMessage = rc.getServerMessage();
        Document document = serverMessage.getDocument();
        boolean rolloverEnabled = rc.getRP("rolloverEnabled", fallbackStyle, false);
        boolean selectionEnabled = rc.getRP("selectionEnabled", fallbackStyle, false);
        boolean scrollable = rc.getRP("scrollable", fallbackStyle, false);
        boolean resizeable = rc.getRP("resizeable", fallbackStyle, false);
        boolean resizeDragBarUsed = rc.getRP("resizeDragBarUsed", fallbackStyle, false);
        boolean resizeGrowsTable = rc.getRP("resizeGrowsTable", fallbackStyle, true);
        boolean isFooterVisible = rc.getRP("footerVisible", fallbackStyle, false);
        boolean ignoreMetaKeys = rc.getRP("ignoreMetaKeys", fallbackStyle, false);
        String rolloverStyle = "";
        if (rolloverEnabled) {
            CssStyle rolloverCssStyle = new CssStyle();
            ColorRender.renderToStyle(rolloverCssStyle, (Color)rc.getRP("rolloverForeground", fallbackStyle), (Color)rc.getRP(IMAGE_ID_ROLLOVER_BACKGROUND, fallbackStyle));
            FontRender.renderToStyle(rolloverCssStyle, (Font)rc.getRP("rolloverFont", fallbackStyle));
            FillImageRender.renderToStyle(rolloverCssStyle, rc, this, table, IMAGE_ID_ROLLOVER_BACKGROUND, (FillImage)rc.getRP("rolloverBackgroundImage", fallbackStyle), 1);
            if (rolloverCssStyle.hasAttributes()) {
                rolloverStyle = rolloverCssStyle.renderInline();
            }
        }
        String selectionStyle = "";
        if (selectionEnabled) {
            CssStyle selectionCssStyle = new CssStyle();
            ColorRender.renderToStyle(selectionCssStyle, (Color)rc.getRP("selectionForeground", fallbackStyle), (Color)rc.getRP(IMAGE_ID_SELECTION_BACKGROUND, fallbackStyle));
            FontRender.renderToStyle(selectionCssStyle, (Font)rc.getRP("selectionFont", fallbackStyle));
            FillImageRender.renderToStyle(selectionCssStyle, rc, this, table, IMAGE_ID_SELECTION_BACKGROUND, (FillImage)rc.getRP("selectionBackgroundImage", fallbackStyle), 1);
            if (selectionCssStyle.hasAttributes()) {
                selectionStyle = selectionCssStyle.renderInline();
            }
        }
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("postupdate", "EPTableEx.MessageProcessor", "init", TABLE_INIT_KEYS, new String[]{rolloverStyle, selectionStyle});
        Element itemElement = document.createElement("item");
        itemElement.setAttribute("eid", elementId);
        if (table.isHeaderVisible()) {
            itemElement.setAttribute("header-visible", "true");
        }
        if (table.hasActionListeners()) {
            itemElement.setAttribute("server-notify", "true");
        }
        if (rolloverEnabled) {
            itemElement.setAttribute("rollover-enabled", "true");
        }
        if (selectionEnabled) {
            itemElement.setAttribute("selection-enabled", "true");
            ListSelectionModel selectionModel = table.getSelectionModel();
            if (selectionModel.getSelectionMode() == 2) {
                itemElement.setAttribute("selection-mode", "multiple");
            }
            if (selectionModel.getMinSelectedIndex() != -1) {
                Element selectionElement = document.createElement(PROPERTY_SELECTION);
                int minimumIndex = selectionModel.getMinSelectedIndex();
                int maximumIndex = selectionModel.getMaxSelectedIndex();
                if (maximumIndex > table.getModel().getRowCount() - 1) {
                    maximumIndex = table.getModel().getRowCount() - 1;
                }
                for (int i = minimumIndex; i <= maximumIndex; ++i) {
                    if (!selectionModel.isSelectedIndex(i)) continue;
                    Element rowElement = document.createElement("row");
                    rowElement.setAttribute("index", Integer.toString(i));
                    selectionElement.appendChild(rowElement);
                }
                itemElement.appendChild(selectionElement);
            }
        }
        if (!table.isRenderEnabled()) {
            itemElement.setAttribute("enabled", "false");
        }
        itemElement.setAttribute("rowCount", String.valueOf(table.getModel().getRowCount()));
        itemElement.setAttribute("scrollable", String.valueOf(scrollable));
        itemElement.setAttribute("resizeable", String.valueOf(resizeable));
        itemElement.setAttribute("resizeDragBarUsed", String.valueOf(resizeDragBarUsed));
        itemElement.setAttribute("resizeGrowsTable", String.valueOf(resizeGrowsTable));
        itemElement.setAttribute("ignoreMetaKeys", String.valueOf(ignoreMetaKeys));
        itemElement.setAttribute("footer-visible", String.valueOf(isFooterVisible));
        itemElement.setAttribute("heightStretched", String.valueOf(rc.getRP("heightStretched", false)));
        itemElement.setAttribute("minimumStretchedHeight", this.getExtentPixels(rc.getRP("minimumStretchedHeight", null)));
        itemElement.setAttribute("maximumStretchedHeight", this.getExtentPixels(rc.getRP("maximumStretchedHeight", null)));
        itemizedUpdateElement.appendChild(itemElement);
        return itemElement;
    }

    private String getExtentPixels(Object extent) {
        if (extent instanceof Extent) {
            return String.valueOf(((Extent)extent).getValue());
        }
        return null;
    }

    protected void renderXhtmlFragment(RenderingContext rc, Element cellContentE, Element itemXML, String cellId, XhtmlFragment fragment, int rowCount) {
        String xhtml = fragment.getFragment();
        String string = xhtml = xhtml == null ? "" : xhtml;
        if (fragment.isJustText()) {
            cellContentE.appendChild(cellContentE.getOwnerDocument().createTextNode(xhtml));
        } else if (rowCount > 0) {
            Node[] fragments = null;
            try {
                fragments = fragment.toDOM(cellContentE.getOwnerDocument());
            }
            catch (Exception e) {
                throw new RuntimeException("The XhtmlFragment is not valid XHTML : " + fragment.getFragment(), e);
            }
            for (int i = 0; i < fragments.length; ++i) {
                cellContentE.appendChild(fragments[i]);
            }
        } else {
            Document document = itemXML.getOwnerDocument();
            CDATASection cdata = document.createCDATASection(xhtml);
            Element xhtmlFragment = document.createElement("xhtmlfragment");
            xhtmlFragment.appendChild(cdata);
            xhtmlFragment.setAttribute("cellid", cellId);
            itemXML.appendChild(xhtmlFragment);
        }
    }

    static {
        WebRenderServlet.getServiceRegistry().add(TABLEEX_SERVICE);
    }
}

