/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.syncpeer;

import echopointng.EPNG;
import echopointng.TabbedPane;
import echopointng.tabbedpane.TabImageRenderer;
import echopointng.tabbedpane.TabModel;
import echopointng.ui.resource.Resources;
import echopointng.ui.syncpeer.AbstractEchoPointContainerPeer;
import echopointng.ui.util.CssStyleEx;
import echopointng.ui.util.ImageManager;
import echopointng.ui.util.LayoutStrut;
import echopointng.ui.util.Render;
import echopointng.ui.util.RenderingContext;
import echopointng.util.ColorKit;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.Pane;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ActionProcessor;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.DomUpdateSupport;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.SynchronizePeerFactory;
import nextapp.echo2.webcontainer.propertyrender.ExtentRender;
import nextapp.echo2.webcontainer.propertyrender.InsetsRender;
import nextapp.echo2.webrender.ServerMessage;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TabbedPanePeer
extends AbstractEchoPointContainerPeer
implements ActionProcessor {
    private static final String IMAGE_PREFIX = "tabIcon";
    private static final String LEADIN_IMAGE_PREFIX = "leadIn";
    private static final String LEADOUT_IMAGE_PREFIX = "leadOut";

    private String createTabActiveLineStyle(RenderingContext rc, TabbedPane tp, Color borderColor, int borderWidth, int borderStyle, int tabBorderStyle, Color tabBackgroundColor) {
        CssStyleEx style = new CssStyleEx();
        if (tp.getModel().getTabImageRenderer() != null) {
            borderWidth = tp.getModel().getTabImageRenderer().getImageBorderWidth();
            borderColor = tp.getModel().getTabImageRenderer().getImageBorderColor();
        }
        style.setAttribute("height", String.valueOf(borderWidth) + "px");
        if (borderColor != null && borderWidth > 0) {
            this._setBorderStyle(style, borderColor, borderStyle, 0, 0, borderWidth, borderWidth);
        }
        Component tabComponent = tp.getModel().getTabAt(tp, tp.getSelectedIndex(), true);
        if (tp.getModel().getTabImageRenderer() != null) {
            style.setBackground(tabBackgroundColor);
        } else if (tabComponent != null) {
            Color background = (Color)tabComponent.getRenderProperty("background");
            style.setBackground(background);
        }
        return style.renderInline();
    }

    private String createTabActiveTDStyle(RenderingContext rc, TabbedPane tp, int tabPlacement, Color borderColor, int borderWidth, int borderStyle, int tabBorderStyle) {
        CssStyleEx style = new CssStyleEx();
        if ((tabBorderStyle == 4 || tabBorderStyle == 3) && borderWidth > 0 && borderColor != null) {
            int topWidth = borderWidth;
            int leftWidth = borderWidth;
            int rightWidth = borderWidth;
            int bottomWidth = borderWidth;
            if (tabPlacement == 7) {
                topWidth = 0;
            } else {
                bottomWidth = 0;
            }
            this._setBorderStyle(style, borderColor, borderStyle, topWidth, bottomWidth, leftWidth, rightWidth);
        }
        return style.renderInline();
    }

    private String createTabInActiveLineStyle(RenderingContext rc, TabbedPane tp, Color borderColor, int borderWidth, int borderStyle, int tabBorderStyle) {
        CssStyleEx style = new CssStyleEx();
        if (tp.getModel().getTabImageRenderer() != null) {
            borderColor = tp.getModel().getTabImageRenderer().getImageBorderColor();
        }
        style.setAttribute("height", String.valueOf(borderWidth) + "px");
        if (borderColor != null) {
            style.setBackground(borderColor);
        }
        return style.renderInline();
    }

    private String createTabInactiveTDStyle(RenderingContext rc, TabbedPane tp, int tabPlacement, Color borderColor, int borderWidth, int borderStyle, int tabBorderStyle) {
        return this.createTabActiveTDStyle(rc, tp, tabPlacement, borderColor, borderWidth, borderStyle, tabBorderStyle);
    }

    private void _setBorderStyle(CssStyleEx style, Color borderColor, int borderStyle, int topWidth, int bottomWidth, int leftWidth, int rightWidth) {
        if (borderColor == null || leftWidth == 0 || rightWidth == 0) {
            return;
        }
        String bStyle = this.getBorderStyleString(borderStyle);
        String bColor = ColorKit.makeCSSColor(borderColor);
        if (leftWidth > 0) {
            style.setAttribute("border-left-width", String.valueOf(leftWidth) + "px");
            style.setAttribute("border-left-color", bColor);
            style.setAttribute("border-left-style", bStyle);
        }
        if (rightWidth > 0) {
            style.setAttribute("border-right-width", String.valueOf(rightWidth) + "px");
            style.setAttribute("border-right-color", bColor);
            style.setAttribute("border-right-style", bStyle);
        }
        if (topWidth > 0) {
            style.setAttribute("border-top-width", String.valueOf(topWidth) + "px");
            style.setAttribute("border-top-color", bColor);
            style.setAttribute("border-top-style", bStyle);
        }
        if (bottomWidth > 0) {
            style.setAttribute("border-bottom-width", String.valueOf(bottomWidth) + "px");
            style.setAttribute("border-bottom-color", bColor);
            style.setAttribute("border-bottom-style", bStyle);
        }
    }

    private void setContentBorderStyle(CssStyleEx style, TabbedPane tp, int tabPlacement, Color borderColor, int borderWidth, int borderStyle, int tabBorderStyle) {
        if (borderColor == null || borderWidth < 0) {
            return;
        }
        if ((tabBorderStyle == 3 || tabBorderStyle == 1) && borderWidth > 0 && borderColor != null) {
            int topWidth = borderWidth;
            int leftWidth = borderWidth;
            int rightWidth = borderWidth;
            int bottomWidth = borderWidth;
            if (tabPlacement == 7) {
                bottomWidth = 0;
            } else {
                topWidth = 0;
            }
            this._setBorderStyle(style, borderColor, borderStyle, topWidth, bottomWidth, leftWidth, rightWidth);
        }
    }

    private void drawChild(RenderingContext rc, Component child, Element parent, String containerId) {
        ComponentSynchronizePeer syncPeer = SynchronizePeerFactory.getPeerForComponent(child.getClass());
        if (syncPeer instanceof DomUpdateSupport) {
            ((DomUpdateSupport)((Object)syncPeer)).renderHtml(rc, rc.getServerComponentUpdate(), parent, child);
        } else {
            syncPeer.renderAdd(rc, rc.getServerComponentUpdate(), containerId, child);
        }
    }

    private String getBorderStyleString(int borderStyle) {
        switch (borderStyle) {
            case 8: {
                return "dashed";
            }
            case 7: {
                return "dotted";
            }
            case 6: {
                return "double";
            }
            case 4: {
                return "groove";
            }
            case 2: {
                return "inset";
            }
            case 0: {
                return "none";
            }
            case 3: {
                return "outset";
            }
            case 5: {
                return "ridge";
            }
            case 1: {
                return "solid";
            }
        }
        return "";
    }

    @Override
    public void processAction(ContainerInstance ci, Component component, Element actionElement) {
        String actionName = actionElement.getAttribute("name");
        String actionValue = actionElement.getAttribute("value");
        ci.getUpdateManager().getClientUpdateManager().setComponentAction(component, actionName, actionValue);
    }

    private void registerAllImages(TabbedPane tp, ImageManager iman) {
        ImageReference lead;
        int len = tp.size();
        for (int i = 0; i < len; ++i) {
            this.registerSingleImage(tp, i, iman);
        }
        TabModel model = tp.getModel();
        ImageReference imageReference = lead = model.getTabImageRenderer() == null ? null : model.getTabImageRenderer().getLeadInImage(tp);
        if (lead != null) {
            iman.setImage(LEADIN_IMAGE_PREFIX, lead);
        }
        ImageReference imageReference2 = lead = model.getTabImageRenderer() == null ? null : model.getTabImageRenderer().getLeadOutImage(tp);
        if (lead != null) {
            iman.setImage(LEADOUT_IMAGE_PREFIX, lead);
        }
    }

    private void registerSingleImage(TabbedPane tp, int index, ImageManager iman) {
        if (tp.getModel().getTabImageRenderer() != null) {
            int selectedIndex = tp.getSelectedIndex();
            if (selectedIndex == -1) {
                selectedIndex = 0;
            }
            boolean isSelected = index == selectedIndex;
            Component tabComponent = tp.getModel().getTabAt(tp, index, isSelected);
            ImageReference imageRef = tp.getModel().getTabImageRenderer().getTabImage(tp, index, tabComponent, isSelected);
            if (imageRef == null) {
                throw new IllegalStateException("The TabImageRenderer must return a non null active image at index : " + index);
            }
            iman.setImage(IMAGE_PREFIX + index, imageRef);
        }
    }

    private void renderComplexTabContents(RenderingContext rc, TabbedPane tp, Element contentParent, Color borderColor, int borderWidth, int borderStyle) {
        Style fallbackStyle = EPNG.getFallBackStyle(tp);
        int tabBorderStyle = rc.getRP("tabBorderStyle", fallbackStyle, 3);
        TabImageRenderer renderer = tp.getModel().getTabImageRenderer();
        int index = tp.getSelectedIndex();
        Component tabContent = tp.getModel().getTabContentAt(index);
        Component tabComponent = tp.getModel().getTabAt(tp, index, true);
        CssStyleEx styleContentParent = new CssStyleEx();
        Color background = (Color)rc.getRP("background", fallbackStyle);
        if (renderer != null) {
            styleContentParent.setBackground(background);
        } else if (tabComponent != null) {
            background = (Color)tabComponent.getRenderProperty("background");
            styleContentParent.setBackground(background);
        }
        int tabPlacement = rc.getRP("tabPlacement", fallbackStyle, 6);
        this.setContentBorderStyle(styleContentParent, tp, tabPlacement, borderColor, borderWidth, borderStyle, tabBorderStyle);
        InsetsRender.renderToStyle(styleContentParent, "padding", (Insets)rc.getRP("insets", fallbackStyle));
        Extent heightExtent = (Extent)rc.getRP("height", fallbackStyle);
        if (heightExtent != null) {
            ExtentRender.renderToStyle(styleContentParent, "height", heightExtent);
        }
        styleContentParent.setAttribute("vertical-align", "top");
        styleContentParent.setAttribute("overflow", "hidden");
        contentParent.setAttribute("style", styleContentParent.renderInline());
        if (tabContent != null) {
            CssStyleEx styleContentInner = new CssStyleEx();
            CssStyleEx styleContentOuter = new CssStyleEx();
            Render.asScrollable(styleContentOuter, tp, fallbackStyle);
            if (tabContent instanceof Pane) {
                styleContentInner.setAttribute("height", "400px");
                styleContentInner.setAttribute("position", "relative");
            }
            if (heightExtent != null) {
                ExtentRender.renderToStyle(styleContentInner, "height", heightExtent);
            }
            String outerContentId = rc.getElementId() + "OuterContent";
            String contentContainerId = this.getContainerId(tabContent);
            Element outerContentDiv = rc.createE("div");
            outerContentDiv.setAttribute("id", outerContentId);
            outerContentDiv.setAttribute("style", styleContentOuter.renderInline());
            Element innerContentDiv = rc.createE("div");
            innerContentDiv.setAttribute("id", contentContainerId);
            innerContentDiv.setAttribute("style", styleContentInner.renderInline());
            this.drawChild(rc, tabContent, innerContentDiv, contentContainerId);
            contentParent.appendChild(outerContentDiv);
            outerContentDiv.appendChild(innerContentDiv);
            boolean heightStretched = rc.getRP("heightStretched", fallbackStyle, false);
            if (heightStretched) {
                this.renderInitDirective(rc, tabComponent, outerContentId);
            }
        }
    }

    private void renderComplexTabs(RenderingContext rc, TabbedPane tp, Node parentNode, ImageManager imageManager) {
        Element imgE;
        ImageReference leadInIcon;
        int borderStyle;
        Color borderColor;
        Style fallbackStyle = EPNG.getFallBackStyle(tp);
        TabImageRenderer renderer = tp.getModel().getTabImageRenderer();
        boolean tabImageOnly = renderer != null;
        int tabCount = tp.size();
        int selectedIndex = tp.getSelectedIndex();
        Border border = (Border)rc.getRP("border", fallbackStyle);
        Color color = borderColor = border == null ? null : border.getColor();
        int borderWidth = border == null ? 0 : (border.getSize() == null ? 0 : border.getSize().getValue());
        int n = borderStyle = border == null ? 0 : border.getStyle();
        if (renderer != null) {
            borderColor = renderer.getImageBorderColor();
            borderWidth = renderer.getImageBorderWidth();
        }
        int tabSpacing = rc.getRP("tabSpacing", fallbackStyle, 5);
        int tabPlacement = rc.getRP("tabPlacement", fallbackStyle, 6);
        int tabBorderStyle = rc.getRP("tabBorderStyle", fallbackStyle, 3);
        Extent tabLeadInWidth = (Extent)rc.getRP("tabLeadInWidth", fallbackStyle);
        Color tabBackground = (Color)rc.getRP("background", fallbackStyle);
        String tabActiveLineStyle = this.createTabActiveLineStyle(rc, tp, borderColor, borderWidth, borderStyle, tabBorderStyle, tabBackground);
        String tabActiveTabTDBorderStyle = this.createTabActiveTDStyle(rc, tp, tabPlacement, borderColor, borderWidth, borderStyle, tabBorderStyle);
        String tabInactiveLineStyle = this.createTabInActiveLineStyle(rc, tp, borderColor, borderWidth, borderStyle, tabBorderStyle);
        String tabInActiveTabTDBorderStyle = this.createTabInactiveTDStyle(rc, tp, tabPlacement, borderColor, borderWidth, borderStyle, tabBorderStyle);
        Element trContents = rc.createE("tr");
        Element td = rc.createE("td");
        trContents.appendChild(td);
        this.renderComplexTabContents(rc, tp, td, borderColor, borderWidth, borderStyle);
        Element trTabItems = rc.createE("tr");
        td = rc.createE("td");
        trTabItems.appendChild(td);
        Element tableTabs = rc.createE("table");
        td.appendChild(tableTabs);
        tableTabs.setAttribute("border", "0");
        tableTabs.setAttribute("cellpadding", "0");
        tableTabs.setAttribute("cellspacing", "0");
        tableTabs.setAttribute("width", "100%");
        Element tbodyTabs = rc.createE("tbody");
        tableTabs.appendChild(tbodyTabs);
        Element trItems = rc.createE("tr");
        ImageReference icon = leadInIcon = imageManager.getImage(LEADIN_IMAGE_PREFIX);
        if (icon != null) {
            td = rc.createE("td");
            trItems.appendChild(td);
            td.setAttribute("valign", tabPlacement == 6 ? "bottom" : "top");
            imgE = ImageManager.createImgE(rc, null, icon);
            td.appendChild(imgE);
        }
        if (tabLeadInWidth != null && tabLeadInWidth.getValue() > 0) {
            td = rc.createE("td");
            trItems.appendChild(td);
            td.appendChild(LayoutStrut.createStrut((RenderContext)rc, tabLeadInWidth, new Extent(0)));
        }
        for (int index = 0; index < tabCount; ++index) {
            boolean isSelected = selectedIndex == index;
            td = rc.createE("td");
            trItems.appendChild(td);
            Component tabComponent = tp.getModel().getTabAt(tp, index, isSelected);
            String tabCellId = this.getContainerId(tabComponent);
            if (tabImageOnly) {
                String imagePrefix = IMAGE_PREFIX + index;
                icon = imageManager.getImage(imagePrefix);
                imgE = ImageManager.createImgE(rc, null, icon);
                Element anchorE = rc.createE("a");
                if (tp.isRenderEnabled()) {
                    anchorE.setAttribute("href", "javascript:EP.Event.hrefActionHandler('" + rc.getElementId() + "','click','" + String.valueOf(index) + "')");
                } else {
                    anchorE.setAttribute("href", "javascript:void");
                }
                anchorE.appendChild(imgE);
                td.appendChild(anchorE);
                Element noDisplayE = rc.createE("bdo");
                noDisplayE.setAttribute("id", tabCellId);
                noDisplayE.setAttribute("style", "display:none");
                td.appendChild(noDisplayE);
            } else {
                td.setAttribute("id", tabCellId);
                this.drawChild(rc, tabComponent, td, tabCellId);
            }
            if (!tabImageOnly) {
                if (isSelected) {
                    td.setAttribute("style", tabActiveTabTDBorderStyle);
                } else {
                    td.setAttribute("style", tabInActiveTabTDBorderStyle);
                }
            }
            td.setAttribute("align", "center");
            if (tabPlacement == 6) {
                td.setAttribute("valign", "bottom");
            } else {
                td.setAttribute("valign", "top");
            }
            if (index >= tabCount - 1) continue;
            td = rc.createE("td");
            trItems.appendChild(td);
            td.appendChild(LayoutStrut.createStrut((RenderContext)rc, tabSpacing, 1));
        }
        ImageReference leadOutIcon = imageManager.getImage(LEADOUT_IMAGE_PREFIX);
        icon = leadOutIcon;
        if (icon != null) {
            td = rc.createE("td");
            trItems.appendChild(td);
            td.setAttribute("valign", tabPlacement == 6 ? "bottom" : "top");
            imgE = ImageManager.createImgE(rc, null, icon);
            td.appendChild(imgE);
        }
        td = rc.createE("td");
        trItems.appendChild(td);
        td.setAttribute("width", "100%");
        td.appendChild(LayoutStrut.createStrut((RenderContext)rc, 1, 1));
        if (borderWidth > 0 && borderColor != null) {
            Element trLines = rc.createE("tr");
            int colspanPrev = selectedIndex * 2;
            int colspanPost = (tabCount - selectedIndex) * 2;
            if (leadInIcon != null) {
                ++colspanPrev;
            }
            if (leadOutIcon != null) {
                ++colspanPost;
            }
            if (tabLeadInWidth != null && tabLeadInWidth.getValue() > 0) {
                td = rc.createE("td");
                td.setAttribute("style", tabInactiveLineStyle);
                trLines.appendChild(td);
                td.appendChild(LayoutStrut.createStrut((RenderContext)rc, tabLeadInWidth, new Extent(0)));
            }
            if (selectedIndex > 0 || leadInIcon != null) {
                td = rc.createE("td");
                trLines.appendChild(td);
                td.setAttribute("style", tabInactiveLineStyle);
                td.setAttribute("colspan", "" + colspanPrev);
            }
            td = rc.createE("td");
            trLines.appendChild(td);
            td.setAttribute("style", tabActiveLineStyle);
            td.setAttribute("colspan", "1");
            td = rc.createE("td");
            trLines.appendChild(td);
            td.setAttribute("style", tabInactiveLineStyle);
            td.setAttribute("colspan", "" + colspanPost);
            if (tabPlacement == 6) {
                tbodyTabs.appendChild(trItems);
                tbodyTabs.appendChild(trLines);
            } else {
                tbodyTabs.appendChild(trLines);
                tbodyTabs.appendChild(trItems);
            }
        } else {
            tbodyTabs.appendChild(trItems);
        }
        Element table = rc.createE("table");
        table.setAttribute("border", "0");
        table.setAttribute("cellpadding", "0");
        table.setAttribute("cellspacing", "0");
        Extent width = (Extent)rc.getRP("width", fallbackStyle);
        if (width != null) {
            table.setAttribute("width", width.toString());
        } else {
            table.setAttribute("width", "100%");
        }
        Element tbody = rc.createE("tbody");
        table.appendChild(tbody);
        if (tabPlacement == 6) {
            tbody.appendChild(trTabItems);
            tbody.appendChild(trContents);
        } else {
            tbody.appendChild(trContents);
            tbody.appendChild(trTabItems);
        }
        Element div = rc.createE("div");
        CssStyleEx style = new CssStyleEx();
        InsetsRender.renderToStyle(style, "margin", (Insets)rc.getRP("outsets", fallbackStyle));
        div.setAttribute("style", style.renderInline());
        div.setAttribute("id", rc.getElementId());
        rc.addStandardWebSupport(div);
        div.appendChild(table);
        parentNode.appendChild(div);
    }

    @Override
    public void renderHtml(RenderingContext rc, Node parent, Component component) {
        TabbedPane tp = (TabbedPane)component;
        rc.addLibrary(Resources.EP_SCRIPT_SERVICE);
        rc.addLibrary(Resources.EP_STRETCH_SERVICE);
        ImageManager imageManager = (ImageManager)this.retreiveRenderState(rc, component);
        if (imageManager == null) {
            imageManager = new ImageManager();
            this.storeRenderState(rc, component, imageManager);
        }
        this.registerAllImages(tp, imageManager);
        this.renderComplexTabs(rc, tp, parent, imageManager);
    }

    @Override
    public boolean renderUpdate(RenderContext rcOrig, ServerComponentUpdate update, String targetId) {
        RenderingContext rc = new RenderingContext(rcOrig, update, update.getParent());
        this.renderDisposeDirective(rc, update.getParent());
        return this.renderUpdateBaseImpl(rc, update, targetId, true);
    }

    @Override
    public void renderDispose(RenderContext rcOrig, ServerComponentUpdate update, Component component) {
        RenderingContext rc = new RenderingContext(rcOrig, update, component);
        super.renderDispose(rc, update, component);
        this.renderDisposeDirective(rc, component);
    }

    private void renderDisposeDirective(RenderingContext rc, Component component) {
        rc.addLibrary(Resources.EP_SCRIPT_SERVICE);
        rc.addLibrary(Resources.EP_STRETCH_SERVICE);
        ServerMessage serverMessage = rc.getServerMessage();
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("preremove", "EP.Stretch.MessageProcessor", "dispose", new String[0], new String[0]);
        Element itemElement = serverMessage.getDocument().createElement("item");
        String outerContentId = rc.getElementId() + "OuterContent";
        itemElement.setAttribute("eid", outerContentId);
        itemizedUpdateElement.appendChild(itemElement);
    }

    private void renderInitDirective(RenderingContext rc, Component component, String contentContainerId) {
        Element itemizedUpdateElement = rc.getServerMessage().getItemizedDirective("postupdate", "EP.Stretch.MessageProcessor", "init", new String[0], new String[0]);
        Element itemElement = rc.getDocument().createElement("item");
        itemElement.setAttribute("eid", contentContainerId);
        itemElement.setAttribute("heightStretched", String.valueOf(rc.getRP("heightStretched", false)));
        itemElement.setAttribute("minimumStretchedHeight", this.getExtentPixels(rc.getRP("minimumStretchedHeight", null)));
        itemElement.setAttribute("maximumStretchedHeight", this.getExtentPixels(rc.getRP("maximumStretchedHeight", null)));
        itemizedUpdateElement.appendChild(itemElement);
    }

    private String getExtentPixels(Object extent) {
        if (extent instanceof Extent) {
            return String.valueOf(((Extent)extent).getValue());
        }
        return null;
    }
}

