/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.syncpeer;

import echopointng.EPNG;
import echopointng.StackedPaneEx;
import echopointng.ui.util.CssStyleEx;
import echopointng.ui.util.Render;
import echopointng.ui.util.RenderingContext;
import java.util.HashSet;
import java.util.Set;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Pane;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.LazyRenderContainer;
import nextapp.echo2.webcontainer.PartialUpdateManager;
import nextapp.echo2.webcontainer.PartialUpdateParticipant;
import nextapp.echo2.webcontainer.PropertyUpdateProcessor;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.RenderState;
import nextapp.echo2.webcontainer.SynchronizePeerFactory;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.servermessage.DomUpdate;
import nextapp.echo2.webrender.service.JavaScriptService;
import org.w3c.dom.Element;

public class StackedPaneExPeer
implements ComponentSynchronizePeer,
LazyRenderContainer,
PropertyUpdateProcessor {
    public static final Service STACKED_PANE_SERVICE = JavaScriptService.forResource("EP.StackedPaneEx", "/echopointng/ui/resource/js/stackedpaneex.js");
    private PartialUpdateParticipant activePaneUpdateParticipant = new PartialUpdateParticipant(){

        @Override
        public void renderProperty(RenderContext rc, ServerComponentUpdate update) {
            StackedPaneExPeer.this.renderSetActivePane(rc, update, (StackedPaneEx)update.getParent());
        }

        @Override
        public boolean canRenderProperty(RenderContext rc, ServerComponentUpdate update) {
            return true;
        }
    };
    private PartialUpdateManager partialUpdateManager = new PartialUpdateManager();

    public StackedPaneExPeer() {
        this.partialUpdateManager.add("stack", this.activePaneUpdateParticipant);
    }

    private String getRenderedActivePaneId(ContainerInstance ci, StackedPaneEx stackedPane) {
        StackedPaneExRenderState renderState = (StackedPaneExRenderState)ci.getRenderState(stackedPane);
        return renderState.activePaneId;
    }

    private boolean configureActivePane(ContainerInstance ci, StackedPaneEx stackedPane) {
        StackedPaneExRenderState renderState = (StackedPaneExRenderState)ci.getRenderState(stackedPane);
        int componentCount = stackedPane.getVisibleComponentCount();
        Component activePane = stackedPane.peek();
        if (activePane != null || renderState.activePaneId != null) {
            // empty if block
        }
        if (activePane == null && componentCount == 0) {
            return false;
        }
        if (activePane != null) {
            renderState.activePaneId = activePane.getRenderId();
        } else {
            renderState.activePaneId = null;
        }
        if (this.isLazyRenderEnabled(stackedPane)) {
            if (!this.isRendered(ci, stackedPane, activePane)) {
                this.setRendered(ci, stackedPane, activePane);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public String getContainerId(Component child) {
        return ContainerInstance.getElementId(child.getParent()) + "_content_" + child.getRenderId();
    }

    private Component getChildByRenderId(StackedPaneEx stackedPane, String renderId) {
        Component[] children = stackedPane.getVisibleComponents();
        for (int i = 0; i < children.length; ++i) {
            if (!children[i].getRenderId().equals(renderId)) continue;
            return children[i];
        }
        return null;
    }

    private boolean isLazyRenderEnabled(StackedPaneEx stackedPane) {
        Boolean lazyRenderEnabled = (Boolean)stackedPane.getRenderProperty("lazyRenderEnabled");
        return lazyRenderEnabled == null ? true : lazyRenderEnabled;
    }

    @Override
    public boolean isRendered(ContainerInstance ci, Component parent, Component child) {
        if (!this.isLazyRenderEnabled((StackedPaneEx)parent)) {
            return true;
        }
        StackedPaneExRenderState renderState = (StackedPaneExRenderState)ci.getRenderState(parent);
        if (renderState == null) {
            return false;
        }
        return renderState.renderedChildren.contains(child);
    }

    @Override
    public void processPropertyUpdate(ContainerInstance ci, Component component, Element propertyElement) {
    }

    @Override
    public void renderAdd(RenderContext rcIn, ServerComponentUpdate update, String targetId, Component component) {
        RenderingContext rc = new RenderingContext(rcIn, update, component);
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(STACKED_PANE_SERVICE.getId());
        StackedPaneEx stackedPane = (StackedPaneEx)component;
        ContainerInstance ci = rc.getContainerInstance();
        this.resetRenderState(ci, stackedPane);
        this.configureActivePane(ci, stackedPane);
        this.renderInitDirective(rc, stackedPane, targetId);
        Component[] children = stackedPane.getVisibleComponents();
        for (int i = 0; i < children.length; ++i) {
            this.renderAddPaneDirective(rc, update, stackedPane, children[i]);
        }
        boolean lazyRenderEnabled = this.isLazyRenderEnabled(stackedPane);
        for (int i = 0; i < children.length; ++i) {
            if (lazyRenderEnabled && !this.isRendered(ci, stackedPane, children[i])) continue;
            this.renderChild(rc, update, stackedPane, children[i]);
        }
    }

    private void renderAddChildren(RenderContext rc, ServerComponentUpdate update, boolean activePaneRenderRequired) {
        StackedPaneExRenderState renderState;
        StackedPaneEx stackedPane = (StackedPaneEx)update.getParent();
        ContainerInstance ci = rc.getContainerInstance();
        Component activePane = null;
        if (activePaneRenderRequired && (activePane = this.getChildByRenderId(stackedPane, (renderState = (StackedPaneExRenderState)ci.getRenderState(stackedPane)).activePaneId)) == null) {
            activePaneRenderRequired = false;
        }
        if (update.hasAddedChildren()) {
            Component[] addedChildren = update.getAddedChildren();
            Component[] children = stackedPane.getVisibleComponents();
            block0: for (int i = 0; i < children.length; ++i) {
                for (int j = 0; j < addedChildren.length; ++j) {
                    if (children[i] != addedChildren[j]) continue;
                    this.renderAddPaneDirective(rc, update, stackedPane, children[i]);
                    continue block0;
                }
            }
            boolean lazyRenderEnabled = this.isLazyRenderEnabled(stackedPane);
            for (int i = 0; i < addedChildren.length; ++i) {
                if (lazyRenderEnabled && !this.isRendered(ci, stackedPane, addedChildren[i])) continue;
                this.renderChild(rc, update, stackedPane, addedChildren[i]);
                if (addedChildren[i] != activePane) continue;
                activePaneRenderRequired = false;
            }
        }
        if (activePaneRenderRequired) {
            this.renderChild(rc, update, stackedPane, activePane);
        }
    }

    private void renderAddPaneDirective(RenderContext rc, ServerComponentUpdate update, StackedPaneEx stackedPane, Component child) {
        ContainerInstance ci = rc.getContainerInstance();
        boolean rendered = !this.isLazyRenderEnabled(stackedPane) || this.isRendered(ci, stackedPane, child);
        String elementId = ContainerInstance.getElementId(stackedPane);
        Element addPartElement = rc.getServerMessage().appendPartDirective("update", "EPStackedPaneEx.MessageProcessor", "add-pane");
        addPartElement.setAttribute("eid", elementId);
        addPartElement.setAttribute("pane-id", child.getRenderId());
        addPartElement.setAttribute("pane-index", Integer.toString(stackedPane.indexOf(child)));
        if (rendered) {
            addPartElement.setAttribute("rendered", "true");
        }
        if (child instanceof Pane) {
            addPartElement.setAttribute("pane", "true");
        }
    }

    private void renderChild(RenderContext rc, ServerComponentUpdate update, StackedPaneEx stackedPane, Component child) {
        ComponentSynchronizePeer syncPeer = SynchronizePeerFactory.getPeerForComponent(child.getClass());
        syncPeer.renderAdd(rc, update, this.getContainerId(child), child);
    }

    @Override
    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(STACKED_PANE_SERVICE.getId());
        this.renderDisposeDirective(rc, (StackedPaneEx)component);
    }

    private void renderDisposeDirective(RenderContext rc, StackedPaneEx stackedPane) {
        String elementId = ContainerInstance.getElementId(stackedPane);
        ServerMessage serverMessage = rc.getServerMessage();
        Element initElement = serverMessage.appendPartDirective("preremove", "EPStackedPaneEx.MessageProcessor", "dispose");
        initElement.setAttribute("eid", elementId);
    }

    private void renderInitDirective(RenderingContext rc, StackedPaneEx stackedPane, String targetId) {
        String elementId = ContainerInstance.getElementId(stackedPane);
        ServerMessage serverMessage = rc.getServerMessage();
        Element partElement = serverMessage.addPart("update", "EPStackedPaneEx.MessageProcessor");
        Element initElement = serverMessage.getDocument().createElement("init");
        initElement.setAttribute("container-eid", targetId);
        initElement.setAttribute("eid", elementId);
        if (!stackedPane.isRenderEnabled()) {
            initElement.setAttribute("enabled", "false");
        }
        Style fallbackStyle = EPNG.getFallBackStyle(stackedPane);
        CssStyleEx style = new CssStyleEx(stackedPane, fallbackStyle);
        Render.asBackgroundImageable(rc, style, stackedPane, fallbackStyle);
        Render.layoutFix(rc, style);
        initElement.setAttribute("style", style.renderInline());
        Element standardWebSupportE = rc.getDocument().createElement("standardWebSupport");
        rc.addStandardWebSupport(standardWebSupportE);
        initElement.appendChild(standardWebSupportE);
        String activePaneId = this.getRenderedActivePaneId(rc.getContainerInstance(), stackedPane);
        if (activePaneId != null) {
            initElement.setAttribute("active-pane", activePaneId);
        }
        partElement.appendChild(initElement);
    }

    private void renderRemoveChildren(RenderContext rc, ServerComponentUpdate update) {
        StackedPaneEx stackedPane = (StackedPaneEx)update.getParent();
        Component[] removedChildren = update.getRemovedChildren();
        for (int i = 0; i < removedChildren.length; ++i) {
            this.renderRemovePaneDirective(rc, update, stackedPane, removedChildren[i]);
        }
    }

    private void renderRemovePaneDirective(RenderContext rc, ServerComponentUpdate update, StackedPaneEx stackedPane, Component child) {
        String elementId = ContainerInstance.getElementId(stackedPane);
        Element removePaneElement = rc.getServerMessage().appendPartDirective("remove", "EPStackedPaneEx.MessageProcessor", "remove-pane");
        removePaneElement.setAttribute("eid", elementId);
        removePaneElement.setAttribute("pane-id", child.getRenderId());
    }

    private void renderSetActivePane(RenderContext rc, ServerComponentUpdate update, StackedPaneEx stackedPane) {
        StackedPaneExRenderState renderState;
        ContainerInstance ci = rc.getContainerInstance();
        boolean activePaneRenderRequired = this.configureActivePane(ci, stackedPane);
        Component activePane = null;
        if (activePaneRenderRequired && (activePane = this.getChildByRenderId(stackedPane, (renderState = (StackedPaneExRenderState)ci.getRenderState(stackedPane)).activePaneId)) != null) {
            this.renderChild(rc, update, stackedPane, activePane);
        }
        this.renderSetActivePaneDirective(rc, update, stackedPane);
    }

    private void renderSetActivePaneDirective(RenderContext rc, ServerComponentUpdate update, StackedPaneEx stackedPane) {
        Component activePane = null;
        StackedPaneExRenderState renderState = (StackedPaneExRenderState)rc.getContainerInstance().getRenderState(stackedPane);
        activePane = this.getChildByRenderId(stackedPane, renderState.activePaneId);
        String elementId = ContainerInstance.getElementId(stackedPane);
        Element setActivePaneElement = rc.getServerMessage().appendPartDirective("update", "EPStackedPaneEx.MessageProcessor", "set-active-pane");
        setActivePaneElement.setAttribute("eid", elementId);
        if (activePane != null) {
            setActivePaneElement.setAttribute("active-pane", activePane.getRenderId());
        }
    }

    @Override
    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        ContainerInstance ci = rc.getContainerInstance();
        StackedPaneEx stackedPane = (StackedPaneEx)update.getParent();
        boolean fullReplace = false;
        if (update.hasUpdatedLayoutDataChildren()) {
            fullReplace = true;
        } else if (update.hasUpdatedProperties() && !this.partialUpdateManager.canProcess(rc, update)) {
            fullReplace = true;
        }
        if (fullReplace) {
            DomUpdate.renderElementRemove(rc.getServerMessage(), ContainerInstance.getElementId(update.getParent()));
            this.renderAdd(rc, update, targetId, update.getParent());
        } else {
            if (update.hasRemovedChildren() || update.hasAddedChildren()) {
                boolean activePaneRenderRequired = this.configureActivePane(ci, stackedPane);
                if (update.hasRemovedChildren()) {
                    this.renderRemoveChildren(rc, update);
                }
                if (update.hasAddedChildren() || activePaneRenderRequired) {
                    this.renderAddChildren(rc, update, activePaneRenderRequired);
                }
                this.renderSetActivePaneDirective(rc, update, stackedPane);
            }
            if (update.hasUpdatedProperties()) {
                this.partialUpdateManager.process(rc, update);
            }
        }
        return fullReplace;
    }

    private void resetRenderState(ContainerInstance ci, StackedPaneEx stackedPane) {
        StackedPaneExRenderState renderState = new StackedPaneExRenderState();
        ci.setRenderState(stackedPane, renderState);
    }

    private void setRendered(ContainerInstance ci, StackedPaneEx stackedPane, Component child) {
        StackedPaneExRenderState renderState = (StackedPaneExRenderState)ci.getRenderState(stackedPane);
        if (renderState == null) {
            renderState = new StackedPaneExRenderState();
            ci.setRenderState(stackedPane, renderState);
        }
        renderState.renderedChildren.add(child);
    }

    static {
        WebRenderServlet.getServiceRegistry().add(STACKED_PANE_SERVICE);
    }

    private static class StackedPaneExRenderState
    implements RenderState {
        private String activePaneId;
        private Set renderedChildren = new HashSet();

        private StackedPaneExRenderState() {
        }
    }
}

