/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.syncpeer;

import echopointng.EPNG;
import echopointng.RichTextArea;
import echopointng.richtext.RichTextRenderer;
import echopointng.richtext.RichTextSpellChecker;
import echopointng.ui.resource.Resources;
import echopointng.ui.syncpeer.AbstractEchoPointPeer;
import echopointng.ui.syncpeer.ColorChooserPeer;
import echopointng.ui.util.CssStyleEx;
import echopointng.ui.util.HtmlNodeLexer;
import echopointng.ui.util.HtmlTable;
import echopointng.ui.util.ImageManager;
import echopointng.ui.util.LayoutStrut;
import echopointng.ui.util.Render;
import echopointng.ui.util.RenderingContext;
import java.io.StringWriter;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.ResourceImageReference;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ActionProcessor;
import nextapp.echo2.webcontainer.ContainerContext;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.PartialUpdateParticipant;
import nextapp.echo2.webcontainer.PropertyUpdateProcessor;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webrender.ClientProperties;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.output.CssStyle;
import nextapp.echo2.webrender.servermessage.DomUpdate;
import nextapp.echo2.webrender.service.JavaScriptService;
import nextapp.echo2.webrender.util.DomUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RichTextAreaPeer
extends AbstractEchoPointPeer
implements PropertyUpdateProcessor,
ActionProcessor {
    public static final Service RICH_TEXT_SERVICE = JavaScriptService.forResource("EPNG.RichTextArea", "/echopointng/ui/resource/js/rta.js");
    private static final ImageReference IMAGE_WIGGLY_RED_LINE;

    public RichTextAreaPeer() {
        this.partialUpdateManager.add("text", new PartialUpdateParticipant(){

            @Override
            public boolean canRenderProperty(RenderContext rc, ServerComponentUpdate update) {
                return true;
            }

            @Override
            public void renderProperty(RenderContext rc, ServerComponentUpdate update) {
                RichTextAreaPeer.this.htmlChanged(rc, update);
            }
        });
        this.partialUpdateManager.add("spellCheckInProgress", new PartialUpdateParticipant(){

            @Override
            public boolean canRenderProperty(RenderContext rc, ServerComponentUpdate update) {
                return true;
            }

            @Override
            public void renderProperty(RenderContext rc, ServerComponentUpdate update) {
                RichTextAreaPeer.this.htmlChanged(rc, update);
            }
        });
    }

    private void htmlChanged(RenderContext rc, ServerComponentUpdate update) {
        RichTextArea rta = (RichTextArea)update.getParent();
        String text = rta.getText();
        Element itemizedUpdateElement = rc.getServerMessage().getItemizedDirective("postupdate", "EPRTA.MessageProcessor", "htmlChanged", new String[0], new String[0]);
        Element itemElement = rc.getServerMessage().getDocument().createElement("item");
        itemizedUpdateElement.appendChild(itemElement);
        itemElement.setAttribute("eid", ContainerInstance.getElementId(rta));
        boolean spellCheckInProgress = (Boolean)rta.getRenderProperty("spellCheckInProgress");
        text = this.spellCheckText(rc, itemElement, rta, text, spellCheckInProgress);
        itemElement.setAttribute("html", text);
        itemElement.setAttribute("spellCheckInProgress", String.valueOf(spellCheckInProgress));
    }

    @Override
    public String getContainerId(Component child) {
        throw new UnsupportedOperationException("RichTextArea does not support children.");
    }

    @Override
    public void processPropertyUpdate(ContainerInstance ci, Component component, Element propertyElement) {
        String propertyName = propertyElement.getAttribute("name");
        if ("text".equals(propertyName)) {
            String propertyValue = DomUtil.getElementText(propertyElement);
            propertyValue = this.removeSpellCheckText(propertyValue);
            ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, "text", propertyValue);
        }
    }

    @Override
    public void processAction(ContainerInstance ci, Component component, Element actionElement) {
        String actionName = actionElement.getAttribute("name");
        String actionValue = actionElement.getAttribute("value");
        ci.getUpdateManager().getClientUpdateManager().setComponentAction(component, actionName, actionValue);
    }

    private String removeSpellCheckText(String htmlText) {
        htmlText = HtmlNodeLexer.lex(htmlText, new HtmlNodeLexer.HtmlLexerCallBack(){
            boolean deleting = false;
            String currentTag = null;
            int depthCount;

            @Override
            public StringBuffer onCommentNode(StringBuffer comment) {
                return this.deleting ? null : comment;
            }

            @Override
            public StringBuffer onTextNode(StringBuffer textNode) {
                if (this.deleting) {
                    if ("span".equalsIgnoreCase(this.currentTag)) {
                        return textNode;
                    }
                    return null;
                }
                return textNode;
            }

            @Override
            public StringBuffer onElementNode(StringBuffer element) {
                if (this.deleting) {
                    boolean isTagEnd;
                    boolean isTagStart = element.indexOf("<" + this.currentTag) == 0;
                    boolean bl = isTagEnd = element.indexOf("</" + this.currentTag) == 0;
                    if (isTagStart) {
                        ++this.depthCount;
                    }
                    if (isTagEnd) {
                        if (this.depthCount == 0) {
                            this.deleting = false;
                            return null;
                        }
                        --this.depthCount;
                    }
                    return null;
                }
                if (element.indexOf("class=\"epspell") != -1 || element.indexOf("class=epspell") != -1) {
                    this.deleting = true;
                    this.depthCount = 0;
                    this.currentTag = this.getTag(element);
                    return null;
                }
                return element;
            }

            private String getTag(StringBuffer element) {
                StringBuffer tagName = new StringBuffer();
                int len = element.length();
                char[] chars = new char[len];
                element.getChars(0, len, chars, 0);
                for (int i = 0; i < chars.length; ++i) {
                    if (chars[i] == '<' || chars[i] == '/') continue;
                    if (chars[i] == ' ' || chars[i] == '>') break;
                    tagName.append(chars[i]);
                }
                return tagName.toString();
            }
        });
        return htmlText;
    }

    private String spellCheckText(final RenderContext rc, final Element directiveItem, RichTextArea rta, String htmlText, boolean spellCheckInProgress) {
        final String elementId = ContainerInstance.getElementId(rta);
        final RichTextSpellChecker spellChecker = rta.getSpellChecker();
        if (htmlText == null || htmlText.trim().length() == 0 || spellChecker == null) {
            return htmlText;
        }
        boolean alreadyHasSpellingMarkup = false;
        if (htmlText.indexOf("class=\"epspell\"") != -1) {
            alreadyHasSpellingMarkup = true;
        } else if (htmlText.indexOf("class=epspell") != -1) {
            alreadyHasSpellingMarkup = true;
        }
        if (spellCheckInProgress) {
            if (alreadyHasSpellingMarkup) {
                return htmlText;
            }
            String newHtmlText = HtmlNodeLexer.lex(htmlText, new HtmlNodeLexer.HtmlLexerCallBack(){
                int spellCount = 0;

                @Override
                public StringBuffer onCommentNode(StringBuffer comment) {
                    return comment;
                }

                @Override
                public StringBuffer onElementNode(StringBuffer element) {
                    return element;
                }

                @Override
                public StringBuffer onTextNode(StringBuffer textNode) {
                    StringBuffer newTextNode = new StringBuffer();
                    RichTextSpellChecker.SpellCheckerWord[] words = spellChecker.parseWords(textNode.toString());
                    int lastStartIndex = 0;
                    for (int i = 0; i < words.length; ++i) {
                        int startIndex = words[i].getStartIndex();
                        int endIndex = words[i].getEndIndex();
                        String prevText = textNode.substring(lastStartIndex, startIndex);
                        newTextNode.append(prevText);
                        lastStartIndex = endIndex;
                        String word = textNode.substring(startIndex, endIndex);
                        if (word.length() <= 0) continue;
                        String[] alternatives = spellChecker.checkWord(word);
                        if (alternatives != null) {
                            StringBuffer specialSpanText = new StringBuffer();
                            String spellId = elementId + '|' + this.spellCount;
                            ++this.spellCount;
                            specialSpanText.append("<span class=\"epspell\" id=\"");
                            specialSpanText.append(spellId);
                            specialSpanText.append("\">");
                            specialSpanText.append(word);
                            specialSpanText.append("</span>");
                            newTextNode.append(specialSpanText);
                            StringBuffer spellings = new StringBuffer();
                            if (alternatives.length == 0) {
                                spellings.append(words);
                            } else {
                                for (int j = 0; j < alternatives.length; ++j) {
                                    if (j > 0) {
                                        spellings.append("##");
                                    }
                                    spellings.append(alternatives[j]);
                                }
                            }
                            Element spellingItem = rc.getServerMessage().getDocument().createElement("spelling");
                            directiveItem.appendChild(spellingItem);
                            spellingItem.setAttribute("spellId", spellId);
                            spellingItem.setAttribute("spellings", spellings.toString());
                            continue;
                        }
                        newTextNode.append(word);
                    }
                    if (lastStartIndex < textNode.length()) {
                        String endText = textNode.substring(lastStartIndex, textNode.length());
                        newTextNode.append(endText);
                    }
                    return newTextNode;
                }
            });
            if (!newHtmlText.equals(htmlText)) {
                return newHtmlText;
            }
            return htmlText;
        }
        return htmlText;
    }

    @Override
    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        super.renderDispose(rc, update, component);
        this.createDisposeDirective(rc.getServerMessage(), ContainerInstance.getElementId(component));
        String boxId = ContainerInstance.getElementId(component) + "CC";
        DomUpdate.renderElementRemove(rc.getServerMessage(), boxId);
        rc.getServerMessage().addLibrary(Resources.EP_SCRIPT_SERVICE.getId());
        rc.getServerMessage().addLibrary(RICH_TEXT_SERVICE.getId());
        rc.getServerMessage().addLibrary(ColorChooserPeer.CC_SERVICE.getId());
    }

    @Override
    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        boolean fullReplace = false;
        if (update.hasUpdatedProperties()) {
            if (this.partialUpdateManager.canProcess(rc, update)) {
                this.partialUpdateManager.process(rc, update);
            } else {
                fullReplace = true;
            }
        }
        if (fullReplace) {
            String elementId = ContainerInstance.getElementId(update.getParent());
            DomUpdate.renderElementRemove(rc.getServerMessage(), elementId);
            this.renderAdd(rc, update, targetId, update.getParent());
        }
        return false;
    }

    @Override
    public void renderHtml(RenderingContext rc, Node parent, Component component) {
        Element tdToolbar;
        Element tdIframe;
        Style fallbackStyle = EPNG.getFallBackStyle(component);
        String elementId = rc.getElementId();
        RichTextArea rta = (RichTextArea)component;
        RichTextRenderer rtaRenderer = (RichTextRenderer)rc.getRP("renderer", fallbackStyle);
        ApplicationInstance app = ApplicationInstance.getActive();
        ContainerContext containerContext = (ContainerContext)app.getContextProperty(ContainerContext.CONTEXT_PROPERTY_NAME);
        ClientProperties clientProperties = containerContext.getClientProperties();
        String userAgent = clientProperties.getString("navigatorUserAgent");
        rc.addLibrary(Resources.EP_SCRIPT_SERVICE);
        rc.addLibrary(RICH_TEXT_SERVICE);
        rc.addLibrary(ColorChooserPeer.CC_SERVICE);
        int toolbarAligment = rc.getRP("toolBarAlignment", fallbackStyle, 6);
        String ifwidth = "100%";
        String ifheight = "100%";
        CssStyleEx style = new CssStyleEx();
        style.setAttribute("height", ifheight);
        style.setAttribute("width", ifwidth);
        Render.asColors(style, rta, "editorBackground", "editorBackground", fallbackStyle);
        Render.asFont(style, rta, "editorFont", fallbackStyle);
        Render.asBorder(style, rta, "editorBorder", fallbackStyle);
        String styleIFRAME = style.renderInline();
        style = new CssStyleEx();
        style.setBackground((Color)rc.getRP("toolBarBackground", fallbackStyle));
        style.setAttribute("text-align", "left");
        String styleToolbarContainer = style.renderInline();
        style = new CssStyleEx();
        style.setAttribute("padding-right", "2px");
        style.setAttribute("vertical-align", "top");
        String rtatbCell = style.renderInline();
        Element iframe = rc.createE("iframe");
        iframe.setAttribute("style", styleIFRAME);
        iframe.setAttribute("id", elementId + "IFrame");
        iframe.setAttribute("src", "about:blank");
        if (!rc.getRP("editable", fallbackStyle, true)) {
            iframe.setAttribute("readonly", "readonly");
        }
        if (!rta.isRenderEnabled()) {
            iframe.setAttribute("disabled", "disabled");
        }
        Element iframeContainer = iframe;
        HtmlTable tableToolbarContainer = new HtmlTable(rc.getDocument(), 0, 0, 0);
        tableToolbarContainer.setAttribute("style", styleToolbarContainer);
        Element td = tableToolbarContainer.getTD();
        int cellCount = 0;
        HtmlTable tableSelectFields = new HtmlTable(rc.getDocument(), 0, 0, 0);
        String[][] paragraphStyles = rtaRenderer.getParagraphStyles(rta, userAgent);
        String[][] fontNames = rtaRenderer.getFontNames(rta, userAgent);
        String[][] fontSizes = rtaRenderer.getFontSizes(rta, userAgent);
        if (paragraphStyles != null || fontNames != null || fontSizes != null) {
            if (paragraphStyles != null) {
                tableSelectFields.getTD().setAttribute("style", rtatbCell);
                tableSelectFields.getTD().appendChild(this.renderSelect(rc, elementId, "formatblock", "Paragraph Style", paragraphStyles));
                ++cellCount;
            }
            if (fontNames != null) {
                if (cellCount > 0) {
                    tableSelectFields.newTD();
                }
                tableSelectFields.getTD().setAttribute("style", rtatbCell);
                tableSelectFields.getTD().appendChild(this.renderSelect(rc, elementId, "fontname", "Font Name", fontNames));
                ++cellCount;
            }
            if (fontSizes != null) {
                if (cellCount > 0) {
                    tableSelectFields.newTD();
                }
                tableSelectFields.getTD().setAttribute("style", rtatbCell);
                tableSelectFields.getTD().appendChild(this.renderSelect(rc, elementId, "fontsize", "Font Size", fontSizes));
                ++cellCount;
            }
            td.appendChild(tableSelectFields.getTABLE());
            if (toolbarAligment == 7) {
                td.setAttribute("style", "padding-top:2px;padding-bottom:2px;");
            } else {
                td.setAttribute("style", "padding-bottom:2px;");
            }
        }
        this.renderAllButtons(rc, tableToolbarContainer, rta, elementId, rtatbCell, userAgent);
        HtmlTable tableEditor = new HtmlTable(rc.getDocument(), 0, 0, 0);
        tableEditor.setAttribute("width", "100%");
        tableEditor.setAttribute("height", "100%");
        if (toolbarAligment == 7) {
            tdIframe = tableEditor.getTD();
            tdToolbar = tableEditor.newTR();
        } else {
            tdToolbar = tableEditor.getTD();
            tdIframe = tableEditor.newTR();
        }
        tdToolbar.appendChild(tableToolbarContainer.getTABLE());
        tdIframe.appendChild(iframeContainer);
        tdIframe.setAttribute("style", "height:100%");
        style = new CssStyleEx(rta, fallbackStyle);
        Render.asFillImage(style, rta, "backgroundImage", fallbackStyle, rc);
        if (!rta.isRenderEnabled()) {
            Render.asColors(style, rta, "disabledBackground", "disabledForeground", fallbackStyle);
            Render.asFont(style, rta, "disabledFont", fallbackStyle);
            Render.asBorder(style, rta, "disabledBorder", fallbackStyle);
            Render.asFillImage(style, rta, "disabledBackgroundImage", fallbackStyle, rc);
        }
        Element divOuter = rc.createE("div");
        divOuter.setAttribute("id", elementId);
        divOuter.setAttribute("style", style.renderInline());
        rc.addStandardWebSupport(divOuter);
        divOuter.appendChild(tableEditor.getTABLE());
        parent.appendChild(divOuter);
        this.createInitDirective(rc, rta, userAgent);
    }

    private Element renderAButton(RenderingContext rc, String rtaId, String cmd, ImageReference imageReference, String tooltip) {
        Element imgE = ImageManager.createImgE(rc, imageReference);
        imgE.setAttribute("id", rtaId + "_" + cmd);
        imgE.setAttribute("title", tooltip);
        return imgE;
    }

    private void renderAllButtons(RenderingContext rc, HtmlTable tableOut, RichTextArea rta, String rtaId, String rtatbCell, String userAgent) {
        RichTextRenderer rtaRenderer = rta.getRenderer();
        HtmlTable tableIn = new HtmlTable(rc.getDocument());
        tableOut.getTD().appendChild(tableIn.getTABLE());
        Element td = null;
        int cellCount = 0;
        String[][] commands = rtaRenderer.getSupportedCommands(rta, userAgent);
        for (int i = 0; i < commands.length; ++i) {
            String cmd = commands[i][0];
            String toolTip = commands[i][1];
            ImageReference image = rtaRenderer.getCommandImage(rta, userAgent, cmd);
            if (cmd == "hintNewLine") {
                tableIn = new HtmlTable(rc.getDocument());
                tableOut.newTR();
                tableOut.getTD().appendChild(tableIn.getTABLE());
                cellCount = 0;
                continue;
            }
            if (cmd == "hintSpacer") {
                td = tableIn.newTD();
                td.appendChild(LayoutStrut.createStrut((RenderContext)rc, 5, 1));
                continue;
            }
            td = cellCount == 0 ? tableIn.getTD() : tableIn.newTD();
            td.setAttribute("style", rtatbCell);
            td.setAttribute("align", "left");
            td.appendChild(this.renderAButton(rc, rtaId, cmd, image, toolTip));
            ++cellCount;
        }
    }

    private boolean isCommandSupported(String command, RichTextArea rta, RichTextRenderer rtaRenderer, String userAgent) {
        String[][] commands = rtaRenderer.getSupportedCommands(rta, userAgent);
        if (commands != null) {
            for (int i = 0; i < commands.length; ++i) {
                if (!commands[i][0].equals(command)) continue;
                return true;
            }
        }
        return false;
    }

    private Element renderSelect(RenderingContext rc, String rtaId, String cmd, String tooltip, String[][] valuesAndNames) {
        Element option;
        Element select = rc.createE("select");
        select.setAttribute("id", rtaId + "_" + cmd);
        select.setAttribute("title", tooltip);
        for (int i = 0; i < valuesAndNames.length; ++i) {
            option = rc.createE("option");
            select.appendChild(option);
            option.setAttribute("value", valuesAndNames[i][0]);
            option.appendChild(rc.createText(valuesAndNames[i][1]));
        }
        option = rc.createE("option");
        select.appendChild(option);
        option.setAttribute("value", "");
        option.appendChild(rc.createText("   "));
        return select;
    }

    public static String removeNewLinesAndJSQuote(StringWriter sw, char quoteChar) {
        return RichTextAreaPeer.removeNewLinesAndJSQuote(sw.toString(), quoteChar);
    }

    public static String removeNewLinesAndJSQuote(String s, char quoteChar) {
        if (s == null) {
            return null;
        }
        StringBuffer sbTemp = new StringBuffer(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == quoteChar) {
                sbTemp.append('\\');
                sbTemp.append(quoteChar);
                continue;
            }
            if (c == '\r' || c == '\n') continue;
            sbTemp.append(c);
        }
        return sbTemp.toString();
    }

    protected void createDisposeDirective(ServerMessage serverMessage, String elementId) {
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("preremove", "EPRTA.MessageProcessor", "dispose", new String[0], new String[0]);
        Element itemElement = serverMessage.getDocument().createElement("item");
        itemElement.setAttribute("eid", elementId);
        itemizedUpdateElement.appendChild(itemElement);
    }

    protected void createInitDirective(RenderingContext rc, RichTextArea rta, String userAgent) {
        RichTextRenderer rtaRenderer = rta.getRenderer();
        RichTextRenderer.CommandAppearance appearance = rtaRenderer.getCommandAppearance(rta, userAgent);
        CssStyleEx style = new CssStyleEx();
        style.setAttribute("left", "0");
        style.setAttribute("top", "0");
        style.setAttribute("position", "relative");
        if (appearance != null) {
            Render.asBorder(style, appearance.getBorder());
            Render.asColor(style, appearance.getBackground(), "background-color");
        } else {
            style.setAttribute("background-color", "#efefef");
            style.setAttribute("border-bottom", "buttonface solid 1px");
            style.setAttribute("border-left", "buttonface solid 1px");
            style.setAttribute("border-right", "buttonface solid 1px");
            style.setAttribute("border-top", "buttonface solid 1px");
        }
        String upItemStyle = style.renderInline();
        style = new CssStyleEx();
        style.setAttribute("left", "0");
        style.setAttribute("top", "0");
        style.setAttribute("position", "relative");
        if (appearance != null) {
            Render.asBorder(style, appearance.getSelectedBorder());
            Render.asColor(style, appearance.getSelectedBackground(), "background-color");
        } else {
            style.setAttribute("background-color", "buttonface");
            style.setAttribute("border-bottom", "buttonhighlight solid 1px");
            style.setAttribute("border-left", "buttonshadow    solid 1px");
            style.setAttribute("border-right", "buttonhighlight solid 1px");
            style.setAttribute("border-top", "buttonshadow    solid 1px");
        }
        String downItemStyle = style.renderInline();
        style = new CssStyleEx();
        style.setAttribute("position", "relative");
        style.setAttribute("left", "0");
        style.setAttribute("top", "0");
        if (appearance != null) {
            Render.asBorder(style, appearance.getRolloverBorder());
            Render.asColor(style, appearance.getRolloverBackground(), "background-color");
        } else {
            style.setAttribute("background-color", "#efefef");
            style.setAttribute("border-bottom", "buttonshadow    solid 1px");
            style.setAttribute("border-left", "buttonhighlight solid 1px");
            style.setAttribute("border-right", "buttonshadow    solid 1px");
            style.setAttribute("border-top", "buttonhighlight solid 1px");
        }
        String upMouseOverStyle = style.renderInline();
        style = new CssStyleEx();
        style.setAttribute("position", "relative");
        style.setAttribute("left", "0");
        style.setAttribute("top", "0");
        if (appearance != null) {
            Render.asBorder(style, appearance.getRolloverBorder());
            Render.asColor(style, appearance.getRolloverBackground(), "background-color");
        } else {
            style.setAttribute("background-color", "#efefef");
            style.setAttribute("border-bottom", "buttonhighlight solid 1px");
            style.setAttribute("border-left", "buttonshadow    solid 1px");
            style.setAttribute("border-right", "buttonhighlight solid 1px");
            style.setAttribute("border-top", "buttonshadow    solid 1px");
        }
        String downMouseOverStyle = style.renderInline();
        style = new CssStyleEx();
        style.setAttribute("font-size", "10pt");
        String selectStyle = style.renderInline();
        Element itemizedUpdateElement = rc.getServerMessage().getItemizedDirective("postupdate", "EPRTA.MessageProcessor", "init", new String[0], new String[0]);
        Element itemElement = rc.createE("item");
        itemElement.setAttribute("eid", rc.getElementId());
        itemizedUpdateElement.appendChild(itemElement);
        style = new CssStyleEx();
        Render.asColors(style, rta, "editorBackground", "editorForeground");
        Render.asFont((CssStyle)style, (Component)rta, "editorFont");
        String cssText = "";
        cssText = cssText + "body { ";
        cssText = cssText + style.renderInline();
        cssText = cssText + "}";
        String wigglyUrl = ImageManager.getURI(rc, IMAGE_WIGGLY_RED_LINE);
        cssText = cssText + ".epspell { ";
        cssText = cssText + "\tbackground : url(" + wigglyUrl + ")  repeat-x bottom";
        cssText = cssText + "}";
        cssText = cssText + ".epspellplain { ";
        cssText = cssText + "}";
        cssText = cssText + ".epspellbox {";
        cssText = cssText + "\tbackground-color : #C6DBFF;";
        cssText = cssText + "\tborder-color : EFEFDE; ;";
        cssText = cssText + "\tborder-width : 2px;";
        cssText = cssText + "\tborder-style : outset;";
        cssText = cssText + "\tpadding : 2px;";
        cssText = cssText + "}";
        cssText = cssText + ".epspelloption {";
        cssText = cssText + "\tcolor : #000000;";
        cssText = cssText + "\tbackground-color : #C6DBFF;";
        cssText = cssText + "\tpadding-left : 5px;";
        cssText = cssText + "}";
        cssText = cssText + ".epspelloptionhilight {";
        cssText = cssText + "\tcolor : #ffffff;";
        cssText = cssText + "\tbackground-color : #5271CE;";
        cssText = cssText + "\tpadding-left : 5px;";
        cssText = cssText + "}";
        boolean spellCheckInProgress = (Boolean)rta.getRenderProperty("spellCheckInProgress");
        String htmlText = rta.getText();
        htmlText = htmlText == null ? "" : htmlText;
        htmlText = this.spellCheckText(rc, itemElement, rta, htmlText, spellCheckInProgress);
        StringBuffer htmlDocument = new StringBuffer();
        htmlDocument.append("<html>");
        htmlDocument.append("<head>");
        htmlDocument.append("<style>" + cssText + "</style>");
        htmlDocument.append("</head>");
        htmlDocument.append("<body>");
        htmlDocument.append(htmlText);
        htmlDocument.append("</body>");
        htmlDocument.append("</html>");
        itemElement.setAttribute("htmlDocument", htmlDocument.toString());
        itemElement.setAttribute("initialText", htmlText);
        itemElement.setAttribute("spellCheckInProgress", String.valueOf(spellCheckInProgress));
        Element landfItem = rc.createE("landf");
        landfItem.setAttribute("tag", "button");
        landfItem.setAttribute("upItemStyle", upItemStyle);
        landfItem.setAttribute("downItemStyle", downItemStyle);
        landfItem.setAttribute("upMouseOverStyle", upMouseOverStyle);
        landfItem.setAttribute("downMouseOverStyle", downMouseOverStyle);
        itemElement.appendChild(landfItem);
        landfItem = rc.createE("landf");
        landfItem.setAttribute("tag", "select");
        landfItem.setAttribute("selectStyle", selectStyle);
        itemElement.appendChild(landfItem);
        if (this.isCommandSupported("bold", rta, rtaRenderer, userAgent)) {
            this.createButtonCommand(rc, itemElement, "bold", true);
        }
        if (this.isCommandSupported("italic", rta, rtaRenderer, userAgent)) {
            this.createButtonCommand(rc, itemElement, "italic", true);
        }
        if (this.isCommandSupported("underline", rta, rtaRenderer, userAgent)) {
            this.createButtonCommand(rc, itemElement, "underline", true);
        }
        if (this.isCommandSupported("subscript", rta, rtaRenderer, userAgent)) {
            this.createButtonCommand(rc, itemElement, "subscript", true);
        }
        if (this.isCommandSupported("superscript", rta, rtaRenderer, userAgent)) {
            this.createButtonCommand(rc, itemElement, "superscript", true);
        }
        if (this.isCommandSupported("removeformat", rta, rtaRenderer, userAgent)) {
            this.createButtonCommand(rc, itemElement, "removeformat", true);
        }
        if (this.isCommandSupported("forecolor", rta, rtaRenderer, userAgent)) {
            this.createButtonCommand(rc, itemElement, "forecolor", false);
        }
        if (this.isCommandSupported("hilitecolor", rta, rtaRenderer, userAgent)) {
            this.createButtonCommand(rc, itemElement, "hilitecolor", false);
        }
        if (this.isCommandSupported("justifyleft", rta, rtaRenderer, userAgent)) {
            this.createButtonCommand(rc, itemElement, "justifyleft", true);
        }
        if (this.isCommandSupported("justifycenter", rta, rtaRenderer, userAgent)) {
            this.createButtonCommand(rc, itemElement, "justifycenter", true);
        }
        if (this.isCommandSupported("justifyright", rta, rtaRenderer, userAgent)) {
            this.createButtonCommand(rc, itemElement, "justifyright", true);
        }
        if (this.isCommandSupported("justifyfull", rta, rtaRenderer, userAgent)) {
            this.createButtonCommand(rc, itemElement, "justifyfull", true);
        }
        if (this.isCommandSupported("indent", rta, rtaRenderer, userAgent)) {
            this.createButtonCommand(rc, itemElement, "indent", false);
        }
        if (this.isCommandSupported("outdent", rta, rtaRenderer, userAgent)) {
            this.createButtonCommand(rc, itemElement, "outdent", false);
        }
        if (this.isCommandSupported("insertorderedlist", rta, rtaRenderer, userAgent)) {
            this.createButtonCommand(rc, itemElement, "insertorderedlist", true);
        }
        if (this.isCommandSupported("insertunorderedlist", rta, rtaRenderer, userAgent)) {
            this.createButtonCommand(rc, itemElement, "insertunorderedlist", true);
        }
        if (this.isCommandSupported("copy", rta, rtaRenderer, userAgent)) {
            this.createButtonCommand(rc, itemElement, "copy", false);
        }
        if (this.isCommandSupported("cut", rta, rtaRenderer, userAgent)) {
            this.createButtonCommand(rc, itemElement, "cut", false);
        }
        if (this.isCommandSupported("paste", rta, rtaRenderer, userAgent)) {
            this.createButtonCommand(rc, itemElement, "paste", false);
        }
        if (this.isCommandSupported("selectall", rta, rtaRenderer, userAgent)) {
            this.createButtonCommand(rc, itemElement, "selectall", false);
        }
        if (this.isCommandSupported("undo", rta, rtaRenderer, userAgent)) {
            this.createButtonCommand(rc, itemElement, "undo", false);
        }
        if (this.isCommandSupported("redo", rta, rtaRenderer, userAgent)) {
            this.createButtonCommand(rc, itemElement, "redo", false);
        }
        if (this.isCommandSupported("spellcheck", rta, rtaRenderer, userAgent)) {
            this.createButtonCommand(rc, itemElement, "spellcheck", false);
        }
        if (this.isCommandSupported("inserthorizontalrule", rta, rtaRenderer, userAgent)) {
            this.createButtonCommand(rc, itemElement, "inserthorizontalrule", false);
        }
        if (this.isCommandSupported("createlink", rta, rtaRenderer, userAgent)) {
            this.createButtonCommand(rc, itemElement, "createlink", false);
        }
        if (this.isCommandSupported("insertimage", rta, rtaRenderer, userAgent)) {
            this.createButtonCommand(rc, itemElement, "insertimage", false);
        }
        if (rtaRenderer.getFontNames(rta, userAgent) != null) {
            this.createSelectCommand(rc, itemElement, "fontname");
        }
        if (rtaRenderer.getFontSizes(rta, userAgent) != null) {
            this.createSelectCommand(rc, itemElement, "fontsize");
        }
        if (rtaRenderer.getParagraphStyles(rta, userAgent) != null) {
            this.createSelectCommand(rc, itemElement, "formatblock");
        }
    }

    private void createButtonCommand(RenderingContext rc, Element parentE, String cmd, boolean isStateful) {
        this.createCommandImpl(rc, parentE, "button", cmd, isStateful);
    }

    private void createSelectCommand(RenderingContext rc, Element parentE, String cmd) {
        this.createCommandImpl(rc, parentE, "select", cmd, false);
    }

    private void createCommandImpl(RenderingContext rc, Element parentE, String tag, String cmd, boolean isStateful) {
        Element cmdE = rc.createE("command");
        cmdE.setAttribute("tag", tag);
        cmdE.setAttribute("cmd", cmd);
        cmdE.setAttribute("isStateful", String.valueOf(isStateful));
        parentE.appendChild(cmdE);
    }

    static {
        WebRenderServlet.getServiceRegistry().add(RICH_TEXT_SERVICE);
        IMAGE_WIGGLY_RED_LINE = new ResourceImageReference("/echopointng/resource/images/richtext/ep_rt_wiggly_redline.gif");
    }
}

