/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.syncpeer;

import echopointng.ComponentEx;
import echopointng.EPNG;
import echopointng.ui.util.ImageManager;
import echopointng.ui.util.RenderingContext;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.PartialUpdateManager;
import nextapp.echo2.webcontainer.PartialUpdateParticipant;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.servermessage.DomUpdate;
import nextapp.echo2.webrender.service.JavaScriptService;
import org.w3c.dom.Element;

public class LightBoxPeer
implements ComponentSynchronizePeer {
    public static final Service LB_SERVICE = JavaScriptService.forResource("EPNG.LightBox", "/echopointng/ui/resource/js/lightbox.js");
    protected PartialUpdateManager partialUpdateManager = new PartialUpdateManager();

    public LightBoxPeer() {
        this.partialUpdateManager.add("hidden", new PartialUpdateParticipant(){

            @Override
            public void renderProperty(RenderContext rc, ServerComponentUpdate update) {
                LightBoxPeer.this.renderHiddenDirective(rc, update.getParent());
            }

            @Override
            public boolean canRenderProperty(RenderContext rc, ServerComponentUpdate update) {
                return true;
            }
        });
    }

    @Override
    public String getContainerId(Component component) {
        throw new UnsupportedOperationException("Component does not support children.");
    }

    @Override
    public void renderAdd(RenderContext rc, ServerComponentUpdate update, String targetId, Component component) {
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(LB_SERVICE.getId());
        this.renderInitDirective(new RenderingContext(rc, update, component), targetId, component);
    }

    @Override
    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(LB_SERVICE.getId());
        this.renderDisposeDirective(rc, component);
    }

    @Override
    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        boolean fullReplace = false;
        if (update.hasUpdatedProperties() && !this.partialUpdateManager.canProcess(rc, update)) {
            fullReplace = true;
        }
        if (fullReplace) {
            DomUpdate.renderElementRemove(rc.getServerMessage(), ContainerInstance.getElementId(update.getParent()));
            this.renderAdd(rc, update, targetId, update.getParent());
        } else {
            this.partialUpdateManager.process(rc, update);
        }
        return fullReplace;
    }

    private void renderDisposeDirective(RenderContext rc, Component component) {
        Element itemizedUpdateElement = rc.getServerMessage().getItemizedDirective("preremove", "EPLightBox.MessageProcessor", "dispose", new String[0], new String[0]);
        Element itemElement = rc.getServerMessage().getDocument().createElement("item");
        itemElement.setAttribute("eid", ContainerInstance.getElementId(component));
        itemizedUpdateElement.appendChild(itemElement);
    }

    private void renderHiddenDirective(RenderContext rc, Component component) {
        Element itemizedUpdateElement = rc.getServerMessage().getItemizedDirective("postupdate", "EPLightBox.MessageProcessor", "hidden", new String[0], new String[0]);
        Element itemElement = rc.getServerMessage().getDocument().createElement("item");
        itemizedUpdateElement.appendChild(itemElement);
        itemElement.setAttribute("eid", ContainerInstance.getElementId(component));
        boolean hidden = ComponentEx.getRenderProperty(component, "hidden", false);
        itemElement.setAttribute("hidden", String.valueOf(hidden));
    }

    private void renderInitDirective(RenderingContext rc, String containerId, Component component) {
        Style fallbackStyle = EPNG.getFallBackStyle(component);
        String elementId = ContainerInstance.getElementId(component);
        ServerMessage serverMessage = rc.getServerMessage();
        Element itemizedUpdateElement = serverMessage.appendPartDirective("update", "EPLightBox.MessageProcessor", "init");
        Element itemElement = rc.getServerMessage().getDocument().createElement("item");
        itemizedUpdateElement.appendChild(itemElement);
        itemElement.setAttribute("eid", elementId);
        itemElement.setAttribute("container-eid", containerId);
        itemElement.setAttribute("hidden", String.valueOf(rc.getRP("hidden", fallbackStyle, false)));
        itemElement.setAttribute("enabled", String.valueOf(component.isRenderEnabled()));
        ImageReference translucentImage = (ImageReference)rc.getRP("translucentImage", fallbackStyle);
        if (translucentImage != null) {
            itemElement.setAttribute("translucentImage", ImageManager.getURI(rc, translucentImage));
        }
    }

    static {
        WebRenderServlet.getServiceRegistry().add(LB_SERVICE);
    }
}

