/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.syncpeer;

import echopointng.KeyStrokeListener;
import echopointng.ui.resource.Resources;
import echopointng.ui.syncpeer.AbstractEchoPointPeer;
import echopointng.ui.util.RenderingContext;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ActionProcessor;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.service.JavaScriptService;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class KeyStrokeListenerPeer
extends AbstractEchoPointPeer
implements ActionProcessor {
    public static final Service KEYSTROKE_SERVICE = JavaScriptService.forResource("EPNG.KeyStroke", "/echopointng/ui/resource/js/keystroke.js");

    @Override
    public String getContainerId(Component child) {
        throw new UnsupportedOperationException("Component does not support children.");
    }

    @Override
    public void processAction(ContainerInstance ci, Component component, Element actionElement) {
        String actionValue = actionElement.getAttribute("value");
        Integer key = Integer.valueOf(actionValue);
        ci.getUpdateManager().getClientUpdateManager().setComponentAction(component, "keyStroke", key);
    }

    @Override
    public void renderHtml(RenderingContext rc, Node parentNode, Component component) {
        KeyStrokeListener ks = (KeyStrokeListener)component;
        rc.addLibrary(Resources.EP_SCRIPT_SERVICE);
        rc.addLibrary(KEYSTROKE_SERVICE);
        Element bdo = rc.createE("bdo");
        bdo.setAttribute("id", rc.getElementId());
        parentNode.appendChild(bdo);
        this.createInitDirective(rc, ks);
    }

    @Override
    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        super.renderDispose(rc, update, component);
        rc.getServerMessage().addLibrary(Resources.EP_SCRIPT_SERVICE.getId());
        rc.getServerMessage().addLibrary(KEYSTROKE_SERVICE.getId());
        this.createDisposeDirective(rc.getServerMessage(), component);
    }

    protected void createDisposeDirective(ServerMessage serverMessage, Component component) {
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("preremove", "EPKeyStroke.MessageProcessor", "dispose", new String[0], new String[0]);
        Element itemElement = serverMessage.getDocument().createElement("item");
        itemElement.setAttribute("eid", ContainerInstance.getElementId(component));
        itemizedUpdateElement.appendChild(itemElement);
        serverMessage.addLibrary(Resources.EP_SCRIPT_SERVICE.getId());
        serverMessage.addLibrary(KEYSTROKE_SERVICE.getId());
    }

    protected void createInitDirective(RenderingContext rc, KeyStrokeListener keyStrokeListener) {
        Element itemizedUpdateElement = rc.getServerMessage().getItemizedDirective("postupdate", "EPKeyStroke.MessageProcessor", "init", new String[0], new String[0]);
        Element itemElement = rc.getServerMessage().getDocument().createElement("item");
        itemizedUpdateElement.appendChild(itemElement);
        itemElement.setAttribute("eid", rc.getElementId());
        itemElement.setAttribute("enabled", String.valueOf(keyStrokeListener.isRenderEnabled()));
        itemElement.setAttribute("serverNotify", String.valueOf(keyStrokeListener.hasActionListeners()));
        itemElement.setAttribute("cancelMode", String.valueOf(rc.getRP("cancelMode", false)));
        Component target = (Component)rc.getRP("target");
        if (target != null) {
            itemElement.setAttribute("targetid", ContainerInstance.getElementId(target));
        }
        StringBuffer keyCombinations = new StringBuffer();
        int[] keys = keyStrokeListener.getKeyCombinations();
        for (int i = 0; i < keys.length; ++i) {
            int key = keys[i];
            keyCombinations.append(key);
            if (i >= keys.length - 1) continue;
            keyCombinations.append('|');
        }
        itemElement.setAttribute("keyCombinations", keyCombinations.toString());
    }

    static {
        WebRenderServlet.getServiceRegistry().add(KEYSTROKE_SERVICE);
    }
}

