/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.syncpeer;

import echopointng.ComboBox;
import echopointng.able.Widthable;
import echopointng.ui.syncpeer.PopUpPeer;
import echopointng.ui.util.Render;
import echopointng.ui.util.RenderingContext;
import echopointng.util.QuoterKit;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.list.ListCellRenderer;
import nextapp.echo2.app.list.ListModel;
import nextapp.echo2.app.list.StyledListCell;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.propertyrender.ColorRender;
import nextapp.echo2.webcontainer.propertyrender.FontRender;
import nextapp.echo2.webcontainer.propertyrender.InsetsRender;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.output.CssStyle;
import nextapp.echo2.webrender.service.JavaScriptService;
import org.w3c.dom.Element;

public class ComboBoxPeer
extends PopUpPeer {
    protected static final Insets DEFAULT_ITEM_INSETS = new Insets(new Extent(2), new Extent(1));
    public static final Service COMBOBOX_SERVICE = JavaScriptService.forResource("EPNG.ComboBox", "/echopointng/ui/resource/js/combobox.js");

    @Override
    protected Element renderBox(RenderingContext rc, Component component, Style fallbackStyle) {
        ComboBox combo = (ComboBox)component;
        rc.addLibrary(COMBOBOX_SERVICE);
        this.createInitDirective(rc, combo);
        CssStyle cssStyle = this.createListBoxStyle(rc, combo, fallbackStyle);
        Element divBox = rc.createE("div");
        divBox.setAttribute("id", rc.getElementId() + "|Box");
        divBox.setAttribute("style", cssStyle.renderInline());
        return divBox;
    }

    protected void createInitDirective(RenderingContext rc, ComboBox combo) {
        ServerMessage serverMessage = rc.getServerMessage();
        String elementId = rc.getElementId();
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("postupdate", "EPComboBox.MessageProcessor", "init", new String[0], new String[0]);
        Element itemElement = serverMessage.getDocument().createElement("item");
        itemElement.setAttribute("eid", elementId);
        itemElement.setAttribute("defaultItemStyle", ComboBoxPeer.createDefaultListItemStyle().renderInline());
        itemElement.setAttribute("defaultHoverStyle", ComboBoxPeer.createDefaultListItemHoverStyle().renderInline());
        itemElement.setAttribute("textMatching", String.valueOf(combo.isTextMatchingPerformed()));
        itemElement.setAttribute("visibleRows", Integer.toString(combo.getListRowCount()));
        itemElement.setAttribute("actionOnSelection", String.valueOf(combo.isActionOnSelection() && combo.hasActionListeners()));
        itemElement.setAttribute("caseSensitive", String.valueOf(combo.isCaseSensitive()));
        itemizedUpdateElement.appendChild(itemElement);
        Element optionsElement = serverMessage.getDocument().createElement("options");
        ListModel model = combo.getListModel();
        ListCellRenderer renderer = combo.getListCellRenderer();
        for (int i = 0; i < model.size(); ++i) {
            Object value = combo.getListModel().get(i);
            Object renderedValue = renderer.getListCellRendererComponent(combo, value, i);
            String itemValue = QuoterKit.quoteJ(renderedValue.toString(), '\'');
            CssStyle itemStyle = null;
            if (renderedValue instanceof StyledListCell) {
                StyledListCell styledListCell = (StyledListCell)renderedValue;
                itemStyle = ComboBoxPeer.createDefaultListItemStyle();
                ColorRender.renderToStyle(itemStyle, styledListCell.getForeground(), styledListCell.getBackground());
                FontRender.renderToStyle(itemStyle, styledListCell.getFont());
            }
            Element optionElement = serverMessage.getDocument().createElement("option");
            optionElement.setAttribute("value", itemValue);
            optionElement.setAttribute("style", itemStyle == null ? "" : itemStyle.renderInline());
            optionsElement.appendChild(optionElement);
        }
        if (optionsElement.hasChildNodes()) {
            itemElement.appendChild(optionsElement);
        }
    }

    private static CssStyle createDefaultListItemStyle() {
        CssStyle style = new CssStyle();
        InsetsRender.renderToStyle(style, "padding", DEFAULT_ITEM_INSETS);
        style.setAttribute("white-space", "nowrap");
        return style;
    }

    private static CssStyle createDefaultListItemHoverStyle() {
        CssStyle style = ComboBoxPeer.createDefaultListItemStyle();
        style.setAttribute("background-color", "Highlight");
        style.setAttribute("color", "HighlightText");
        return style;
    }

    private CssStyle createListBoxStyle(RenderContext rc, Component component, Style fallbackStyle) {
        CssStyle style = new CssStyle();
        Render.asBorder(style, component, "popUpBorder", fallbackStyle);
        Render.asInsets(style, component, "popUpInsets", "padding", fallbackStyle);
        Render.asInsets(style, component, "popUpOutSets", "margin", fallbackStyle);
        Render.asColors(style, component, "popUpBackground", null, fallbackStyle);
        Render.asFont(style, component, fallbackStyle);
        Render.asWidthable(style, (Widthable)((Object)component));
        style.setAttribute("position", "absolute");
        style.setAttribute("visibility", "hidden");
        style.setAttribute("left", "0px");
        style.setAttribute("top", "0px");
        style.setAttribute("overflow", "auto");
        style.setAttribute("cursor", "default");
        Render.layoutFix(rc, style);
        return style;
    }

    static {
        WebRenderServlet.getServiceRegistry().add(COMBOBOX_SERVICE);
    }
}

