/*
 * Decompiled with CFR 0.152.
 */
package echopointng.treetable;

import echopointng.tree.TreeModelEvent;
import echopointng.tree.TreeModelListener;
import echopointng.tree.TreeNode;
import echopointng.tree.TreePath;
import echopointng.treetable.AbstractTreeTableModel;
import java.util.EventListener;

public class DefaultTreeTableModel
extends AbstractTreeTableModel {
    protected boolean asksAllowsChildren;

    public DefaultTreeTableModel() {
        this(null);
    }

    public DefaultTreeTableModel(TreeNode root) {
        this(root, false);
    }

    public DefaultTreeTableModel(TreeNode root, boolean asksAllowsChildren) {
        super(root);
        this.asksAllowsChildren = asksAllowsChildren;
    }

    public void setRoot(TreeNode root) {
        Object oldRoot = this.root;
        this.root = root;
        if (root == null && oldRoot != null) {
            this.fireTreeStructureChanged(this, null);
        } else {
            this.nodeStructureChanged(root);
        }
    }

    private void fireTreeStructureChanged(Object source, TreePath path) {
        EventListener[] listeners = this.listenerList.getListeners(TreeModelListener.class);
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path);
            }
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
        }
    }

    public boolean asksAllowsChildren() {
        return this.asksAllowsChildren;
    }

    public void setAsksAllowsChildren(boolean newValue) {
        this.asksAllowsChildren = newValue;
    }

    @Override
    public Object getValueAt(Object node, int column) {
        return node + "@column " + column;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node instanceof TreeNode && this.asksAllowsChildren) {
            return !((TreeNode)node).getAllowsChildren();
        }
        return super.isLeaf(node);
    }

    public void nodesWereInserted(TreeNode node, int[] childIndices) {
        if (this.listenerList != null && node != null && childIndices != null && childIndices.length > 0) {
            int cCount = childIndices.length;
            Object[] newChildren = new Object[cCount];
            for (int counter = 0; counter < cCount; ++counter) {
                newChildren[counter] = node.getChildAt(childIndices[counter]);
            }
            this.fireTreeNodesInserted(this, this.getPathToRoot(node), childIndices, newChildren);
        }
    }

    public void nodesWereRemoved(TreeNode node, int[] childIndices, Object[] removedChildren) {
        if (node != null && childIndices != null) {
            this.fireTreeNodesRemoved(this, this.getPathToRoot(node), childIndices, removedChildren);
        }
    }

    public void nodesChanged(TreeNode node, int[] childIndices) {
        if (node != null) {
            if (childIndices != null) {
                int cCount = childIndices.length;
                if (cCount > 0) {
                    Object[] cChildren = new Object[cCount];
                    for (int counter = 0; counter < cCount; ++counter) {
                        cChildren[counter] = node.getChildAt(childIndices[counter]);
                    }
                    this.fireTreeNodesChanged(this, this.getPathToRoot(node), childIndices, cChildren);
                }
            } else if (node == this.getRoot()) {
                this.fireTreeNodesChanged(this, this.getPathToRoot(node), null, null);
            }
        }
    }

    public void nodeStructureChanged(TreeNode node) {
        if (node != null) {
            this.fireTreeStructureChanged(this, this.getPathToRoot(node), null, null);
        }
    }
}

