/*
 * Decompiled with CFR 0.152.
 */
package echopointng.tree;

import echopointng.tree.MutableTreeNode;
import echopointng.tree.TreeModel;
import echopointng.tree.TreeModelEvent;
import echopointng.tree.TreeModelListener;
import echopointng.tree.TreeNode;
import echopointng.tree.TreePath;
import java.io.Serializable;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import nextapp.echo2.app.event.EventListenerList;

public class DefaultTreeModel
implements TreeModel,
Serializable {
    protected TreeNode root;
    protected EventListenerList listenerList = new EventListenerList();
    protected boolean asksAllowsChildren;
    protected HashMap nodeIds = new HashMap();
    private int nextNodeId = 0;

    public DefaultTreeModel(TreeNode root) {
        this(root, false);
    }

    public DefaultTreeModel(TreeNode root, boolean asksAllowsChildren) {
        if (root == null) {
            throw new IllegalArgumentException("root is null");
        }
        this.root = root;
        this.asksAllowsChildren = asksAllowsChildren;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.addListener(TreeModelListener.class, l);
    }

    public boolean asksAllowsChildren() {
        return this.asksAllowsChildren;
    }

    protected void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        EventListener[] listeners = this.listenerList.getListeners(TreeModelListener.class);
        TreeModelEvent e = null;
        for (int index = 0; index < listeners.length; ++index) {
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[index]).treeNodesChanged(e);
        }
    }

    protected void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
        EventListener[] listeners = this.listenerList.getListeners(TreeModelListener.class);
        TreeModelEvent e = null;
        for (int index = 0; index < listeners.length; ++index) {
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[index]).treeNodesInserted(e);
        }
    }

    protected void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
        EventListener[] listeners = this.listenerList.getListeners(TreeModelListener.class);
        TreeModelEvent e = null;
        for (int index = 0; index < listeners.length; ++index) {
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[index]).treeNodesRemoved(e);
        }
    }

    protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        EventListener[] listeners = this.listenerList.getListeners(TreeModelListener.class);
        TreeModelEvent e = null;
        for (int index = 0; index < listeners.length; ++index) {
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[index]).treeStructureChanged(e);
        }
    }

    @Override
    public Object getChild(Object parent, int index) {
        return ((TreeNode)parent).getChildAt(index);
    }

    @Override
    public int getChildCount(Object parent) {
        return ((TreeNode)parent).getChildCount();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == null || child == null) {
            return 0;
        }
        return ((TreeNode)parent).getIndex((TreeNode)child);
    }

    public Object getParent(Object child) {
        return null;
    }

    protected TreeNode[] getPathToRoot(TreeNode aNode, int depth) {
        TreeNode[] retNodes;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new TreeNode[depth];
        } else {
            retNodes = aNode == this.root ? new TreeNode[depth] : this.getPathToRoot(aNode.getParent(), ++depth);
            retNodes[retNodes.length - depth] = aNode;
        }
        return retNodes;
    }

    public Object[] getPathToRoot(Object node) {
        return this.getPathToRoot((TreeNode)node, 0);
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    public void insertNodeInto(MutableTreeNode newChild, MutableTreeNode parent, int index) {
        if (newChild.getParent() != null) {
            this.removeNodeFromParent(newChild);
        }
        parent.insert(newChild, index);
        int[] newIndexs = new int[]{index};
        this.nodesWereInserted(parent, newIndexs);
    }

    @Override
    public boolean isLeaf(Object node) {
        if (this.asksAllowsChildren) {
            return !((TreeNode)node).getAllowsChildren();
        }
        return ((TreeNode)node).isLeaf();
    }

    public void nodeChanged(TreeNode node) {
        if (this.listenerList != null && node != null) {
            TreeNode parent = node.getParent();
            if (parent != null) {
                int anIndex = parent.getIndex(node);
                if (anIndex != -1) {
                    int[] cIndexs = new int[]{anIndex};
                    this.nodesChanged(parent, cIndexs);
                }
            } else if (node == this.getRoot()) {
                this.nodesChanged(node, null);
            }
        }
    }

    public void nodesChanged(TreeNode node, int[] childIndices) {
        if (node != null) {
            if (childIndices != null) {
                int cCount = childIndices.length;
                if (cCount > 0) {
                    Object[] cChildren = new Object[cCount];
                    for (int counter = 0; counter < cCount; ++counter) {
                        cChildren[counter] = node.getChildAt(childIndices[counter]);
                    }
                    this.fireTreeNodesChanged(this, this.getPathToRoot(node), childIndices, cChildren);
                }
            } else if (node == this.getRoot()) {
                this.fireTreeNodesChanged(this, this.getPathToRoot(node), null, null);
            }
        }
    }

    public void nodeStructureChanged(TreeNode node) {
        if (node != null) {
            this.fireTreeStructureChanged(this, this.getPathToRoot(node), null, null);
        }
    }

    public void nodesWereInserted(TreeNode node, int[] childIndices) {
        if (this.listenerList != null && node != null && childIndices != null && childIndices.length > 0) {
            int cCount = childIndices.length;
            Object[] newChildren = new Object[cCount];
            for (int counter = 0; counter < cCount; ++counter) {
                newChildren[counter] = node.getChildAt(childIndices[counter]);
            }
            this.fireTreeNodesInserted(this, this.getPathToRoot(node), childIndices, newChildren);
        }
    }

    public void nodesWereRemoved(TreeNode node, int[] childIndices, Object[] removedChildren) {
        if (node != null && childIndices != null) {
            this.fireTreeNodesRemoved(this, this.getPathToRoot(node), childIndices, removedChildren);
        }
    }

    public void reload() {
        this.reload(this.root);
    }

    public void reload(TreeNode node) {
        this.nodeStructureChanged(node);
    }

    public void removeNodeFromParent(MutableTreeNode node) {
        MutableTreeNode parent = (MutableTreeNode)node.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("node does not have a parent.");
        }
        int[] childIndex = new int[1];
        Object[] removedArray = new Object[1];
        childIndex[0] = parent.getIndex(node);
        parent.remove(childIndex[0]);
        removedArray[0] = node;
        this.nodesWereRemoved(parent, childIndex, removedArray);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.removeListener(TreeModelListener.class, l);
    }

    public void setAsksAllowsChildren(boolean newValue) {
        this.asksAllowsChildren = newValue;
    }

    public void setRoot(TreeNode root) {
        if (root == null) {
            throw new IllegalArgumentException("Root of tree is not allowed to be null");
        }
        this.root = root;
        this.nodeStructureChanged(root);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        MutableTreeNode aNode = (MutableTreeNode)path.getLastPathComponent();
        aNode.setUserObject(newValue);
        this.nodeChanged(aNode);
    }

    @Override
    public String getNodeId(Object node) {
        Integer nodeId = (Integer)this.nodeIds.get(node);
        if (nodeId == null) {
            nodeId = new Integer(this.nextNodeId++);
            this.nodeIds.put(node, nodeId);
        }
        return String.valueOf(nodeId);
    }

    @Override
    public Object getNodeById(String id) {
        for (Map.Entry entry : this.nodeIds.entrySet()) {
            if (!String.valueOf(entry.getValue()).equals(id)) continue;
            return entry.getKey();
        }
        return null;
    }
}

