/*
 * Decompiled with CFR 0.152.
 */
package echopointng.tree;

import echopointng.Tree;
import echopointng.tree.DefaultMutableTreeNode;
import echopointng.tree.TreeCellRenderer;
import echopointng.tree.TreeIcons;
import echopointng.tree.TreeModel;
import echopointng.xhtml.XhtmlFragment;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.Label;

public class DefaultTreeCellRenderer
extends Label
implements TreeCellRenderer {
    public static final Font DEFAULT_FONT = new Font(Font.ARIAL, 0, new Extent(8, 4));
    public static final Color DEFAULT_SELECTED_BACKGROUND = Color.BLACK;
    public static final Color DEFAULT_SELECTED_FOREGROUND = Color.WHITE;
    public static final Font DEFAULT_SELECTED_FONT = new Font(Font.ARIAL, 1, new Extent(8, 4));
    public static final String PROPERTY_SELECTED_BACKGROUND = "selectedBackground";
    public static final String PROPERTY_SELECTED_FOREGROUND = "selectedForeground";
    public static final String PROPERTY_SELECTED_FONT = "selectedFont";
    private Color saveBackground = super.getBackground();
    private Color saveForeground = super.getForeground();
    private Font saveFont = super.getFont();

    public DefaultTreeCellRenderer() {
        this.setSelectedBackground(DEFAULT_SELECTED_BACKGROUND);
        this.setSelectedForeground(DEFAULT_SELECTED_FOREGROUND);
        this.setSelectedFont(DEFAULT_FONT);
        this.setBackground(null);
        this.setFont(DEFAULT_FONT);
    }

    public Color getSelectedBackground() {
        return (Color)this.getProperty(PROPERTY_SELECTED_BACKGROUND);
    }

    public Color getSelectedForeground() {
        return (Color)this.getProperty(PROPERTY_SELECTED_FOREGROUND);
    }

    public Font getSelectedFont() {
        return (Font)this.getProperty(PROPERTY_SELECTED_FONT);
    }

    public void setSelectedBackground(Color newValue) {
        this.setProperty(PROPERTY_SELECTED_BACKGROUND, newValue);
    }

    public void setSelectedForeground(Color newValue) {
        this.setProperty(PROPERTY_SELECTED_FOREGROUND, newValue);
    }

    public void setSelectedFont(Font newValue) {
        this.setProperty(PROPERTY_SELECTED_FONT, newValue);
    }

    @Override
    public void setBackground(Color newValue) {
        this.saveBackground = newValue;
        super.setBackground(newValue);
    }

    @Override
    public void setForeground(Color newValue) {
        this.saveForeground = newValue;
        super.setForeground(newValue);
    }

    @Override
    public void setFont(Font newValue) {
        this.saveFont = newValue;
        super.setFont(newValue);
    }

    @Override
    public Component getTreeCellRendererComponent(Tree tree, Object node, boolean selected, boolean expanded, boolean leaf) {
        Object value;
        if (node instanceof DefaultMutableTreeNode && (value = ((DefaultMutableTreeNode)node).getUserObject()) instanceof Component) {
            Component c = (Component)value;
            c.setEnabled(tree.isRenderEnabled());
            return c;
        }
        return null;
    }

    @Override
    public XhtmlFragment getTreeCellRendererXhtml(Tree tree, Object node, boolean selected, boolean expanded, boolean leaf) {
        Object value;
        if (node instanceof XhtmlFragment) {
            return (XhtmlFragment)node;
        }
        if (node instanceof DefaultMutableTreeNode && (value = ((DefaultMutableTreeNode)node).getUserObject()) instanceof XhtmlFragment) {
            return (XhtmlFragment)value;
        }
        return null;
    }

    @Override
    public Label getTreeCellRendererText(Tree tree, Object node, boolean sel, boolean expanded, boolean leaf) {
        String stringValue = "";
        if (node instanceof DefaultMutableTreeNode) {
            Object value = ((DefaultMutableTreeNode)node).getUserObject();
            if (value instanceof Component || value instanceof XhtmlFragment || value == null) {
                return null;
            }
            stringValue = value.toString();
        } else if (node != null) {
            stringValue = node.toString();
        }
        this.setText(stringValue);
        if (sel) {
            super.setForeground(this.getSelectedForeground());
            super.setBackground(this.getSelectedBackground());
            if (this.getSelectedFont() == null) {
                super.setFont(tree.getFont());
            } else {
                super.setFont(this.getSelectedFont());
            }
        } else {
            super.setForeground(this.saveForeground);
            super.setBackground(this.saveBackground);
            if (this.saveFont == null) {
                super.setFont(tree.getFont());
            } else {
                super.setFont(this.saveFont);
            }
        }
        boolean isRoot = false;
        TreeModel model = tree.getModel();
        if (model != null) {
            isRoot = node == model.getRoot();
        }
        this.setIcon(null);
        TreeIcons icons = tree.getTreeIcons();
        if (icons != null) {
            if (isRoot && expanded) {
                this.setIcon(icons.getIcon("rootopen"));
            } else if (isRoot) {
                this.setIcon(icons.getIcon("root"));
            } else if (leaf) {
                this.setIcon(icons.getIcon("leaf"));
            } else if (expanded) {
                this.setIcon(icons.getIcon("folderopen"));
            } else {
                this.setIcon(icons.getIcon("folder"));
            }
        }
        return this;
    }
}

