/*
 * Decompiled with CFR 0.152.
 */
package echopointng.tree;

import echopointng.tree.MutableTreeNode;
import echopointng.tree.TreeNode;
import java.io.Serializable;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.Vector;

public class DefaultMutableTreeNode
implements MutableTreeNode,
Serializable {
    protected String actionCommand;
    protected MutableTreeNode parent;
    protected Vector children;
    protected transient Object userObject;
    protected boolean allowsChildren;
    public static final Enumeration EMPTY_ENUMERATION = new Enumeration(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException("No more elements");
        }
    };

    public DefaultMutableTreeNode() {
    }

    public DefaultMutableTreeNode(Object userObject) {
        this(userObject, true);
    }

    public DefaultMutableTreeNode(Object userObject, boolean allowsChildren) {
        this.parent = null;
        this.allowsChildren = allowsChildren;
        this.userObject = userObject;
    }

    public void add(MutableTreeNode newChild) {
        if (newChild != null && newChild.getParent() == this) {
            this.insert(newChild, this.getChildCount() - 1);
        } else {
            this.insert(newChild, this.getChildCount());
        }
    }

    public Enumeration breadthFirstEnumeration() {
        return new BreadthFirstEnumeration(this);
    }

    @Override
    public Enumeration children() {
        if (this.children == null) {
            return EMPTY_ENUMERATION;
        }
        return this.children.elements();
    }

    public Enumeration depthFirstEnumeration() {
        return this.postorderEnumeration();
    }

    @Override
    public String getActionCommand() {
        return this.actionCommand;
    }

    @Override
    public boolean getAllowsChildren() {
        return this.allowsChildren;
    }

    public TreeNode getChildAfter(TreeNode aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int index = this.getIndex(aChild);
        if (index == -1) {
            throw new IllegalArgumentException("node is not a child");
        }
        if (index < this.getChildCount() - 1) {
            return this.getChildAt(index + 1);
        }
        return null;
    }

    @Override
    public TreeNode getChildAt(int index) {
        if (this.children == null) {
            throw new ArrayIndexOutOfBoundsException("node has no children");
        }
        return (TreeNode)this.children.elementAt(index);
    }

    public TreeNode getChildBefore(TreeNode aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int index = this.getIndex(aChild);
        if (index == -1) {
            throw new IllegalArgumentException("argument is not a child");
        }
        if (index > 0) {
            return this.getChildAt(index - 1);
        }
        return null;
    }

    @Override
    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public int getDepth() {
        Object last = null;
        Enumeration enumeration = this.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            last = enumeration.nextElement();
        }
        if (last == null) {
            throw new InternalError("nodes should be null");
        }
        return ((DefaultMutableTreeNode)last).getLevel() - this.getLevel();
    }

    public TreeNode getFirstChild() {
        if (this.getChildCount() == 0) {
            throw new NoSuchElementException("node has no children");
        }
        return this.getChildAt(0);
    }

    public DefaultMutableTreeNode getFirstLeaf() {
        DefaultMutableTreeNode node = this;
        while (!node.isLeaf()) {
            node = (DefaultMutableTreeNode)node.getFirstChild();
        }
        return node;
    }

    @Override
    public int getIndex(TreeNode aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (!this.isNodeChild(aChild)) {
            return -1;
        }
        return this.children.indexOf(aChild);
    }

    public TreeNode getLastChild() {
        if (this.getChildCount() == 0) {
            throw new NoSuchElementException("node has no children");
        }
        return this.getChildAt(this.getChildCount() - 1);
    }

    public DefaultMutableTreeNode getLastLeaf() {
        DefaultMutableTreeNode node = this;
        while (!node.isLeaf()) {
            node = (DefaultMutableTreeNode)node.getLastChild();
        }
        return node;
    }

    public int getLeafCount() {
        int count = 0;
        Enumeration enumeration = this.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            TreeNode node = (TreeNode)enumeration.nextElement();
            if (!node.isLeaf()) continue;
            ++count;
        }
        if (count < 1) {
            throw new InternalError("tree has zero leaves");
        }
        return count;
    }

    public int getLevel() {
        int levels = 0;
        TreeNode ancestor = this;
        while ((ancestor = ancestor.getParent()) != null) {
            ++levels;
        }
        return levels;
    }

    public DefaultMutableTreeNode getNextLeaf() {
        DefaultMutableTreeNode myParent = (DefaultMutableTreeNode)this.getParent();
        if (myParent == null) {
            return null;
        }
        DefaultMutableTreeNode nextSibling = this.getNextSibling();
        if (nextSibling != null) {
            return nextSibling.getFirstLeaf();
        }
        return myParent.getNextLeaf();
    }

    public DefaultMutableTreeNode getNextNode() {
        if (this.getChildCount() == 0) {
            DefaultMutableTreeNode nextSibling = this.getNextSibling();
            if (nextSibling == null) {
                DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)this.getParent();
                while (true) {
                    if (aNode == null) {
                        return null;
                    }
                    nextSibling = aNode.getNextSibling();
                    if (nextSibling != null) {
                        return nextSibling;
                    }
                    aNode = (DefaultMutableTreeNode)aNode.getParent();
                }
            }
            return nextSibling;
        }
        return (DefaultMutableTreeNode)this.getChildAt(0);
    }

    public DefaultMutableTreeNode getNextSibling() {
        DefaultMutableTreeNode myParent = (DefaultMutableTreeNode)this.getParent();
        DefaultMutableTreeNode retval = myParent == null ? null : (DefaultMutableTreeNode)myParent.getChildAfter(this);
        if (retval != null && !this.isNodeSibling(retval)) {
            throw new InternalError("child of parent is not a sibling");
        }
        return retval;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    public TreeNode[] getPath() {
        return this.getPathToRoot(this, 0);
    }

    protected TreeNode[] getPathToRoot(TreeNode aNode, int depth) {
        TreeNode[] retNodes;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new TreeNode[depth];
        } else {
            retNodes = this.getPathToRoot(aNode.getParent(), ++depth);
            retNodes[retNodes.length - depth] = aNode;
        }
        return retNodes;
    }

    public DefaultMutableTreeNode getPreviousLeaf() {
        DefaultMutableTreeNode myParent = (DefaultMutableTreeNode)this.getParent();
        if (myParent == null) {
            return null;
        }
        DefaultMutableTreeNode previousSibling = this.getPreviousSibling();
        if (previousSibling != null) {
            return previousSibling.getLastLeaf();
        }
        return myParent.getPreviousLeaf();
    }

    public DefaultMutableTreeNode getPreviousNode() {
        DefaultMutableTreeNode myParent = (DefaultMutableTreeNode)this.getParent();
        if (myParent == null) {
            return null;
        }
        DefaultMutableTreeNode previousSibling = this.getPreviousSibling();
        if (previousSibling != null) {
            if (previousSibling.getChildCount() == 0) {
                return previousSibling;
            }
            return previousSibling.getLastLeaf();
        }
        return myParent;
    }

    public DefaultMutableTreeNode getPreviousSibling() {
        DefaultMutableTreeNode myParent = (DefaultMutableTreeNode)this.getParent();
        DefaultMutableTreeNode retval = myParent == null ? null : (DefaultMutableTreeNode)myParent.getChildBefore(this);
        if (retval != null && !this.isNodeSibling(retval)) {
            throw new InternalError("child of parent is not a sibling");
        }
        return retval;
    }

    public TreeNode getRoot() {
        DefaultMutableTreeNode previous;
        TreeNode ancestor = this;
        do {
            previous = ancestor;
        } while ((ancestor = ancestor.getParent()) != null);
        return previous;
    }

    public TreeNode getSharedAncestor(DefaultMutableTreeNode aNode) {
        TreeNode node2;
        TreeNode node1;
        int diff;
        if (aNode == this) {
            return this;
        }
        if (aNode == null) {
            return null;
        }
        int level1 = this.getLevel();
        int level2 = aNode.getLevel();
        if (level2 > level1) {
            diff = level2 - level1;
            node1 = aNode;
            node2 = this;
        } else {
            diff = level1 - level2;
            node1 = this;
            node2 = aNode;
        }
        while (diff > 0) {
            node1 = node1.getParent();
            --diff;
        }
        do {
            if (node1 == node2) {
                return node1;
            }
            node1 = node1.getParent();
            node2 = node2.getParent();
        } while (node1 != null);
        if (node1 != null || node2 != null) {
            throw new InternalError("nodes should be null");
        }
        return null;
    }

    public int getSiblingCount() {
        TreeNode myParent = this.getParent();
        if (myParent == null) {
            return 1;
        }
        return myParent.getChildCount();
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public Object[] getUserObjectPath() {
        TreeNode[] realPath = this.getPath();
        Object[] retPath = new Object[realPath.length];
        for (int counter = 0; counter < realPath.length; ++counter) {
            retPath[counter] = ((DefaultMutableTreeNode)realPath[counter]).getUserObject();
        }
        return retPath;
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        if (!this.getAllowsChildren()) {
            throw new IllegalStateException("node does not allow children");
        }
        if (newChild == null) {
            throw new IllegalArgumentException("new child is null");
        }
        if (this.isNodeAncestor(newChild)) {
            throw new IllegalArgumentException("new child is an ancestor");
        }
        MutableTreeNode oldParent = (MutableTreeNode)newChild.getParent();
        if (oldParent != null) {
            oldParent.remove(newChild);
        }
        newChild.setParent(this);
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.insertElementAt(newChild, childIndex);
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public boolean isNodeAncestor(TreeNode anotherNode) {
        if (anotherNode == null) {
            return false;
        }
        TreeNode ancestor = this;
        do {
            if (ancestor != anotherNode) continue;
            return true;
        } while ((ancestor = ancestor.getParent()) != null);
        return false;
    }

    public boolean isNodeChild(TreeNode aNode) {
        boolean retval = aNode == null ? false : (this.getChildCount() == 0 ? false : aNode.getParent() == this);
        return retval;
    }

    public boolean isNodeDescendant(DefaultMutableTreeNode anotherNode) {
        if (anotherNode == null) {
            return false;
        }
        return anotherNode.isNodeAncestor(this);
    }

    public boolean isNodeRelated(DefaultMutableTreeNode aNode) {
        return aNode != null && this.getRoot() == aNode.getRoot();
    }

    public boolean isNodeSibling(TreeNode anotherNode) {
        boolean retval;
        if (anotherNode == null) {
            retval = false;
        } else if (anotherNode == this) {
            retval = true;
        } else {
            TreeNode myParent = this.getParent();
            boolean bl = retval = myParent != null && myParent == anotherNode.getParent();
            if (retval && !((DefaultMutableTreeNode)this.getParent()).isNodeChild(anotherNode)) {
                throw new InternalError("sibling has different parent");
            }
        }
        return retval;
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public Enumeration pathFromAncestorEnumeration(TreeNode ancestor) {
        return new PathBetweenNodesEnumeration(ancestor, this);
    }

    public Enumeration postorderEnumeration() {
        return new PostorderEnumeration(this);
    }

    public Enumeration preorderEnumeration() {
        return new PreorderEnumeration(this);
    }

    @Override
    public void remove(int childIndex) {
        MutableTreeNode child = (MutableTreeNode)this.getChildAt(childIndex);
        this.children.removeElementAt(childIndex);
        child.setParent(null);
    }

    @Override
    public void remove(MutableTreeNode aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (!this.isNodeChild(aChild)) {
            throw new IllegalArgumentException("argument is not a child");
        }
        this.remove(this.getIndex(aChild));
    }

    public void removeAllChildren() {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            this.remove(i);
        }
    }

    @Override
    public void removeFromParent() {
        MutableTreeNode parent = (MutableTreeNode)this.getParent();
        if (parent != null) {
            parent.remove(this);
        }
    }

    public void setActionCommand(String newActionCommand) {
        this.actionCommand = newActionCommand;
    }

    public void setAllowsChildren(boolean allows) {
        if (allows != this.allowsChildren) {
            this.allowsChildren = allows;
            if (!this.allowsChildren) {
                this.removeAllChildren();
            }
        }
    }

    @Override
    public void setParent(MutableTreeNode newParent) {
        this.parent = newParent;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public String toString() {
        if (this.userObject == null) {
            return null;
        }
        return this.userObject.toString();
    }

    public final class PathBetweenNodesEnumeration
    implements Enumeration,
    Serializable {
        protected Stack stack;

        public PathBetweenNodesEnumeration(TreeNode ancestor, TreeNode descendant) {
            if (ancestor == null || descendant == null) {
                throw new IllegalArgumentException("argument is null");
            }
            this.stack = new Stack();
            this.stack.push(descendant);
            TreeNode current = descendant;
            while (current != ancestor) {
                if ((current = current.getParent()) == null && descendant != ancestor) {
                    throw new IllegalArgumentException("node " + ancestor + " is not an ancestor of " + descendant);
                }
                this.stack.push(current);
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.stack.size() > 0;
        }

        public Object nextElement() {
            try {
                return this.stack.pop();
            }
            catch (EmptyStackException e) {
                throw new NoSuchElementException("No more elements");
            }
        }
    }

    public final class BreadthFirstEnumeration
    implements Enumeration,
    Serializable {
        protected Queue queue;

        public BreadthFirstEnumeration(TreeNode rootNode) {
            Vector<TreeNode> v = new Vector<TreeNode>(1);
            v.addElement(rootNode);
            this.queue = new Queue();
            this.queue.enqueue(v.elements());
        }

        @Override
        public boolean hasMoreElements() {
            return !this.queue.isEmpty() && ((Enumeration)this.queue.firstObject()).hasMoreElements();
        }

        public Object nextElement() {
            Enumeration enumer = (Enumeration)this.queue.firstObject();
            TreeNode node = (TreeNode)enumer.nextElement();
            Enumeration children = node.children();
            if (!enumer.hasMoreElements()) {
                this.queue.dequeue();
            }
            if (children.hasMoreElements()) {
                this.queue.enqueue(children);
            }
            return node;
        }

        final class Queue {
            QNode head;
            QNode tail;

            Queue() {
            }

            public void enqueue(Object anObject) {
                if (this.head == null) {
                    this.head = this.tail = new QNode(anObject, null);
                } else {
                    this.tail = this.tail.next = new QNode(anObject, null);
                }
            }

            public Object dequeue() {
                if (this.head == null) {
                    throw new NoSuchElementException("No more elements");
                }
                Object retval = this.head.object;
                QNode oldHead = this.head;
                this.head = this.head.next;
                if (this.head == null) {
                    this.tail = null;
                } else {
                    oldHead.next = null;
                }
                return retval;
            }

            public Object firstObject() {
                if (this.head == null) {
                    throw new NoSuchElementException("No more elements");
                }
                return this.head.object;
            }

            public boolean isEmpty() {
                return this.head == null;
            }

            final class QNode {
                public Object object;
                public QNode next;

                public QNode(Object object, QNode next) {
                    this.object = object;
                    this.next = next;
                }
            }
        }
    }

    public final class PostorderEnumeration
    implements Enumeration,
    Serializable {
        protected TreeNode root;
        protected Enumeration children;
        protected Enumeration subtree;

        public PostorderEnumeration(TreeNode rootNode) {
            this.root = rootNode;
            this.children = this.root.children();
            this.subtree = EMPTY_ENUMERATION;
        }

        @Override
        public boolean hasMoreElements() {
            return this.root != null;
        }

        public Object nextElement() {
            Object retval;
            if (this.subtree.hasMoreElements()) {
                retval = this.subtree.nextElement();
            } else if (this.children.hasMoreElements()) {
                this.subtree = new PostorderEnumeration((TreeNode)this.children.nextElement());
                retval = this.subtree.nextElement();
            } else {
                retval = this.root;
                this.root = null;
            }
            return retval;
        }
    }

    public final class PreorderEnumeration
    implements Enumeration,
    Serializable {
        protected Stack stack;

        public PreorderEnumeration(TreeNode rootNode) {
            Vector<TreeNode> v = new Vector<TreeNode>(1);
            v.addElement(rootNode);
            this.stack = new Stack();
            this.stack.push(v.elements());
        }

        @Override
        public boolean hasMoreElements() {
            return !this.stack.empty() && ((Enumeration)this.stack.peek()).hasMoreElements();
        }

        public Object nextElement() {
            Enumeration enumer = (Enumeration)this.stack.peek();
            TreeNode node = (TreeNode)enumer.nextElement();
            Enumeration children = node.children();
            if (!enumer.hasMoreElements()) {
                this.stack.pop();
            }
            if (children.hasMoreElements()) {
                this.stack.push(children);
            }
            return node;
        }
    }
}

