/*
 * Decompiled with CFR 0.152.
 */
package echopointng.table;

import echopointng.EPNG;
import echopointng.LiveTable;
import echopointng.table.LiveTableRenderer;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import nextapp.echo2.app.Style;
import nextapp.echo2.webrender.Connection;
import nextapp.echo2.webrender.ContentType;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.ServiceRegistry;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.output.XmlDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LiveTableService
implements Service {
    public static final LiveTableService INSTANCE = new LiveTableService();
    private Map interestedParties = new HashMap();

    @Override
    public String getId() {
        return "EPNG.LiveTable";
    }

    @Override
    public int getVersion() {
        return -1;
    }

    public synchronized void register(LiveTable liveTable) {
        this.interestedParties.put("c_" + liveTable.getRenderId(), liveTable);
    }

    public synchronized void deregister(LiveTable liveTable) {
        this.interestedParties.remove(liveTable);
    }

    @Override
    public void service(Connection conn) throws IOException {
        HttpServletRequest request = conn.getRequest();
        String elementId = request.getParameter("elementId");
        LiveTable liveTable = (LiveTable)this.interestedParties.get(elementId);
        if (liveTable == null) {
            throw new IllegalStateException("The LiveTable " + elementId + " could not be found.");
        }
        LiveTableRenderer liveTableRenderer = (LiveTableRenderer)LiveTableService.getRP(liveTable, "renderer");
        XmlDocument xmlDocument = new XmlDocument("data", null, null, "http://www.w3.org/1999/xhtml");
        Document document = xmlDocument.getDocument();
        Element dataElement = document.getDocumentElement();
        int currentPage = Integer.parseInt(request.getParameter("currentPage"));
        int rowsPerPage = LiveTableService.getRP(liveTable, "rowsPerPage", 100);
        int pageFetchSize = LiveTableService.getRP(liveTable, "pageFetchSize", 2);
        for (int i = 0; i < pageFetchSize; ++i) {
            int rowStart = (currentPage + i) * rowsPerPage;
            int rowEnd = rowStart + rowsPerPage;
            Element tbody = document.createElement("tbody");
            dataElement.appendChild(tbody);
            liveTableRenderer.renderRows(liveTable, tbody, rowStart, rowEnd);
        }
        conn.setContentType(ContentType.TEXT_XML);
        PrintWriter out = conn.getWriter();
        xmlDocument.render(out);
    }

    private static Object getRP(LiveTable liveTable, String propertyName) {
        Style style;
        Object value = liveTable.getRenderProperty(propertyName);
        if (value == null && (style = EPNG.getFallBackStyle(liveTable)) != null) {
            value = style.getProperty(propertyName);
        }
        return value;
    }

    private static int getRP(LiveTable liveTable, String propertyName, int fallbackValue) {
        Style style;
        Object value = liveTable.getRenderProperty(propertyName);
        if (value == null && (style = EPNG.getFallBackStyle(liveTable)) != null && (value = style.getProperty(propertyName)) == null) {
            return fallbackValue;
        }
        return (Integer)value;
    }

    static {
        ServiceRegistry serviceRegistry = WebRenderServlet.getServiceRegistry();
        serviceRegistry.add(INSTANCE);
    }
}

