/*
 * Decompiled with CFR 0.152.
 */
package echopointng.table;

import echopointng.table.DefaultSortableTableModel;
import echopointng.table.PageableTableModel;
import nextapp.echo2.app.table.TableColumnModel;
import nextapp.echo2.app.table.TableModel;

public class DefaultPageableSortableTableModel
extends DefaultSortableTableModel
implements PageableTableModel {
    public static final int DEFAULT_ROWS_PER_PAGE = 50;
    public static final int DEFAULT_INITAL_PAGE_INDEX = 0;
    private int currentPage = 0;
    private int rowsPerPage = 50;

    public DefaultPageableSortableTableModel(TableColumnModel columnModel) {
        super(columnModel);
    }

    public DefaultPageableSortableTableModel(TableModel underlyingTableModel, TableColumnModel columnModel) {
        super(underlyingTableModel, columnModel);
    }

    public DefaultPageableSortableTableModel(TableModel underlyingTableModel) {
        super(underlyingTableModel);
    }

    @Override
    public int toUnpagedModelRowIndex(int viewRowIndex) {
        int normalizedRow = this.currentPage * this.rowsPerPage + viewRowIndex;
        return normalizedRow;
    }

    @Override
    public int toPagedViewRowIndex(int modelRowIndex) {
        int normalizedRow = modelRowIndex - this.currentPage * this.rowsPerPage;
        return normalizedRow;
    }

    @Override
    public Object getValueAt(int column, int row) {
        int normalizedRow = this.toUnpagedModelRowIndex(row);
        return super.getValueAt(column, normalizedRow);
    }

    @Override
    public int getRowCount() {
        int underlyingRowCount = this.underlyingTableModel == null ? 0 : this.underlyingTableModel.getRowCount();
        int viewableCount = underlyingRowCount - this.currentPage * this.rowsPerPage;
        if (this.rowsPerPage > viewableCount) {
            return viewableCount;
        }
        return this.rowsPerPage;
    }

    @Override
    public void setCurrentPage(int page) {
        int totalPages = this.getTotalPages();
        if (page < 0 || page >= totalPages) {
            throw new IllegalArgumentException("page must be > 0 and < getTotalPages() : " + page + " totalPages : " + totalPages);
        }
        this.currentPage = page;
        this.fireTableDataChanged();
    }

    @Override
    public int getCurrentPage() {
        return this.currentPage;
    }

    @Override
    public void setRowsPerPage(int rows) {
        if (rows <= 0) {
            throw new IllegalArgumentException("rows must be greater than 0");
        }
        this.rowsPerPage = rows;
        int totalPages = this.getTotalPages();
        if (this.currentPage > totalPages) {
            int newPage = totalPages - 1;
            this.setCurrentPage(newPage < 0 ? 0 : newPage);
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getRowsPerPage() {
        return this.rowsPerPage;
    }

    @Override
    public int getTotalRows() {
        return this.underlyingTableModel == null ? 0 : this.underlyingTableModel.getRowCount();
    }

    @Override
    public int getTotalPages() {
        int totalRows = this.getTotalRows();
        int rowsPerPage = this.getRowsPerPage();
        if (rowsPerPage <= 0) {
            return 1;
        }
        int totalPages = totalRows / rowsPerPage;
        if (totalRows % rowsPerPage != 0 || totalRows == 0) {
            ++totalPages;
        }
        return totalPages;
    }
}

