/*
 * Decompiled with CFR 0.152.
 */
package echopointng.stylesheet.propertypeer;

import echopointng.stylesheet.CssObjectDeclarationParser;
import echopointng.stylesheet.CssObjectIntrospector;
import echopointng.stylesheet.propertypeer.AbstractCssPropertyPeer;
import echopointng.util.FontKit;
import nextapp.echo2.app.Font;

public class TypefacePeer
extends AbstractCssPropertyPeer {
    @Override
    protected Class getConversionClass() {
        return Font.Typeface.class;
    }

    @Override
    protected boolean canConvert(CssObjectIntrospector ci, String propertyValue) {
        if (TypefacePeer.isNullString(propertyValue)) {
            return true;
        }
        if (CssObjectDeclarationParser.isCssObjectDeclaration(propertyValue)) {
            String[] tokens = CssObjectDeclarationParser.parse(propertyValue);
            if (tokens.length == 2) {
                return tokens[0].equals("typeface");
            }
            return false;
        }
        return true;
    }

    @Override
    protected Object getObject(CssObjectIntrospector ci, String propertyValue) {
        if (TypefacePeer.isNullString(propertyValue)) {
            return null;
        }
        if (CssObjectDeclarationParser.isCssObjectDeclaration(propertyValue)) {
            String[] tokens = CssObjectDeclarationParser.parse(propertyValue);
            Font.Typeface typeface = FontKit.getSystemTypeface(tokens[1]);
            if (typeface == null) {
                typeface = FontKit.makeTypeface(tokens[1]);
            }
            return typeface;
        }
        Font.Typeface typeface = FontKit.getSystemTypeface(propertyValue.trim());
        if (typeface == null) {
            typeface = FontKit.makeTypeface(propertyValue.trim());
        }
        return typeface;
    }

    @Override
    protected String getString(CssObjectIntrospector ci, Object object) {
        Font.Typeface typeFace = (Font.Typeface)object;
        StringBuffer sb = new StringBuffer();
        sb.append("typeface(");
        int i = 0;
        while (typeFace != null) {
            if (i > 0) {
                sb.append(", ");
            } else {
                sb.append("'");
            }
            sb.append(typeFace.getName());
            ++i;
            if ((typeFace = typeFace.getAlternate()) != null) continue;
            sb.append("'");
        }
        sb.append(")");
        return sb.toString();
    }
}

