/*
 * Decompiled with CFR 0.152.
 */
package echopointng.stylesheet.propertypeer;

import echopointng.stylesheet.CssObjectDeclarationParser;
import echopointng.stylesheet.CssObjectIntrospector;
import echopointng.stylesheet.propertypeer.AbstractCssPropertyPeer;
import echopointng.util.ColorKit;
import echopointng.util.ExtentKit;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import nextapp.echo2.app.Border;

public class BorderPeer
extends AbstractCssPropertyPeer {
    private static final Map STYLE_CONSTANTS;
    private static final Map STYLE_CONSTANT_ALTERNATES;

    @Override
    protected Class getConversionClass() {
        return Border.class;
    }

    @Override
    protected boolean canConvert(CssObjectIntrospector ci, String propertyValue) {
        if (BorderPeer.isNullString(propertyValue)) {
            return true;
        }
        String[] tokens = CssObjectDeclarationParser.parse(propertyValue);
        if (tokens.length == 4 && tokens[0].equalsIgnoreCase("border")) {
            String size = tokens[1].trim();
            String color = tokens[2].trim();
            String style = tokens[3].trim().toUpperCase();
            return ExtentKit.isExtent(size) && ColorKit.isColor(color) && (STYLE_CONSTANTS.containsKey(style) || STYLE_CONSTANT_ALTERNATES.containsKey(style));
        }
        return false;
    }

    @Override
    protected Object getObject(CssObjectIntrospector ci, String propertyValue) {
        if (BorderPeer.isNullString(propertyValue)) {
            return null;
        }
        String[] tokens = CssObjectDeclarationParser.parse(propertyValue);
        String size = tokens[1].trim();
        String color = tokens[2].trim();
        String style = tokens[3].trim().toUpperCase();
        int styleInt = 0;
        if (STYLE_CONSTANTS.containsKey(style)) {
            styleInt = (Integer)STYLE_CONSTANTS.get(style);
        }
        return new Border(ExtentKit.makeExtent(size), ColorKit.makeColor(color), styleInt);
    }

    @Override
    protected String getString(CssObjectIntrospector ci, Object object) {
        Border value = (Border)object;
        StringBuffer sb = new StringBuffer();
        sb.append("border(");
        sb.append(String.valueOf(value.getSize()));
        sb.append(",");
        sb.append(ColorKit.makeCSSColor(value.getColor()));
        sb.append(",");
        sb.append(BorderPeer.getConstantFromMap(STYLE_CONSTANTS, value.getStyle()));
        sb.append(")");
        return sb.toString();
    }

    static {
        HashMap<String, Integer> constantMap = new HashMap<String, Integer>();
        constantMap.put("STYLE_DASHED", new Integer(8));
        constantMap.put("STYLE_DOTTED", new Integer(7));
        constantMap.put("STYLE_DOUBLE", new Integer(6));
        constantMap.put("STYLE_GROOVE", new Integer(4));
        constantMap.put("STYLE_INSET", new Integer(2));
        constantMap.put("STYLE_NONE", new Integer(0));
        constantMap.put("STYLE_OUTSET", new Integer(3));
        constantMap.put("STYLE_DASHED", new Integer(8));
        constantMap.put("STYLE_RIDGE", new Integer(5));
        constantMap.put("STYLE_SOLID", new Integer(1));
        STYLE_CONSTANTS = Collections.unmodifiableMap(constantMap);
        constantMap.put("DASHED", new Integer(8));
        constantMap.put("DOTTED", new Integer(7));
        constantMap.put("DOUBLE", new Integer(6));
        constantMap.put("GROOVE", new Integer(4));
        constantMap.put("INSET", new Integer(2));
        constantMap.put("NONE", new Integer(0));
        constantMap.put("OUTSET", new Integer(3));
        constantMap.put("DASHED", new Integer(8));
        constantMap.put("RIDGE", new Integer(5));
        constantMap.put("SOLID", new Integer(1));
        STYLE_CONSTANT_ALTERNATES = Collections.unmodifiableMap(constantMap);
    }
}

