/*
 * Decompiled with CFR 0.152.
 */
package echopointng.stylesheet.propertypeer;

import echopointng.stylesheet.CssInvalidValueException;
import echopointng.stylesheet.CssObjectIntrospector;
import echopointng.stylesheet.CssPropertyPeer;
import echopointng.stylesheet.CssPropertyPeerLoader;
import echopointng.util.ExtentKit;
import echopointng.util.TokenizerKit;
import java.util.Map;
import nextapp.echo2.app.Extent;

public abstract class AbstractCssPropertyPeer
implements CssPropertyPeer {
    @Override
    public Object getJavaObject(ClassLoader classLoader, Class objectClass, String propertyValue, int lineNo) throws CssInvalidValueException {
        if (!this.canConvert(null, propertyValue)) {
            Class conversionClass = this.getConversionClass();
            try {
                CssObjectIntrospector ci = CssObjectIntrospector.forName(objectClass.getName(), classLoader);
                return this.getConstantValue(ci, conversionClass, propertyValue, lineNo);
            }
            catch (Exception ex) {
                throw new CssInvalidValueException("Invalid property value for class" + conversionClass.getName() + " : " + propertyValue, null, lineNo);
            }
        }
        if (AbstractCssPropertyPeer.isNullString(propertyValue)) {
            return null;
        }
        return this.getObject(null, propertyValue);
    }

    @Override
    public String getStyleString(ClassLoader classLoader, Class objectClass, Object propertyValue) {
        if (propertyValue == null) {
            return "null";
        }
        if (!AbstractCssPropertyPeer.isAssignableFrom(propertyValue, this.getConversionClass())) {
            return null;
        }
        return this.getString(null, propertyValue);
    }

    protected abstract Class getConversionClass();

    protected abstract boolean canConvert(CssObjectIntrospector var1, String var2);

    protected abstract Object getObject(CssObjectIntrospector var1, String var2);

    protected String getString(CssObjectIntrospector ci, Object object) {
        return object == null ? "null" : String.valueOf(object);
    }

    protected Object getConstantValue(CssObjectIntrospector ci, Class conversionClass, String propertyValue, int lineNo) throws CssInvalidValueException {
        Object constantValue = ci.getConstantValue(propertyValue);
        if (constantValue == null) {
            throw new CssInvalidValueException("No class field constant found for " + propertyValue, null, lineNo);
        }
        if (conversionClass.isAssignableFrom(constantValue.getClass())) {
            return constantValue;
        }
        constantValue = ci.getConstantValue(propertyValue.toUpperCase());
        if (conversionClass.isAssignableFrom(constantValue.getClass())) {
            return constantValue;
        }
        constantValue = ci.getConstantValue(propertyValue.toLowerCase());
        if (conversionClass.isAssignableFrom(constantValue.getClass())) {
            return constantValue;
        }
        throw new CssInvalidValueException("No suitable class field constant found for " + propertyValue, null, lineNo);
    }

    protected static boolean isAssignableFrom(Object value, Class targetClass) {
        if (value == null) {
            return true;
        }
        return targetClass.isAssignableFrom(value.getClass());
    }

    protected static boolean isNullString(String propertyValue) {
        return propertyValue.trim().equalsIgnoreCase("null");
    }

    protected static boolean isInteger(String propertyValue) {
        try {
            Integer.parseInt(propertyValue.trim());
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    protected static int getInteger(String propertyValue) {
        int val;
        try {
            val = Integer.parseInt(propertyValue.trim());
        }
        catch (NumberFormatException nfe) {
            val = Integer.MIN_VALUE;
        }
        return val;
    }

    protected static String getConstantFromMap(Map constantMap, Object equalsTo) {
        for (String key : constantMap.keySet()) {
            if (!constantMap.get(key).equals(equalsTo)) continue;
            return key;
        }
        return String.valueOf(equalsTo);
    }

    protected static String getConstantFromMap(Map constantMap, int intValue) {
        return AbstractCssPropertyPeer.getConstantFromMap(constantMap, new Integer(intValue));
    }

    protected static int getIntFromMap(Map constantMap, Object key) {
        return (Integer)constantMap.get(key);
    }

    protected static String[] tokenize(String tokenStr, String delims) {
        return TokenizerKit.tokenize(tokenStr, delims);
    }

    protected static boolean isExtent(String extentStr) {
        return ExtentKit.isExtent(extentStr);
    }

    protected static Extent makeExtent(String extentStr) {
        return ExtentKit.makeExtent(extentStr);
    }

    protected static CssPropertyPeer getPeer(Class peerClass) {
        CssPropertyPeerLoader loader = CssPropertyPeerLoader.forClassLoader(peerClass.getClassLoader());
        return loader.getPropertyPeer(peerClass);
    }
}

