/*
 * Decompiled with CFR 0.152.
 */
package echopointng.stylesheet;

import echopointng.stylesheet.CssInvalidValueException;
import echopointng.stylesheet.CssPropertyPeer;
import java.util.Map;
import java.util.WeakHashMap;
import nextapp.echo2.app.util.PeerFactory;

public class CssPropertyPeerLoader {
    private static final String PROPERTY_PEERS_PATH = "META-INF/echopointng/stylesheet/CssPropertyPeers.properties";
    private static final Map classLoaderToPropertyLoaderMap = new WeakHashMap();
    private PeerFactory propertyPeerFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CssPropertyPeerLoader forClassLoader(ClassLoader classLoader) {
        Map map = classLoaderToPropertyLoaderMap;
        synchronized (map) {
            CssPropertyPeerLoader propertyLoader = (CssPropertyPeerLoader)classLoaderToPropertyLoaderMap.get(classLoader);
            if (propertyLoader == null) {
                propertyLoader = new CssPropertyPeerLoader(classLoader);
                classLoaderToPropertyLoaderMap.put(classLoader, propertyLoader);
            }
            return propertyLoader;
        }
    }

    private CssPropertyPeerLoader(ClassLoader classLoader) {
        this.propertyPeerFactory = new PeerFactory(PROPERTY_PEERS_PATH, classLoader);
    }

    public Object getObject(ClassLoader classLoader, Class componentClass, Class propertyClass, String propertyValue, int lineNo) throws CssInvalidValueException {
        CssPropertyPeer propertyPeer = this.getPropertyPeer(propertyClass);
        if (propertyPeer == null) {
            throw new CssInvalidValueException("Peer not found for property class: " + propertyClass, null, lineNo);
        }
        return propertyPeer.getJavaObject(classLoader, componentClass, propertyValue, lineNo);
    }

    public String getString(ClassLoader classLoader, Class componentClass, Class propertyClass, Object propertyValue) throws CssInvalidValueException {
        CssPropertyPeer propertyPeer = this.getPropertyPeer(propertyClass);
        if (propertyPeer == null) {
            throw new CssInvalidValueException("Peer not found for property class: " + propertyClass, null, -1);
        }
        return propertyPeer.getStyleString(classLoader, componentClass, propertyValue);
    }

    public CssPropertyPeer getPropertyPeer(Class propertyClass) {
        return (CssPropertyPeer)this.propertyPeerFactory.getPeerForObject(propertyClass, false);
    }
}

