/*
 * Decompiled with CFR 0.152.
 */
package echopointng.image;

import echopointng.image.EncodedImageReference;
import echopointng.image.GifEncoder;
import echopointng.image.ImageEncoder;
import echopointng.image.ImageKit;
import echopointng.util.ColorKit;
import echopointng.util.FontKit;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.ImageGraphicAttribute;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Map;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.Insets;

public class TextImageReference
extends EncodedImageReference
implements Serializable {
    public static final int SCALE_NONE = 0;
    public static final int SCALE_FAST = 4;
    public static final int SCALE_SMOOTH = 8;
    public static final int SCALE_SPLICE_V_THEN_H = 16;
    public static final int SCALE_SPLICE_H_THEN_V = 32;
    public static final int SCALE_DEFAULT = 16;
    public static final Insets DEFAULT_INSETS = new Insets(3);
    private transient AttributedString attributedString;
    private transient Image backgroundImage;
    private transient Image[] replacementImages;
    private boolean bestQuality = true;
    private boolean autoCenterAtConstruction = false;
    private int horizontalAlignment = 4;
    private int replacementImageAlignment = 4;
    private int textAngle = 0;
    private int verticalAlignment = 4;
    private int x = Integer.MAX_VALUE;
    private int y = Integer.MAX_VALUE;
    private int origImageW = -1;
    private int origImageH = -1;
    private int scaleOption = 16;
    private Insets insets = DEFAULT_INSETS;
    private TextImageDrawer drawer = new TextImageDrawer();

    public TextImageReference(AttributedString string, Image backgroundImage) {
        this(string, backgroundImage, 16);
    }

    public TextImageReference(AttributedString string, Image backgroundImage, int scaleOption) {
        this(string, backgroundImage, scaleOption, new GifEncoder());
    }

    public TextImageReference(AttributedString string, Image backgroundImage, int scaleOption, ImageEncoder encoder) {
        this.constructTextImageRefererence(Integer.MAX_VALUE, Integer.MAX_VALUE, string, backgroundImage, scaleOption, encoder);
    }

    public TextImageReference(AttributedString string, String imageFileName, ImageEncoder encoder) {
        this(string, ImageKit.loadImage(imageFileName), 16, encoder);
    }

    public TextImageReference(AttributedString string, String imageFileName) {
        this(string, ImageKit.loadImage(imageFileName));
    }

    public TextImageReference(AttributedString string, URL imageURL) {
        this(string, ImageKit.loadImage(imageURL));
    }

    public TextImageReference(AttributedString string, URL imageURL, ImageEncoder encoder) {
        this(string, ImageKit.loadImage(imageURL), 16, encoder);
    }

    public TextImageReference(int x, int y, AttributedString string, Image backgroundImage) {
        this(x, y, string, backgroundImage, (ImageEncoder)new GifEncoder());
    }

    public TextImageReference(int x, int y, AttributedString string, Image backgroundImage, ImageEncoder encoder) {
        this.constructTextImageRefererence(x, y, string, backgroundImage, 16, encoder);
    }

    public TextImageReference(int x, int y, AttributedString string, String imageFileName) {
        this(x, y, string, ImageKit.loadImage(imageFileName));
    }

    public TextImageReference(int x, int y, AttributedString string, String imageFileName, ImageEncoder encoder) {
        this(x, y, string, ImageKit.loadImage(imageFileName), encoder);
    }

    public TextImageReference(int x, int y, AttributedString string, URL imageURL) {
        this(x, y, string, ImageKit.loadImage(imageURL));
    }

    public TextImageReference(int x, int y, AttributedString string, URL imageURL, ImageEncoder encoder) {
        this(x, y, string, ImageKit.loadImage(imageURL), encoder);
    }

    private void constructTextImageRefererence(int x, int y, AttributedString string, Image backgroundImage, int scalingOption, ImageEncoder encoder) {
        if (backgroundImage == null) {
            throw new IllegalArgumentException("The backgroundImage must be non null");
        }
        if (!ImageKit.waitForImage(backgroundImage)) {
            throw new IllegalStateException("The backgroundImage could not be loaded");
        }
        this.origImageW = backgroundImage.getWidth(ImageKit.imageObserver);
        this.origImageH = backgroundImage.getHeight(ImageKit.imageObserver);
        this.scaleOption = scalingOption;
        this.attributedString = string;
        this.backgroundImage = backgroundImage;
        if (x == Integer.MAX_VALUE && y == Integer.MAX_VALUE) {
            this.autoCenterAtConstruction = true;
        }
        if (encoder == null) {
            encoder = new GifEncoder();
        }
        super.setEncoder(encoder);
        super.setKeptInMemory(false);
        this.drawer.reconstructBackgroundImage(x, y);
    }

    protected Rectangle2D paintText(Graphics2D g, int x, int y) {
        return this.drawer.paintText(g, x, y, this.attributedString);
    }

    protected TextLayout[] getTextLayouts(Graphics2D g, AttributedString as) {
        ACI subcit;
        ACI cit = new ACI(this.attributedString.getIterator());
        FontRenderContext frc = g.getFontRenderContext();
        this.replaceAttributedImages(g, frc, this.attributedString);
        ArrayList<TextLayout> textLayouts = new ArrayList<TextLayout>();
        int current = cit.getBeginIndex();
        int end = cit.getEndIndex();
        int previous = current;
        boolean lastCharWasCR = false;
        char c = cit.first();
        while (c != '\uffff') {
            if (c == '\n') {
                if (!lastCharWasCR) {
                    subcit = new ACI(as.getIterator(null, previous, current));
                    textLayouts.add(new TextLayout(subcit.getIterator(), frc));
                    previous = current + 1;
                } else {
                    ++previous;
                }
                lastCharWasCR = true;
            } else {
                lastCharWasCR = false;
            }
            ++current;
            c = cit.next();
        }
        if (previous < end) {
            subcit = new ACI(as.getIterator(null, previous, end));
            textLayouts.add(new TextLayout(subcit.getIterator(), frc));
        }
        return textLayouts.toArray(new TextLayout[textLayouts.size()]);
    }

    protected void replaceAttributedImages(Graphics2D g, FontRenderContext frc, AttributedString as) {
        if (as == null) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        AttributedCharacterIterator cit = as.getIterator();
        char c = cit.first();
        while (c != '\uffff') {
            buf.append(c);
            c = cit.next();
        }
        String s = buf.toString();
        int ii = 0;
        Image[] images = this.replacementImages;
        if (images != null && images.length > 0) {
            int maxTextHeight = 0;
            for (int i = 0; i < this.replacementImages.length; ++i) {
                maxTextHeight = Math.max(maxTextHeight, images[i].getHeight(ImageKit.imageObserver));
            }
            TextLayout tl = new TextLayout(this.attributedString.getIterator(), frc);
            Rectangle rectText = tl.getBounds().getBounds();
            maxTextHeight = Math.max(maxTextHeight, rectText.height);
            int pos = s.indexOf("\ufffc");
            while (pos >= 0) {
                ImageKit.waitForImage(images[ii]);
                int imgH = images[ii].getHeight(ImageKit.imageObserver);
                boolean gX = false;
                int gY = 0;
                int attrAlignment = -1;
                if (this.replacementImageAlignment == 6) {
                    attrAlignment = 0;
                    gY = (int)((float)gY + ((float)rectText.height - tl.getDescent()));
                } else if (this.replacementImageAlignment == 4) {
                    attrAlignment = 0;
                    gY = imgH < maxTextHeight ? (int)((float)gY + (((float)rectText.height - tl.getDescent()) / 2.0f + (float)(imgH / 2))) : (gY += rectText.height / 2 + imgH / 2);
                } else if (this.replacementImageAlignment == 7) {
                    attrAlignment = 0;
                    gY += imgH;
                }
                ImageGraphicAttribute imageGraphic = new ImageGraphicAttribute(images[ii], attrAlignment, (float)gX, gY);
                as.addAttribute(TextAttribute.CHAR_REPLACEMENT, imageGraphic, pos, pos + 1);
                if (++ii >= images.length) {
                    ii = 0;
                }
                pos = s.indexOf("\ufffc", pos + 1);
            }
        }
    }

    @Override
    public Image getImage() {
        Image paintedImage = this.drawer.paintImage();
        return paintedImage;
    }

    public Image getBackgroundImage() {
        return this.backgroundImage;
    }

    @Override
    public Extent getHeight() {
        return new Extent(this.backgroundImage.getHeight(ImageKit.imageObserver));
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public int getReplacementImageAlignment() {
        return this.replacementImageAlignment;
    }

    public Image[] getReplacementImages() {
        return this.replacementImages;
    }

    public AttributedString getString() {
        return this.attributedString;
    }

    public int getTextAngle() {
        return this.textAngle;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    @Override
    public Extent getWidth() {
        return new Extent(this.backgroundImage.getWidth(ImageKit.imageObserver));
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean isBestQuality() {
        return this.bestQuality;
    }

    public void setBackgroundImage(Image image) {
        if (image == null) {
            throw new IllegalArgumentException("The background image must be non null");
        }
        Image oldImage = this.backgroundImage;
        this.backgroundImage = image;
        if (!oldImage.equals(image)) {
            this.fireImageChange();
        }
    }

    public void setBackgroundImage(String imageFileName) {
        Image image = ImageKit.loadImage(imageFileName);
        this.setBackgroundImage(image);
    }

    public void setBackgroundImage(URL imageURL) {
        Image image = ImageKit.loadImage(imageURL);
        this.setBackgroundImage(image);
    }

    public void setBestQuality(boolean b) {
        boolean oldValue = this.bestQuality;
        this.bestQuality = b;
        if (oldValue != this.bestQuality) {
            this.fireImageChange();
        }
    }

    public void setHorizontalAlignment(int i) {
        if (i != 3 && i != 4 && i != 5) {
            throw new IllegalArgumentException("setHorizontalAlignment must be one of Alignment.LEFT, Alignment.CENTER, or Alignment.RIGHT");
        }
        int oldValue = this.horizontalAlignment;
        this.horizontalAlignment = i;
        if (oldValue != this.horizontalAlignment) {
            this.fireImageChange();
        }
    }

    public void setReplacementImageAlignment(int i) {
        int oldValue = this.replacementImageAlignment;
        this.replacementImageAlignment = i;
        if (oldValue != this.replacementImageAlignment) {
            this.fireImageChange();
        }
    }

    public void setReplacementImages(Image[] images) {
        Image[] oldValue = this.replacementImages;
        this.replacementImages = images;
        if (oldValue != this.replacementImages) {
            this.fireImageChange();
        }
    }

    public void setString(AttributedString string) {
        AttributedString oldValue = this.attributedString;
        this.attributedString = string;
        if (oldValue != null && !oldValue.equals(this.attributedString)) {
            this.fireImageChange();
        }
    }

    public void setTextAngle(int i) {
        int oldValue = this.textAngle;
        this.textAngle = i;
        if (oldValue != this.textAngle) {
            this.fireImageChange();
        }
    }

    public void setVerticalAlignment(int i) {
        if (i != 6 && i != 4 && i != 7) {
            throw new IllegalArgumentException("setHorizontalAlignment must be one of Alignment.TOP, Alignment.CENTER, or Alignment.BOTTOM");
        }
        int oldValue = this.verticalAlignment;
        this.verticalAlignment = i;
        if (oldValue != this.verticalAlignment) {
            this.fireImageChange();
        }
    }

    public void setX(int i) {
        int oldValue = this.x;
        this.x = i;
        if (oldValue != this.x) {
            this.fireImageChange();
        }
    }

    public void setY(int i) {
        int oldValue = this.y;
        this.y = i;
        if (oldValue != this.y) {
            this.autoCenterAtConstruction = false;
            this.fireImageChange();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.backgroundImage = ImageKit.readSerializedImage(in);
        this.attributedString = ImageKit.readSerializedAttributedString(in);
        int replaceImagesLen = in.readInt();
        this.replacementImages = new Image[replaceImagesLen];
        for (int i = 0; i < replaceImagesLen; ++i) {
            this.replacementImages[i] = ImageKit.readSerializedImage(in);
        }
        this.fireImageChange();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        ImageKit.writeSerializedImage(out, this.backgroundImage);
        ImageKit.writeSerializedAttributedString(out, this.attributedString);
        int replaceImagesLen = this.replacementImages == null ? 0 : this.replacementImages.length;
        out.writeInt(replaceImagesLen);
        for (int i = 0; i < replaceImagesLen; ++i) {
            ImageKit.writeSerializedImage(out, this.replacementImages[i]);
        }
    }

    public static AttributedString getAttributedString(String s) {
        return TextImageReference.getAttributedString(s, null, null);
    }

    public static AttributedString getAttributedString(String s, nextapp.echo2.app.Color foreground, Font font) {
        AttributedString as = new AttributedString(s);
        if (s == null || s.length() == 0) {
            return as;
        }
        if (foreground != null) {
            as.addAttribute(TextAttribute.FOREGROUND, ColorKit.makeAwtColor(foreground, null));
        }
        if (font != null) {
            as.addAttribute(TextAttribute.FONT, FontKit.makeAwtFont(font, null));
        }
        return as;
    }

    public int getScaleOption() {
        return this.scaleOption;
    }

    public void setScaleOption(int scalingOption) {
        int oldValue = this.scaleOption;
        this.scaleOption = scalingOption;
        if (oldValue != scalingOption) {
            this.fireImageChange();
        }
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setInsets(Insets insets) {
        Insets oldValue = this.insets;
        this.insets = insets;
        if (oldValue != insets) {
            this.fireImageChange();
        }
    }

    private void fireImageChange() {
        this.drawer.reconstructBackgroundImage(this.x, this.y);
        this.update();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.attributedString != null) {
            sb.append(new ACI(this.attributedString.getIterator()).toString());
            sb.append(" origW:");
            sb.append(this.origImageW);
            sb.append(" origH:");
            sb.append(this.origImageH);
            return sb.toString();
        }
        return "null";
    }

    private class ACI
    implements Serializable {
        AttributedCharacterIterator cit;

        private ACI(AttributedCharacterIterator cit) {
            this.cit = cit;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            char c = this.cit.first();
            while (c != '\uffff') {
                buf.append(c);
                c = this.cit.next();
            }
            return buf.toString();
        }

        public AttributedCharacterIterator getIterator() {
            return this.cit;
        }

        protected Object clone() throws CloneNotSupportedException {
            return this.cit.clone();
        }

        public char current() {
            return this.cit.current();
        }

        public boolean equals(Object obj) {
            return this.cit.equals(obj);
        }

        public char first() {
            return this.cit.first();
        }

        public int getBeginIndex() {
            return this.cit.getBeginIndex();
        }

        public int getEndIndex() {
            return this.cit.getEndIndex();
        }

        public int getIndex() {
            return this.cit.getIndex();
        }

        public char last() {
            return this.cit.last();
        }

        public char next() {
            return this.cit.next();
        }

        public char previous() {
            return this.cit.previous();
        }

        public char setIndex(int position) {
            return this.cit.setIndex(position);
        }
    }

    private class TextImageDrawer
    implements Serializable {
        private TextImageDrawer() {
        }

        private AttributedString createTallVersion(AttributedString as) {
            if (as == null) {
                return as;
            }
            AttributedCharacterIterator cit = as.getIterator();
            char c = cit.first();
            while (c != '\uffff') {
                if (c == 'M' || c == 'y') {
                    return as;
                }
                c = cit.next();
            }
            int count = 0;
            StringBuffer buf = new StringBuffer();
            cit = as.getIterator();
            int c2 = cit.first();
            while (c2 != 65535) {
                if (Character.isLetter((char)c2)) {
                    c2 = count++ % 2 == 0 ? 121 : 77;
                }
                buf.append((char)c2);
                c2 = cit.next();
            }
            AttributedString newAS = new AttributedString(buf.toString());
            count = 0;
            cit = as.getIterator();
            char c3 = cit.first();
            while (c3 != '\uffff') {
                Map<AttributedCharacterIterator.Attribute, Object> attributes = cit.getAttributes();
                newAS.addAttributes(attributes, count, count + 1);
                ++count;
                c3 = cit.next();
            }
            return newAS;
        }

        private double calcTextLayoutHeight(TextLayout textLayout) {
            double height = 0.0;
            height += (double)textLayout.getAscent();
            height += (double)textLayout.getDescent();
            return height += (double)textLayout.getLeading();
        }

        Rectangle2D getPreferredBoundsRect(int imageW, int imageH) {
            int insetL = TextImageReference.this.getInsets() == null ? 0 : TextImageReference.this.getInsets().getLeft().getValue();
            int insetT = TextImageReference.this.getInsets() == null ? 0 : TextImageReference.this.getInsets().getTop().getValue();
            int insetR = TextImageReference.this.getInsets() == null ? 0 : TextImageReference.this.getInsets().getRight().getValue();
            int insetB = TextImageReference.this.getInsets() == null ? 0 : TextImageReference.this.getInsets().getBottom().getValue();
            Rectangle2D.Float preferredTB = new Rectangle2D.Float(insetL, insetT, imageW - insetR - insetL, imageH - insetB - insetT);
            return preferredTB;
        }

        private Dimension getTextDimensions(TextLayout[] textLayouts) {
            double height = 0.0;
            double width = 0.0;
            double w = 0.0;
            for (int i = 0; i < textLayouts.length; ++i) {
                w = textLayouts[i].getBounds().getWidth();
                if (w > width) {
                    width = w;
                }
                height += this.calcTextLayoutHeight(textLayouts[i]);
            }
            return new Dimension((int)width, (int)height);
        }

        void _paintCrossHairs(Graphics2D g, float x1, float y1, Color clr) {
            int x = (int)x1;
            int y = (int)y1;
            int delta = 15;
            g.setPaint(clr);
            g.drawLine(x, y, x, y - delta);
            g.drawLine(x, y, x + delta, y);
            g.drawLine(x, y, x, y + delta);
            g.drawLine(x, y, x - delta, y);
            g.drawLine(x, y, x + delta / 2, y + delta / 2);
        }

        private Rectangle2D paintRotatedTextCentered(Graphics2D g, TextLayout tl, float rx, float ry, int textAngle, int hTextAlignment, int vTextAlignment) {
            Rectangle rect = tl.getBounds().getBounds();
            AffineTransform atPrev = g.getTransform();
            float tx = rx;
            float ty = ry;
            if (hTextAlignment == 4) {
                tx = rx - (float)(rect.width / 2);
            }
            if (hTextAlignment == 5) {
                tx = rx - (float)rect.width;
            }
            if (vTextAlignment == 4) {
                ty = ry + (float)(rect.height / 2) - tl.getDescent() / 2.0f;
            }
            if (vTextAlignment == 6) {
                ty = ry + ((float)rect.height - tl.getDescent());
            }
            AffineTransform at = new AffineTransform();
            at.setToIdentity();
            at.rotate(Math.toRadians(textAngle), rx, ry);
            at.translate(tx, ty);
            g.setTransform(at);
            float dx = 0.0f;
            float dy = 0.0f;
            tl.draw(g, dx, dy);
            g.setTransform(atPrev);
            Rectangle2D.Double bounds = new Rectangle2D.Double();
            ((Rectangle2D)bounds).setRect(rect.getX() + (double)tx, rect.getY() + (double)ty, rect.getWidth(), rect.getHeight());
            return bounds;
        }

        private void reconstructBackgroundImage(int inX, int inY) {
            if (!ImageKit.waitForImage(TextImageReference.this.backgroundImage)) {
                throw new IllegalStateException("The backgroundImage could not be scaled");
            }
            int imageW = TextImageReference.this.backgroundImage.getWidth(ImageKit.imageObserver);
            int imageH = TextImageReference.this.backgroundImage.getHeight(ImageKit.imageObserver);
            if (TextImageReference.this.getScaleOption() != 0) {
                AttributedString tallAS;
                int paintY;
                int paintX;
                Rectangle2D actualTB;
                int insetB;
                int insetR;
                int insetT;
                BufferedImage bufImage = new BufferedImage(1, 1, 2);
                Graphics2D g = bufImage.createGraphics();
                int insetL = TextImageReference.this.getInsets() == null ? 0 : TextImageReference.this.getInsets().getLeft().getValue();
                Rectangle2D.Float preferredTB = new Rectangle2D.Float(insetL, insetT = TextImageReference.this.getInsets() == null ? 0 : TextImageReference.this.getInsets().getTop().getValue(), imageW - (insetR = TextImageReference.this.getInsets() == null ? 0 : TextImageReference.this.getInsets().getRight().getValue()) - insetL, imageH - (insetB = TextImageReference.this.getInsets() == null ? 0 : TextImageReference.this.getInsets().getBottom().getValue()) - insetT);
                if (!preferredTB.contains(actualTB = this.paintText(g, paintX = TextImageReference.this.autoCenterAtConstruction || inX == Integer.MAX_VALUE ? imageW / 2 : inX, paintY = TextImageReference.this.autoCenterAtConstruction || inY == Integer.MAX_VALUE ? imageH / 2 : inY, tallAS = this.createTallVersion(TextImageReference.this.attributedString)))) {
                    int spliceY;
                    int useScalingOption = TextImageReference.this.getScaleOption();
                    int newW = (int)(actualTB.getWidth() + (double)insetL + (double)insetR);
                    int newH = (int)(actualTB.getHeight() + (double)insetT + (double)insetB);
                    newW = Math.max(imageW, newW);
                    newH = Math.max(imageH, newH);
                    int spliceX = TextImageReference.this.autoCenterAtConstruction || inX == Integer.MAX_VALUE ? imageW / 2 : inX;
                    int n = spliceY = TextImageReference.this.autoCenterAtConstruction || inY == Integer.MAX_VALUE ? imageH / 2 : inY;
                    if (useScalingOption == 32) {
                        TextImageReference.this.backgroundImage = ImageKit.enlargeImageSpliceHoriz(TextImageReference.this.backgroundImage, spliceY, newH);
                        TextImageReference.this.backgroundImage = ImageKit.enlargeImageSpliceVert(TextImageReference.this.backgroundImage, spliceX, newW);
                    } else if (useScalingOption == 16) {
                        TextImageReference.this.backgroundImage = ImageKit.enlargeImageSpliceVert(TextImageReference.this.backgroundImage, spliceX, newW);
                        TextImageReference.this.backgroundImage = ImageKit.enlargeImageSpliceHoriz(TextImageReference.this.backgroundImage, spliceY, newH);
                    } else {
                        TextImageReference.this.backgroundImage = TextImageReference.this.backgroundImage.getScaledInstance(newW, newH, useScalingOption);
                    }
                    imageW = newW;
                    imageH = newH;
                }
            }
            TextImageReference.this.x = TextImageReference.this.autoCenterAtConstruction || inX == Integer.MAX_VALUE ? imageW / 2 : inX;
            TextImageReference.this.y = TextImageReference.this.autoCenterAtConstruction || inY == Integer.MAX_VALUE ? imageH / 2 : inY;
        }

        private Image paintImage() {
            ImageKit.waitForImage(TextImageReference.this.backgroundImage);
            int imageW = TextImageReference.this.backgroundImage.getWidth(ImageKit.imageObserver);
            int imageH = TextImageReference.this.backgroundImage.getHeight(ImageKit.imageObserver);
            BufferedImage bufImage = new BufferedImage(imageW, imageH, 2);
            Graphics2D g = bufImage.createGraphics();
            if (TextImageReference.this.bestQuality) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            } else {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            }
            g.drawImage(TextImageReference.this.backgroundImage, 0, 0, imageW, imageH, ImageKit.imageObserver);
            this.paintText(g, TextImageReference.this.x, TextImageReference.this.y, TextImageReference.this.attributedString);
            g.dispose();
            return bufImage;
        }

        private Rectangle2D paintText(Graphics2D g, int x, int y, AttributedString attributedString) {
            float fy;
            int limit;
            if (attributedString == null) {
                return new Rectangle();
            }
            ACI cit = new ACI(attributedString.getIterator());
            int start = cit.getBeginIndex();
            if (start == (limit = cit.getEndIndex())) {
                return new Rectangle();
            }
            FontRenderContext frc = g.getFontRenderContext();
            TextImageReference.this.replaceAttributedImages(g, frc, attributedString);
            TextLayout[] textLayouts = TextImageReference.this.getTextLayouts(g, attributedString);
            Dimension textDimensions = this.getTextDimensions(textLayouts);
            float textHeight = (float)textDimensions.getHeight();
            float textWidth = (float)textDimensions.getWidth();
            if (textWidth <= 0.0f || textHeight <= 0.0f) {
                return new Rectangle();
            }
            float fx = x;
            float fydraw = fy = (float)y;
            if (TextImageReference.this.verticalAlignment == 4) {
                fy -= textHeight / 2.0f;
            }
            Rectangle2D textBounds = null;
            for (int i = 0; i < textLayouts.length; ++i) {
                fydraw = fy;
                if (TextImageReference.this.verticalAlignment == 4) {
                    fydraw = (float)((double)fydraw + this.calcTextLayoutHeight(textLayouts[i]) / 2.0);
                }
                Rectangle2D singleTextBounds = this.paintRotatedTextCentered(g, textLayouts[i], fx, fydraw, TextImageReference.this.textAngle, TextImageReference.this.horizontalAlignment, TextImageReference.this.verticalAlignment);
                textBounds = textBounds == null ? singleTextBounds : textBounds.createUnion(singleTextBounds);
                fy = (float)((double)fy + this.calcTextLayoutHeight(textLayouts[i]));
            }
            return textBounds;
        }
    }
}

