/*
 * Decompiled with CFR 0.152.
 */
package echopointng.image;

import echopointng.util.ColorKit;
import echopointng.util.collections.ConcurrentReaderHashMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.awt.image.RGBImageFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Map;
import java.util.Set;
import nextapp.echo2.app.AwtImageReference;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.ResourceImageReference;

public class ImageKit {
    public static final Component imageObserver = new Component(){};
    public static final MediaTracker imageMediaTracker = new MediaTracker(imageObserver);
    private static int mediaTrackerIDs = 0;
    private static Map imageCache = new ConcurrentReaderHashMap();
    private static Map coloredImageCache = new ConcurrentReaderHashMap();

    private ImageKit() {
    }

    public static ImageReference createImageRef(nextapp.echo2.app.Color background, int width, int height) {
        Color clrBackground = ColorKit.makeAwtColor(background, Color.white);
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setColor(clrBackground);
        g.fillRect(0, 0, width, height);
        return new AwtImageReference(image);
    }

    public static ImageReference getTransparentImageRef(int width, int height) {
        return new ResourceImageReference("/echopointng/ui/resource/images/transparent1x1.gif", new Extent(width), new Extent(height));
    }

    public static ImageReference getColoredImageRef(nextapp.echo2.app.Color backgroundColor, int width, int height) {
        String name = "" + backgroundColor.getRgb() + "w:" + width + "h:" + height;
        SoftReference softRef = (SoftReference)coloredImageCache.get(name);
        AwtImageReference awtImageRef = softRef == null ? null : softRef.get();
        if (awtImageRef == null) {
            BufferedImage image = new BufferedImage(width, height, 1);
            Graphics2D g = image.createGraphics();
            g.setColor(ColorKit.makeAwtColor(backgroundColor, Color.lightGray));
            g.fillRect(0, 0, width, height);
            g.dispose();
            awtImageRef = new AwtImageReference(image);
            coloredImageCache.put(name, new SoftReference<AwtImageReference>(awtImageRef));
        }
        return awtImageRef;
    }

    public static BufferedImage copyImage(Image srcImage) {
        if (srcImage == null) {
            throw new IllegalArgumentException("The srcImage must be non null");
        }
        if (!ImageKit.waitForImage(srcImage)) {
            throw new IllegalStateException("The srcImage could not be loaded");
        }
        int width = srcImage.getWidth(imageObserver);
        int height = srcImage.getHeight(imageObserver);
        boolean hasAlpha = ImageKit.hasAlphaChannel(srcImage);
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = ImageKit.getColorModel(srcImage).getTransparency();
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(width, height, transparency);
        }
        catch (Exception transparency) {
            // empty catch block
        }
        if (bimage == null) {
            int type = hasAlpha ? 2 : 1;
            bimage = new BufferedImage(width, height, type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(srcImage, 0, 0, width, height, imageObserver);
        g.dispose();
        return bimage;
    }

    private static Image _loadImageFromCache(Object imageLocation, int width, int height) {
        SoftReference<Image> imageRef = (SoftReference<Image>)imageCache.get(imageLocation);
        Image image = imageRef == null ? null : imageRef.get();
        if (image == null) {
            if (imageLocation instanceof URL) {
                image = width >= 0 && height >= 0 ? ImageKit.loadImage((URL)imageLocation, width, height) : ImageKit.loadImage((URL)imageLocation);
            }
            if (imageLocation instanceof String) {
                image = width >= 0 && height >= 0 ? ImageKit.loadImage((String)imageLocation, width, height) : ImageKit.loadImage((String)imageLocation);
            }
            imageRef = new SoftReference<Image>(image);
            imageCache.put(imageLocation, imageRef);
        }
        return image;
    }

    public static Image loadImage(String imageFileName) {
        Image image = Toolkit.getDefaultToolkit().createImage(imageFileName);
        if (!ImageKit.waitForImage(image)) {
            return null;
        }
        return image;
    }

    public static Image loadCachedImage(String imageFileName) {
        return ImageKit._loadImageFromCache(imageFileName, -1, -1);
    }

    public static Image loadImage(String imageFileName, int width, int height) {
        Image image = Toolkit.getDefaultToolkit().createImage(imageFileName);
        if (!ImageKit.waitForImage(image)) {
            return null;
        }
        return ImageKit.makeBufferedImage(image, width, height);
    }

    public static Image loadCachedImage(String imageFileName, int width, int height) {
        return ImageKit._loadImageFromCache(imageFileName, width, height);
    }

    public static Image loadImage(URL imageUrl) {
        Image image = Toolkit.getDefaultToolkit().createImage(imageUrl);
        if (!ImageKit.waitForImage(image)) {
            return null;
        }
        return image;
    }

    public static Image loadCachedImage(URL imageUrl) {
        return ImageKit._loadImageFromCache(imageUrl, -1, -1);
    }

    public static Image loadImage(URL imageUrl, int width, int height) {
        Image image = Toolkit.getDefaultToolkit().createImage(imageUrl);
        if (!ImageKit.waitForImage(image)) {
            return null;
        }
        return ImageKit.makeBufferedImage(image, width, height);
    }

    public static Image loadCachedImage(URL imageUrl, int width, int height) {
        return ImageKit._loadImageFromCache(imageUrl, width, height);
    }

    public static Image loadResourceImage(String imageResourceName) {
        URL url = ImageKit.class.getResource(imageResourceName);
        return ImageKit.loadImage(url);
    }

    public static Image loadCachedResourceImage(String imageResourceName) {
        URL url = ImageKit.class.getResource(imageResourceName);
        return ImageKit.loadCachedImage(url);
    }

    public static Image loadResourceImage(String imageResourceName, int width, int height) {
        URL url = ImageKit.class.getResource(imageResourceName);
        return ImageKit.loadImage(url, width, height);
    }

    public static Image loadCachedResourceImage(String imageResourceName, int width, int height) {
        URL url = ImageKit.class.getResource(imageResourceName);
        return ImageKit.loadCachedImage(url, width, height);
    }

    public static BufferedImage makeBufferedImage(Image srcImage) {
        if (!ImageKit.waitForImage(srcImage)) {
            return null;
        }
        int iw = srcImage.getWidth(imageObserver);
        int ih = srcImage.getHeight(imageObserver);
        int type = ImageKit.hasAlphaChannel(srcImage) ? 2 : 1;
        return ImageKit.makeBufferedImage(srcImage, iw, ih, type);
    }

    public static BufferedImage makeBufferedImage(Image srcImage, int width, int height) {
        if (!ImageKit.waitForImage(srcImage)) {
            return null;
        }
        int type = ImageKit.hasAlphaChannel(srcImage) ? 2 : 1;
        return ImageKit.makeBufferedImage(srcImage, width, height, type);
    }

    public static BufferedImage makeBufferedImage(Image srcImage, int width, int height, int imageType) {
        if (!(srcImage instanceof BufferedImage) && !ImageKit.waitForImage(srcImage)) {
            return null;
        }
        int iw = srcImage.getWidth(imageObserver);
        int ih = srcImage.getHeight(imageObserver);
        if (srcImage instanceof BufferedImage && iw == width && ih == height) {
            return (BufferedImage)srcImage;
        }
        BufferedImage bi = new BufferedImage(width, height, imageType);
        Graphics2D g = bi.createGraphics();
        g.drawImage(srcImage, 0, 0, width, height, imageObserver);
        g.dispose();
        return bi;
    }

    public static ColorModel getColorModel(Image srcImage) {
        if (srcImage instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)srcImage;
            return bimage.getColorModel();
        }
        PixelGrabber pg = new PixelGrabber(srcImage, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel cm = pg.getColorModel();
        return cm;
    }

    public static boolean hasAlphaChannel(Image srcImage) {
        ColorModel cm = ImageKit.getColorModel(srcImage);
        if (cm != null) {
            return cm.hasAlpha();
        }
        return false;
    }

    public static Image swapImageColors(Image srcImage, nextapp.echo2.app.Color srcColor, nextapp.echo2.app.Color destColor) {
        if (srcColor == null) {
            throw new IllegalArgumentException("The srcColor must be non null");
        }
        if (destColor == null) {
            throw new IllegalArgumentException("The destColor must be non null");
        }
        Color srcClr = ColorKit.makeAwtColor(srcColor, null);
        Color destClr = ColorKit.makeAwtColor(destColor, null);
        FilteredImageSource ip = new FilteredImageSource(srcImage.getSource(), new ColorSwapImageFilter(srcClr, destClr));
        Image returnImage = Toolkit.getDefaultToolkit().createImage(ip);
        ImageKit.waitForImage(returnImage);
        return returnImage;
    }

    public static Image makeImageColorTransparent(Image srcImage, nextapp.echo2.app.Color markerColor) {
        return ImageKit.makeImageColorTransparent(srcImage, markerColor, 0);
    }

    public static Image makeImageColorTransparent(Image srcImage, nextapp.echo2.app.Color markerColor, int alpha) {
        if (alpha < 0 && alpha > 255) {
            throw new IllegalArgumentException("The alpha value must be between 0 and 255");
        }
        Color awtTransClr = ColorKit.makeAwtColor(markerColor, null);
        FilteredImageSource ip = new FilteredImageSource(srcImage.getSource(), new TransparencyImageFilter(awtTransClr, alpha));
        Image returnImage = Toolkit.getDefaultToolkit().createImage(ip);
        ImageKit.waitForImage(returnImage);
        return returnImage;
    }

    public static BufferedImage makeImageGreyScale(Image srcImage) {
        BufferedImage bufImage = srcImage instanceof BufferedImage ? (BufferedImage)srcImage : ImageKit.makeBufferedImage(srcImage);
        ColorSpace cs = ColorSpace.getInstance(1003);
        ColorConvertOp op = new ColorConvertOp(cs, null);
        return op.filter(bufImage, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitForImage(Image srcImage) {
        if (srcImage == null) {
            return false;
        }
        Component component = imageObserver;
        synchronized (component) {
        }
        imageMediaTracker.addImage(srcImage, ++mediaTrackerIDs);
        try {
            imageMediaTracker.waitForID(mediaTrackerIDs);
        }
        catch (Exception e) {
            return false;
        }
        return !imageMediaTracker.isErrorID(mediaTrackerIDs);
    }

    public static void writeSerializedAttributedString(ObjectOutputStream out, AttributedString as) throws IOException {
        AttributedCharacterIterator.Attribute attr;
        Object value;
        if (as == null) {
            out.writeObject(null);
            return;
        }
        AttributedCharacterIterator cit = as.getIterator();
        StringBuffer buf = new StringBuffer();
        char c = cit.first();
        while (c != '\uffff') {
            buf.append(c);
            c = cit.next();
        }
        out.writeObject("nonnull");
        out.writeObject(buf.toString());
        cit = as.getIterator();
        Set<AttributedCharacterIterator.Attribute> keys = cit.getAllAttributeKeys();
        int keyCount = 0;
        for (AttributedCharacterIterator.Attribute key : keys) {
            if (!(key instanceof Serializable) || !((value = cit.getAttribute(attr = key)) instanceof Serializable)) continue;
            ++keyCount;
        }
        out.writeInt(keyCount);
        for (AttributedCharacterIterator.Attribute key : keys) {
            if (!(key instanceof Serializable) || !((value = cit.getAttribute(attr = key)) instanceof Serializable)) continue;
            out.writeObject(attr);
            out.writeObject(value);
        }
    }

    public static void writeSerializedImage(ObjectOutputStream out, Image srcImage) throws IOException {
        if (srcImage == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            int width = srcImage.getWidth(imageObserver);
            int height = srcImage.getHeight(imageObserver);
            out.writeInt(width);
            out.writeInt(height);
            int[] pixels = new int[width * height];
            try {
                PixelGrabber pg = new PixelGrabber(srcImage, 0, 0, width, height, pixels, 0, width);
                pg.grabPixels();
                if ((pg.getStatus() & 0x80) != 0) {
                    throw new IOException("Unable to serialize java.awt.image: PixelGrabber aborted.");
                }
            }
            catch (InterruptedException ex) {
                throw new IOException("Unable to serialize java.awt.Image: PixelGrabber interrupted.");
            }
            out.writeObject(pixels);
        }
    }

    public static AttributedString readSerializedAttributedString(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object marker = in.readObject();
        if (marker == null) {
            return null;
        }
        String s = (String)in.readObject();
        AttributedString as = new AttributedString(s);
        int keyCount = in.readInt();
        for (int i = 0; i < keyCount; ++i) {
            AttributedCharacterIterator.Attribute attr = (AttributedCharacterIterator.Attribute)in.readObject();
            Object value = in.readObject();
            as.addAttribute(attr, value);
        }
        return as;
    }

    public static Image readSerializedImage(ObjectInputStream in) throws IOException, ClassNotFoundException {
        boolean hasImageData = in.readBoolean();
        if (hasImageData) {
            int width = in.readInt();
            int height = in.readInt();
            int[] pixels = (int[])in.readObject();
            if (pixels != null) {
                ColorModel colorModel = ColorModel.getRGBdefault();
                return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(width, height, colorModel, pixels, 0, width));
            }
        }
        return null;
    }

    public static Image mirrowImage(Image srcImage) {
        BufferedImage bufferedImage = ImageKit.makeBufferedImage(srcImage);
        AffineTransform tx = AffineTransform.getScaleInstance(-1.0, 1.0);
        tx.translate(-bufferedImage.getWidth(imageObserver), 0.0);
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        bufferedImage = op.filter(bufferedImage, null);
        return bufferedImage;
    }

    public static Image flipImage(Image srcImage) {
        BufferedImage bufferedImage = ImageKit.makeBufferedImage(srcImage);
        AffineTransform tx = AffineTransform.getScaleInstance(1.0, -1.0);
        tx.translate(0.0, -bufferedImage.getHeight(imageObserver));
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        bufferedImage = op.filter(bufferedImage, null);
        return bufferedImage;
    }

    public static Image rotateImage(Image srcImage) {
        BufferedImage bufferedImage = ImageKit.makeBufferedImage(srcImage);
        AffineTransform tx = AffineTransform.getScaleInstance(-1.0, -1.0);
        tx.translate(-bufferedImage.getWidth(imageObserver), -bufferedImage.getHeight(imageObserver));
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        bufferedImage = op.filter(bufferedImage, null);
        return bufferedImage;
    }

    public static Image enlargeImageSpliceVert(Image srcImage, int x, int newW) {
        int imgW = srcImage.getWidth(imageObserver);
        int imgH = srcImage.getHeight(imageObserver);
        if (newW <= imgW) {
            return srcImage;
        }
        if (x <= 0 || x >= imgW) {
            x = imgW / 2;
        }
        return ImageKit._spliceImageInternal(srcImage, x, 0, newW, imgH, imgW, imgH, true);
    }

    public static Image enlargeImageSpliceHoriz(Image srcImage, int y, int newH) {
        int imgW = srcImage.getWidth(imageObserver);
        int imgH = srcImage.getHeight(imageObserver);
        if (newH <= imgH) {
            return srcImage;
        }
        if (y <= 0 || y >= imgH) {
            y = imgH / 2;
        }
        return ImageKit._spliceImageInternal(srcImage, 0, y, imgW, newH, imgW, imgH, false);
    }

    private static Image _spliceImageInternal(Image srcImage, int x, int y, int newW, int newH, int imgW, int imgH, boolean verticallyFirst) {
        x = x <= 0 ? imgW / 2 : x;
        y = y <= 0 ? imgH / 2 : y;
        int widthDiff = newW - imgW;
        int heightDiff = newH - imgH;
        int sx1 = 0;
        int sy1 = 0;
        int sx2 = 0;
        int sy2 = 0;
        int dx1 = 0;
        int dy1 = 0;
        int dx2 = 0;
        int dy2 = 0;
        BufferedImage bufImg = new BufferedImage(newW, newH, 2);
        Graphics2D g = bufImg.createGraphics();
        if (verticallyFirst) {
            sx1 = x;
            sy1 = 0;
            sx2 = x + 1;
            sy2 = imgH;
            dx1 = x;
            dy1 = 0;
            dx2 = x + 1;
            dy2 = newH;
            for (int i = 0; i < widthDiff; ++i) {
                g.drawImage(srcImage, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, imageObserver);
                ++dx1;
                ++dx2;
            }
            sx1 = 0;
            sy1 = 0;
            sx2 = x;
            sy2 = imgH;
            dx1 = 0;
            dy1 = 0;
            dx2 = x;
            dy2 = newH;
            g.drawImage(srcImage, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, imageObserver);
            sx1 = x;
            sy1 = 0;
            sx2 = imgW;
            sy2 = imgH;
            dx1 = newW - (imgW - x);
            dy1 = 0;
            dx2 = newW;
            dy2 = newH;
            g.drawImage(srcImage, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, imageObserver);
        } else {
            sx1 = 0;
            sy1 = y;
            sx2 = imgW;
            sy2 = y + 1;
            dx1 = 0;
            dy1 = y;
            dx2 = newW;
            dy2 = y + 1;
            for (int i = 0; i < heightDiff; ++i) {
                g.drawImage(srcImage, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, imageObserver);
                ++dy1;
                ++dy2;
            }
            sx1 = 0;
            sy1 = 0;
            sx2 = imgW;
            sy2 = y;
            dx1 = 0;
            dy1 = 0;
            dx2 = newW;
            dy2 = y;
            g.drawImage(srcImage, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, imageObserver);
            sx1 = 0;
            sy1 = y;
            sx2 = imgW;
            sy2 = imgH;
            dx1 = 0;
            dy1 = newH - (imgH - y);
            dx2 = newW;
            dy2 = newH;
            g.drawImage(srcImage, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, imageObserver);
        }
        g.dispose();
        return bufImg;
    }

    private static class TransparencyImageFilter
    extends RGBImageFilter {
        private int markerRGB = 0;
        private int alphaRGB = 0;

        private TransparencyImageFilter(Color markerColor, int alpha) {
            Color alphaColor = new Color(markerColor.getRed(), markerColor.getGreen(), markerColor.getBlue(), alpha);
            this.alphaRGB = (alpha & 0xFF) << 24 | (markerColor.getRed() & 0xFF) << 16 | (markerColor.getGreen() & 0xFF) << 8 | (markerColor.getBlue() & 0xFF) << 0;
            this.alphaRGB = alphaColor.getRGB();
            this.markerRGB = markerColor.getRGB() | 0xFF000000;
            this.canFilterIndexColorModel = true;
        }

        @Override
        public final int filterRGB(int x, int y, int rgb) {
            int currentColor = rgb | 0xFF000000;
            if (currentColor == this.markerRGB) {
                return this.alphaRGB;
            }
            return rgb;
        }
    }

    private static class ColorSwapImageFilter
    extends RGBImageFilter {
        private int srcRGB = 0;
        private int destRGB = 0;

        private ColorSwapImageFilter(Color srcColor, Color destColor) {
            this.srcRGB = (srcColor.getRed() & 0xFF) << 16 | (srcColor.getGreen() & 0xFF) << 8 | (srcColor.getBlue() & 0xFF) << 0;
            this.destRGB = (destColor.getRed() & 0xFF) << 16 | (destColor.getGreen() & 0xFF) << 8 | (destColor.getBlue() & 0xFF) << 0;
            this.canFilterIndexColorModel = true;
        }

        @Override
        public final int filterRGB(int x, int y, int rgb) {
            int currentColor = rgb & 0xFFFFFF;
            if (currentColor == this.srcRGB) {
                return rgb & 0xFF000000 | this.destRGB;
            }
            return rgb;
        }
    }
}

