/*
 * Decompiled with CFR 0.152.
 */
package echopointng;

import echopointng.AbleComponent;
import echopointng.template.TemplateDataSource;
import echopointng.template.TemplateTextSubstitution;
import java.util.HashMap;
import java.util.Map;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.PaneContainer;

public class TemplatePanel
extends AbleComponent
implements PaneContainer {
    public static final String PROPERTY_EXCEPTION_ON_FAILURE = "exceptionOnFailure";
    public static final String PROPERTY_INVOKE_SETTEXT = "invokeSetText";
    public static final String PROPERTY_TEMPLATE_DATA_SOURCE = "templateDataSource";
    public static final String PROPERTY_TEMPLATE_TEXT_SUBSTITUTION = "templateTextSubstition";
    private Map componentNameMap = new HashMap();
    private boolean styleApplied;

    public TemplatePanel() {
    }

    public TemplatePanel(TemplateDataSource tds) {
        this.setTemplateDataSource(tds);
    }

    public void addNamedComponent(Component component, String componentName) {
        if (component == null) {
            throw new IllegalArgumentException("component must be non null.");
        }
        if (componentName == null) {
            throw new IllegalArgumentException("componentName must be non null.");
        }
        this.componentNameMap.put(componentName, component);
        this.add(component);
    }

    public String getComponentName(Component component) {
        String[] componentNames = this.getNamedComponents();
        for (int i = 0; i < componentNames.length; ++i) {
            Component c = this.getNamedComponent(componentNames[i]);
            if (component != c) continue;
            return componentNames[i];
        }
        return null;
    }

    public Component getNamedComponent(String componentName) {
        return (Component)this.componentNameMap.get(componentName);
    }

    public String[] getNamedComponents() {
        return this.componentNameMap.keySet().toArray(new String[this.componentNameMap.keySet().size()]);
    }

    public TemplateDataSource getTemplateDataSource() {
        return (TemplateDataSource)this.getProperty(PROPERTY_TEMPLATE_DATA_SOURCE);
    }

    public TemplateTextSubstitution getTemplateTextSubstitution() {
        return (TemplateTextSubstitution)this.getProperty(PROPERTY_TEMPLATE_TEXT_SUBSTITUTION);
    }

    public boolean isExceptionOnFailure() {
        return this.getProperty(PROPERTY_EXCEPTION_ON_FAILURE, false);
    }

    public boolean isInvokeSetText() {
        return this.getProperty(PROPERTY_INVOKE_SETTEXT, false);
    }

    public boolean isStyleApplied() {
        return this.styleApplied;
    }

    @Override
    public void remove(Component c) {
        String componentName = this.getComponentName(c);
        if (componentName != null) {
            this.componentNameMap.remove(componentName);
        }
        super.remove(c);
    }

    public void removeNamedComponent(String componentName) {
        if (componentName == null) {
            throw new IllegalArgumentException("componentName must be non null.");
        }
        Component child = this.getNamedComponent(componentName);
        this.componentNameMap.remove(componentName);
        if (child != null) {
            this.remove(child);
        }
    }

    public void setExceptionOnFailure(boolean newValue) {
        this.setProperty(PROPERTY_EXCEPTION_ON_FAILURE, newValue);
    }

    public void setInvokeSetText(boolean newValue) {
        this.setProperty(PROPERTY_INVOKE_SETTEXT, newValue);
    }

    public void setStyleApplied(boolean styleApplied) {
        this.styleApplied = styleApplied;
    }

    public void setTemplateDataSource(TemplateDataSource templateDataSource) {
        this.setProperty(PROPERTY_TEMPLATE_DATA_SOURCE, templateDataSource);
    }

    public void setTemplateTextSubstitution(TemplateTextSubstitution textSubstitution) {
        this.setProperty(PROPERTY_TEMPLATE_TEXT_SUBSTITUTION, textSubstitution);
    }

    @Override
    public void validate() {
        super.validate();
        String[] names = this.getNamedComponents();
        for (int i = 0; i < names.length; ++i) {
            Component child = this.getNamedComponent(names[i]);
            if (this.isAncestorOf(child)) continue;
            this.add(child);
        }
    }
}

