/*
 * Decompiled with CFR 0.152.
 */
package echopointng;

import echopointng.BorderEx;
import echopointng.ComponentEx;
import echopointng.ExtentEx;
import echopointng.MutableStyleEx;
import echopointng.able.Attributeable;
import echopointng.able.Stretchable;
import echopointng.command.AttributesAdd;
import echopointng.layout.TableLayoutDataEx;
import echopointng.list.ListSelectionModelEx;
import echopointng.table.DefaultTableCellRendererEx;
import echopointng.table.TableActionEventEx;
import echopointng.table.TableCellRendererEx;
import echopointng.table.TableColumnEx;
import echopointng.util.ColorKit;
import echopointng.util.TokenizerKit;
import echopointng.xhtml.XhtmlFragment;
import java.io.Serializable;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.Table;
import nextapp.echo2.app.event.ActionListener;
import nextapp.echo2.app.table.DefaultTableModel;
import nextapp.echo2.app.table.TableCellRenderer;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import nextapp.echo2.app.table.TableModel;

public class TableEx
extends Table
implements Attributeable,
Stretchable {
    public static final int FOOTER_ROW = -2;
    public static final Serializable CELL_SPANNER = new Serializable(){};
    public static final Style DEFAULT_STYLE;
    public static final TableCellRendererEx DEFAULT_TABLE_CELL_RENDERER;
    public static final String PROPERTY_HEADER_BACKGROUND = "headerBackground";
    public static final String PROPERTY_FOOTER_BACKGROUND = "footerBackground";
    public static final String PROPERTY_FOOTER_VISIBLE = "footerVisible";
    public static final String PROPERTY_HEIGHT = "height";
    public static final String PROPERTY_IGNORE_META_KEYS = "ignoreMetaKeys";
    public static final String PROPERTY_RESIZE_DRAG_BAR_USED = "resizeDragBarUsed";
    public static final String PROPERTY_RESIZE_GROWS_TABLE = "resizeGrowsTable";
    public static final String PROPERTY_RESIZEABLE = "resizeable";
    public static final String PROPERTY_SCROLLABLE = "scrollable";
    public static final String COLUMN_WIDTHS_CHANGED_PROPERTY = "columnWidthsChanged";
    public static final String DEFAULT_FOOTER_RENDERER_CHANGED_PROPERTY = "defaultFooterRenderer";
    private Map attributeMap;
    private TableCellRenderer defaultFooterRenderer;
    private TableCellRenderer defaultRenderer = DEFAULT_TABLE_CELL_RENDERER;
    protected CellMatrix cellMatrix;
    protected boolean valid;
    protected boolean footerVisible;

    public TableEx() {
        this(new DefaultTableModel());
    }

    public TableEx(int columns, int rows) {
        this(new DefaultTableModel(columns, rows));
    }

    public TableEx(TableModel model) {
        this(model, null);
    }

    public TableEx(TableModel model, TableColumnModel columnModel) {
        super(model, columnModel);
        this.setFocusTraversalParticipant(false);
    }

    @Override
    public void processInput(String inputName, Object inputValue) {
        if (inputName.equals("selection")) {
            if (this.getSelectionModel() instanceof ListSelectionModelEx) {
                ListSelectionModelEx listSelectionModelEx = (ListSelectionModelEx)this.getSelectionModel();
                listSelectionModelEx.setSelectedIndices((int[])inputValue);
            } else {
                super.processInput(inputName, inputValue);
            }
        }
        if ("action".equals(inputName)) {
            String value = String.valueOf(inputValue);
            String[] values = TokenizerKit.tokenize(value, ";", false);
            int metaKeyInfo = 0;
            int row = -1;
            int column = -1;
            for (int i = 0; i < values.length; ++i) {
                if (values[i].startsWith("c:")) {
                    column = Integer.parseInt(values[i].substring(2));
                }
                if (values[i].startsWith("r:")) {
                    row = Integer.parseInt(values[i].substring(2));
                }
                if (!values[i].startsWith("mk:")) continue;
                metaKeyInfo = Integer.parseInt(values[i].substring(3));
            }
            this.fireActionEvent(metaKeyInfo, column, row);
        }
        if (inputName.equals(COLUMN_WIDTHS_CHANGED_PROPERTY)) {
            int[] columnWidths = (int[])inputValue;
            TableColumnModel columnModel = this.getColumnModel();
            if (columnModel != null) {
                for (int i = 0; i < columnWidths.length; ++i) {
                    TableColumn tableColumn = columnModel.getColumn(i);
                    if (tableColumn == null) continue;
                    tableColumn.setWidth(new ExtentEx(columnWidths[i]));
                }
            }
        }
    }

    protected void fireActionEvent(int metaKeyInfo, int column, int row) {
        if (!this.hasEventListenerList()) {
            return;
        }
        EventListener[] listeners = this.getEventListenerList().getListeners(ActionListener.class);
        TableActionEventEx e = null;
        for (int i = 0; i < listeners.length; ++i) {
            if (e == null) {
                e = new TableActionEventEx(this, (String)this.getRenderProperty("actionCommand"), metaKeyInfo, column, row);
            }
            ((ActionListener)listeners[i]).actionPerformed(e);
        }
    }

    @Override
    protected void doRender() {
        Component renderedComponent;
        int columnIndex;
        TableModel model = this.getModel();
        TableColumnModel columnModel = this.getColumnModel();
        TableCellRenderer defaultHeaderRenderer = this.getDefaultHeaderRenderer();
        TableCellRenderer defaultFooterRenderer = this.getDefaultFooterRenderer();
        TableCellRenderer defaultRenderer = this.getDefaultRenderer();
        defaultRenderer = defaultRenderer == null ? DEFAULT_TABLE_CELL_RENDERER : defaultRenderer;
        int rowCount = model.getRowCount();
        int columnCount = columnModel.getColumnCount();
        boolean isHeaderVisible = this.isHeaderVisible();
        boolean isFooterVisible = this.isFooterVisible();
        HashMap<Component, Component> encounteredComponentMap = new HashMap<Component, Component>();
        this.cellMatrix = new CellMatrix(columnCount, rowCount, CELL_SPANNER);
        TableColumn[] tableColumns = new TableColumn[columnCount];
        TableCellRenderer[] columnRenderers = new TableCellRenderer[columnCount];
        for (columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
            Class columnClass;
            tableColumns[columnIndex] = columnModel.getColumn(columnIndex);
            TableCellRenderer renderer = tableColumns[columnIndex].getCellRenderer();
            if (renderer == null && (renderer = this.getDefaultRenderer(columnClass = model.getColumnClass(tableColumns[columnIndex].getModelIndex()))) == null) {
                renderer = defaultRenderer;
            }
            columnRenderers[columnIndex] = renderer;
        }
        if (isHeaderVisible) {
            for (columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                Component renderedComponent2;
                TableCellRenderer headerRenderer;
                int modelColumnIndex = tableColumns[columnIndex].getModelIndex();
                Object headerValue = tableColumns[columnIndex].getHeaderValue();
                if (headerValue == null) {
                    headerValue = model.getColumnName(modelColumnIndex);
                }
                if ((headerRenderer = tableColumns[columnIndex].getHeaderRenderer()) == null && (headerRenderer = defaultHeaderRenderer) == null) {
                    headerRenderer = defaultRenderer;
                }
                if ((renderedComponent2 = this.doRenderCellContent(headerRenderer, headerValue, modelColumnIndex, -1)) == null) continue;
                encounteredComponentMap.put(renderedComponent2, renderedComponent2);
            }
        }
        if (isFooterVisible) {
            for (columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                TableColumn tableColumn = tableColumns[columnIndex];
                int modelColumnIndex = tableColumn.getModelIndex();
                Object footerValue = null;
                if (tableColumn instanceof TableColumnEx) {
                    footerValue = ((TableColumnEx)tableColumn).getFooterValue();
                }
                if (footerValue == null) {
                    footerValue = model.getColumnName(modelColumnIndex);
                }
                TableCellRenderer footerRenderer = null;
                if (tableColumn instanceof TableColumnEx) {
                    footerRenderer = ((TableColumnEx)tableColumn).getFooterRenderer();
                }
                if (footerRenderer == null && (footerRenderer = defaultFooterRenderer) == null) {
                    footerRenderer = defaultRenderer;
                }
                if ((renderedComponent = this.doRenderCellContent(footerRenderer, footerValue, modelColumnIndex, -2)) == null) continue;
                encounteredComponentMap.put(renderedComponent, renderedComponent);
            }
        }
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            for (int columnIndex2 = 0; columnIndex2 < columnCount; ++columnIndex2) {
                TableCellRenderer cellRenderer = columnRenderers[columnIndex2];
                int modelColumnIndex = tableColumns[columnIndex2].getModelIndex();
                Object modelValue = model.getValueAt(modelColumnIndex, rowIndex);
                renderedComponent = this.doRenderCellContent(cellRenderer, modelValue, modelColumnIndex, rowIndex);
                if (renderedComponent == null) continue;
                encounteredComponentMap.put(renderedComponent, renderedComponent);
            }
        }
        Component[] children = this.getComponents();
        for (int i = 0; i < children.length; ++i) {
            Component child = children[i];
            if (encounteredComponentMap.containsKey(child)) continue;
            this.remove(child);
        }
        this.firePropertyChange("repaint", null, model);
    }

    protected Component doRenderCellContent(TableCellRenderer cellRenderer, Object modelValue, int column, int row) {
        if (this.cellMatrix.getCellContent(column, row) != null) {
            return null;
        }
        Serializable content = null;
        int rowSpan = 0;
        int colSpan = 0;
        TableLayoutDataEx layoutDataEx = null;
        Component renderedComponent = cellRenderer.getTableCellRendererComponent(this, modelValue, column, row);
        if (renderedComponent == null) {
            if (cellRenderer instanceof TableCellRendererEx) {
                LayoutData layoutData;
                XhtmlFragment fragment;
                TableCellRendererEx cellRendererEx = (TableCellRendererEx)cellRenderer;
                content = fragment = cellRendererEx.getTableCellRendererContent(this, modelValue, column, row);
                if (fragment != null && (layoutData = fragment.getLayoutData()) instanceof TableLayoutDataEx) {
                    layoutDataEx = (TableLayoutDataEx)layoutData;
                }
                boolean isActionCausing = cellRendererEx.isActionCausingCells(this, column, row);
                boolean isSelectionCausing = cellRendererEx.isSelectionCausingCell(this, column, row);
                if (!isActionCausing) {
                    this.cellMatrix.setCellProperties(column, row, "actionCausing", new Boolean(false));
                }
                if (!isSelectionCausing) {
                    this.cellMatrix.setCellProperties(column, row, "selectionCausing", new Boolean(false));
                }
            } else {
                content = null;
            }
        } else if (renderedComponent != null) {
            LayoutData layoutData;
            if (!this.isAncestorOf(renderedComponent)) {
                this.add(renderedComponent);
            }
            if ((layoutData = (LayoutData)renderedComponent.getRenderProperty("layoutData")) instanceof TableLayoutDataEx) {
                layoutDataEx = (TableLayoutDataEx)layoutData;
            }
            content = renderedComponent;
        } else {
            content = null;
        }
        if (layoutDataEx != null) {
            colSpan = layoutDataEx.getColSpan();
            rowSpan = layoutDataEx.getRowSpan();
        }
        this.cellMatrix.setCellContent(content, column, row, colSpan, rowSpan);
        return renderedComponent;
    }

    @Override
    public Object getAttribute(String attributeName) {
        if (this.attributeMap != null) {
            return this.attributeMap.get(attributeName);
        }
        return null;
    }

    @Override
    public String[] getAttributeNames() {
        if (this.attributeMap == null) {
            return new String[0];
        }
        int count = 0;
        String[] attributeNames = new String[this.attributeMap.keySet().size()];
        Iterator iter = this.attributeMap.keySet().iterator();
        while (iter.hasNext()) {
            attributeNames[count++] = (String)iter.next();
        }
        return attributeNames;
    }

    @Override
    public Component getCellComponent(int column, int row) {
        Object value = this.getCellContent(column, row);
        if (value instanceof Component) {
            return (Component)value;
        }
        return null;
    }

    public Object getCellContent(int column, int row) {
        if (!this.valid) {
            this.validate();
        }
        if (this.cellMatrix != null) {
            return this.cellMatrix.getCellContent(column, row);
        }
        return null;
    }

    public boolean isActionCausingCell(int column, int row) {
        if (this.cellMatrix == null) {
            return true;
        }
        Object value = this.cellMatrix.getCellProperties(column, row, "actionCausing");
        return value == null;
    }

    public boolean isSelectionCausingCell(int column, int row) {
        if (this.cellMatrix == null) {
            return true;
        }
        Object value = this.cellMatrix.getCellProperties(column, row, "selectionCausing");
        return value == null;
    }

    public Color getHeaderBackground() {
        return (Color)this.getProperty(PROPERTY_HEADER_BACKGROUND);
    }

    public Color getFooterBackground() {
        return (Color)this.getProperty(PROPERTY_FOOTER_BACKGROUND);
    }

    public Extent getHeight() {
        return (Extent)this.getProperty(PROPERTY_HEIGHT);
    }

    @Override
    public void init() {
        super.init();
        this.getApplicationInstance().enqueueCommand(new AttributesAdd((Component)this, this));
    }

    @Override
    protected void invalidate() {
        this.valid = false;
    }

    public boolean isFooterVisible() {
        return ComponentEx.getProperty((Component)this, PROPERTY_FOOTER_VISIBLE, false);
    }

    public boolean isIgnoreMetaKeys() {
        return ComponentEx.getProperty((Component)this, PROPERTY_IGNORE_META_KEYS, false);
    }

    public boolean isResizeable() {
        return ComponentEx.getProperty((Component)this, PROPERTY_RESIZEABLE, false);
    }

    public boolean isResizeDragBarUsed() {
        return ComponentEx.getProperty((Component)this, PROPERTY_RESIZE_DRAG_BAR_USED, false);
    }

    public boolean isResizeGrowsTable() {
        return ComponentEx.getProperty((Component)this, PROPERTY_RESIZE_GROWS_TABLE, true);
    }

    public boolean isScrollable() {
        return ComponentEx.getProperty((Component)this, PROPERTY_SCROLLABLE, false);
    }

    @Override
    public void setAttribute(String attributeName, Object attributeValue) {
        if (this.attributeMap == null) {
            this.attributeMap = new HashMap();
        }
        this.attributeMap.put(attributeName, attributeValue);
    }

    public void setHeaderBackground(Color newValue) {
        this.setProperty(PROPERTY_HEADER_BACKGROUND, newValue);
    }

    public void setFooterBackground(Color newValue) {
        this.setProperty(PROPERTY_FOOTER_BACKGROUND, newValue);
    }

    public void setHeight(Extent newValue) {
        this.setProperty(PROPERTY_HEIGHT, newValue);
    }

    public void setResizeable(boolean newValue) {
        ComponentEx.setProperty((Component)this, PROPERTY_RESIZEABLE, newValue);
    }

    public void setResizeDragBarUsed(boolean newValue) {
        ComponentEx.setProperty((Component)this, PROPERTY_RESIZE_DRAG_BAR_USED, newValue);
    }

    public void setResizeGrowsTable(boolean newValue) {
        ComponentEx.setProperty((Component)this, PROPERTY_RESIZE_GROWS_TABLE, newValue);
    }

    public void setScrollable(boolean newValue) {
        ComponentEx.setProperty((Component)this, PROPERTY_SCROLLABLE, newValue);
    }

    public void setFooterVisible(boolean newValue) {
        ComponentEx.setProperty((Component)this, PROPERTY_FOOTER_VISIBLE, newValue);
        this.invalidate();
    }

    public void setIgnoreMetaKeys(boolean newValue) {
        ComponentEx.setProperty((Component)this, PROPERTY_IGNORE_META_KEYS, newValue);
    }

    public TableCellRenderer getDefaultFooterRenderer() {
        return this.defaultFooterRenderer;
    }

    public void setDefaultFooterRenderer(TableCellRenderer newValue) {
        this.invalidate();
        TableCellRenderer oldValue = this.defaultFooterRenderer;
        this.defaultFooterRenderer = newValue;
        this.firePropertyChange(DEFAULT_FOOTER_RENDERER_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setDefaultRenderer(TableCellRenderer newValue) {
        this.invalidate();
        TableCellRenderer oldValue = this.defaultRenderer;
        this.defaultRenderer = newValue;
        this.firePropertyChange("defaultRenderer", oldValue, newValue);
    }

    public TableCellRenderer getDefaultRenderer() {
        return this.defaultRenderer;
    }

    @Override
    public void validate() {
        super.validate();
        while (!this.valid) {
            this.valid = true;
            this.doRender();
        }
    }

    @Override
    public Extent getMaximumStretchedHeight() {
        return (Extent)this.getProperty("maximumStretchedHeight");
    }

    @Override
    public Extent getMinimumStretchedHeight() {
        return (Extent)this.getProperty("minimumStretchedHeight");
    }

    @Override
    public boolean isHeightStretched() {
        return ComponentEx.getProperty((Component)this, "heightStretched", false);
    }

    @Override
    public void setHeightStretched(boolean newValue) {
        ComponentEx.setProperty((Component)this, "heightStretched", newValue);
    }

    @Override
    public void setMaximumStretchedHeight(Extent newValue) {
        Extent.validate(newValue, 1);
        this.setProperty("maximumStretchedHeight", newValue);
    }

    @Override
    public void setMinimumStretchedHeight(Extent newValue) {
        Extent.validate(newValue, 1);
        this.setProperty("minimumStretchedHeight", newValue);
    }

    static {
        MutableStyleEx style = new MutableStyleEx();
        style.setProperty("selectionBackground", Color.YELLOW);
        style.setProperty("border", BorderEx.DEFAULT);
        style.setProperty("rolloverEnabled", true);
        style.setProperty("rolloverBackground", ColorKit.makeColor("#DEF3FF"));
        DEFAULT_STYLE = style;
        DEFAULT_TABLE_CELL_RENDERER = new DefaultTableCellRendererEx();
    }

    protected class CellMatrix
    implements Serializable {
        private Map cellContentMap;
        private Object cellSpanObject;
        private int columnCount;
        private int rowCount;
        private Map propertyMap;

        public CellMatrix(int columnCount, int rowCount, Object cellSpanObject) {
            this.rowCount = rowCount;
            this.columnCount = columnCount;
            this.cellSpanObject = cellSpanObject;
            int cellCount = rowCount * columnCount;
            this.cellContentMap = new HashMap(cellCount += TableEx.this.isHeaderVisible() ? columnCount : 0);
        }

        public boolean containsCellContent(Object value) {
            for (Map.Entry entry : this.cellContentMap.entrySet()) {
                if (entry.getValue() != value && !entry.getValue().equals(value)) continue;
                return true;
            }
            return false;
        }

        public Object getCellContent(int column, int row) {
            this.validateCoordinate(column, row);
            String key = this.getColRowKey(column, row);
            Object content = this.cellContentMap.get(key);
            return content;
        }

        public Object getCellSpanObject() {
            return this.cellSpanObject;
        }

        private String getColRowKey(int column, int row) {
            StringBuffer sb = new StringBuffer("col:");
            sb.append(column);
            sb.append("row:");
            sb.append(row);
            return sb.toString();
        }

        public int getColumnCount() {
            return this.columnCount;
        }

        public int getRowCount() {
            return this.rowCount;
        }

        public void setCellContent(Object value, int column, int row) {
            this.setCellContent(value, column, row, 0, 0);
        }

        public void setCellContent(Object value, int column, int row, int colSpan, int rowSpan) {
            this.validateCoordinate(column, row);
            String key = this.getColRowKey(column, row);
            this.cellContentMap.put(key, value);
            if (rowSpan > 1 || colSpan > 1) {
                int maxRows = row;
                if (rowSpan > 1) {
                    maxRows = Math.min(row + (rowSpan - 1), this.rowCount - 1);
                }
                int maxColumns = column;
                for (int rowIndex = row; rowIndex <= maxRows; ++rowIndex) {
                    if (colSpan > 1) {
                        maxColumns = Math.min(column + (colSpan - 1), this.columnCount - 1);
                        for (int columnIndex = column; columnIndex <= maxColumns; ++columnIndex) {
                            if (rowIndex == row && columnIndex == column) continue;
                            this.setCellContent(this.cellSpanObject, columnIndex, rowIndex);
                        }
                    }
                    if (rowIndex == row) continue;
                    this.setCellContent(this.cellSpanObject, column, rowIndex);
                }
            }
        }

        public void setCellProperties(int column, int row, String propertyName, Object value) {
            if (this.propertyMap == null) {
                this.propertyMap = new HashMap();
            }
            String key = this.makePropertyMapKey(column, row, propertyName);
            this.propertyMap.put(key, value);
        }

        public Object getCellProperties(int column, int row, String propertyName) {
            if (this.propertyMap == null) {
                return null;
            }
            String key = this.makePropertyMapKey(column, row, propertyName);
            return this.propertyMap.get(key);
        }

        private String makePropertyMapKey(int column, int row, String propertyName) {
            String key = "r:" + row + "c:" + column + "pn:" + propertyName;
            return key;
        }

        private void validateCoordinate(int column, int row) {
            if (column < 0) {
                throw new IllegalArgumentException("The column index [" + column + "] is less than zero");
            }
            if (column > this.columnCount) {
                throw new IllegalArgumentException("The column index [" + column + "] is greater than columnCount [" + this.columnCount + "]");
            }
            if (row > this.rowCount) {
                throw new IllegalArgumentException("The row index [" + row + "] is greater than rowCount [" + this.rowCount + "]");
            }
            int minRowIndex = 0;
            if (TableEx.this.isHeaderVisible()) {
                minRowIndex = -1;
            }
            if (TableEx.this.isFooterVisible()) {
                minRowIndex = -2;
            }
            if (row < minRowIndex) {
                throw new IllegalArgumentException("The row index [" + row + "] is less than the minimum allowed [" + minRowIndex + "]");
            }
        }
    }
}

