/*
 * Decompiled with CFR 0.152.
 */
package echopointng;

import echopointng.AbleComponent;
import echopointng.ExtentEx;
import echopointng.MutableStyleEx;
import echopointng.model.BoundedRangeModel;
import echopointng.model.DefaultBoundedRangeModel;
import echopointng.progressbar.DefaultProgressBarRenderer;
import echopointng.progressbar.ProgressBarRenderer;
import echopointng.util.ColorKit;
import java.io.Serializable;
import java.util.EventListener;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.event.ChangeEvent;
import nextapp.echo2.app.event.ChangeListener;

public class ProgressBar
extends AbleComponent {
    public static final String PROPERTY_COMPLETED_COLOR = "completedColor";
    public static final String PROPERTY_MODEL = "model";
    public static final String PROPERTY_NUMBER_OF_BLOCKS = "numberOfBlocks";
    public static final String PROPERTY_ORIENTATION = "orientation";
    public static final String PROPERTY_PROGRESS_STRING = "progressString";
    public static final String PROPERTY_PROGRESS_STRING_PAINTED = "progressStringPainted";
    public static final String PROPERTY_PROGRESSBAR_IMAGE = "progressBarImage";
    public static final String PROPERTY_RENDERER = "renderer";
    public static final String PROPERTY_UNCOMPLETED_COLOR = "uncompletedColor";
    public static final int ORIENTATION_HORIZONTAL = 0;
    public static final int ORIENTATION_VERTICAL = 1;
    public static final Style DEFAULT_STYLE;
    protected transient ChangeEvent changeEvent = null;
    protected ChangeListener changeListener = null;
    private boolean invalid = true;

    public ProgressBar() {
        this(new DefaultBoundedRangeModel());
    }

    public ProgressBar(BoundedRangeModel newModel) {
        this.setModel(newModel);
        this.setRenderer(new DefaultProgressBarRenderer());
    }

    public ProgressBar(int min, int max) {
        this(new DefaultBoundedRangeModel(0, 0, min, max));
    }

    public void addChangeListener(ChangeListener l) {
        this.getEventListenerList().addListener(ChangeListener.class, l);
    }

    protected ChangeListener createChangeListener() {
        return new InternalModelListener();
    }

    protected void fireStateChanged() {
        EventListener[] listeners = this.getEventListenerList().getListeners(ChangeListener.class);
        for (int index = 0; index < listeners.length; ++index) {
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[index]).stateChanged(this.changeEvent);
        }
    }

    public Color getCompletedColor() {
        return (Color)this.getProperty(PROPERTY_COMPLETED_COLOR);
    }

    public int getMaximum() {
        return this.getModel().getMaximum();
    }

    public int getMinimum() {
        return this.getModel().getMinimum();
    }

    public BoundedRangeModel getModel() {
        return (BoundedRangeModel)this.getProperty(PROPERTY_MODEL);
    }

    public int getNumberOfBlocks() {
        return this.getProperty(PROPERTY_NUMBER_OF_BLOCKS, 10);
    }

    public int getOrientation() {
        return this.getProperty(PROPERTY_ORIENTATION, 0);
    }

    public double getPercentComplete() {
        BoundedRangeModel model = this.getModel();
        double pc = 0.0;
        if (model != null) {
            long span = model.getMaximum() - model.getMinimum();
            double currentValue = model.getValue();
            pc = (currentValue - (double)model.getMinimum()) / (double)span;
        }
        return pc;
    }

    public ImageReference getProgressBarImage() {
        return (ImageReference)this.getProperty(PROPERTY_PROGRESSBAR_IMAGE);
    }

    public String getProgressString() {
        String progressString = (String)this.getProperty(PROPERTY_PROGRESS_STRING);
        if (progressString != null) {
            return progressString;
        }
        int pc = (int)Math.round(100.0 * this.getPercentComplete());
        return new String(pc + "%");
    }

    public ProgressBarRenderer getRenderer() {
        return (ProgressBarRenderer)this.getProperty(PROPERTY_RENDERER);
    }

    public Color getUncompletedColor() {
        return (Color)this.getProperty(PROPERTY_UNCOMPLETED_COLOR);
    }

    public int getValue() {
        return this.getModel().getValue();
    }

    public void invalidate() {
        this.invalid = true;
    }

    public boolean isProgressStringPainted() {
        return this.getProperty(PROPERTY_PROGRESS_STRING_PAINTED, false);
    }

    public void removeChangeListener(ChangeListener l) {
        this.getEventListenerList().removeListener(ChangeListener.class, l);
    }

    public void setCompletedColor(Color newColor) {
        this.setProperty(PROPERTY_COMPLETED_COLOR, newColor);
    }

    public void setMaximum(int n) {
        this.getModel().setMaximum(n);
    }

    public void setMinimum(int n) {
        this.getModel().setMinimum(n);
    }

    public void setModel(BoundedRangeModel newModel) {
        BoundedRangeModel oldModel = this.getModel();
        this.setProperty(PROPERTY_MODEL, newModel);
        if (newModel != oldModel) {
            if (oldModel != null) {
                oldModel.removeChangeListener(this.changeListener);
                this.changeListener = null;
            }
            if (newModel != null) {
                this.changeListener = this.createChangeListener();
                newModel.addChangeListener(this.changeListener);
            }
            newModel.setExtent(0);
        }
    }

    public void setNumberOfBlocks(int newValue) {
        if (newValue < 0) {
            newValue = 1;
        }
        this.setProperty(PROPERTY_NUMBER_OF_BLOCKS, newValue);
    }

    public void setOrientation(int newOrientation) {
        this.setOrientation(newOrientation, true);
    }

    public void setOrientation(int newOrientation, boolean flipWidthAndHeight) {
        int oldOrientation = this.getOrientation();
        if (oldOrientation != newOrientation) {
            switch (newOrientation) {
                case 0: 
                case 1: {
                    if (flipWidthAndHeight) {
                        Extent temp = this.getWidth();
                        this.setWidth(this.getHeight());
                        this.setHeight(temp);
                    }
                    this.setProperty(PROPERTY_ORIENTATION, newOrientation);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(newOrientation + " is not a legal orientation");
                }
            }
        }
    }

    public void setProgressString(String newValue) {
        this.setProperty(PROPERTY_PROGRESS_STRING, newValue);
    }

    public void setProgressStringPainted(boolean newValue) {
        this.setProperty(PROPERTY_PROGRESS_STRING_PAINTED, newValue);
    }

    public void setRenderer(ProgressBarRenderer newRenderer) {
        this.setProperty(PROPERTY_RENDERER, newRenderer);
    }

    public void setUncompletedColor(Color newColor) {
        this.setProperty(PROPERTY_UNCOMPLETED_COLOR, newColor);
    }

    public void setValue(int n) {
        this.getModel().setValue(n);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("w=");
        sb.append(this.getWidth());
        sb.append(" h=");
        sb.append(this.getHeight());
        sb.append(" orient=");
        sb.append(this.getOrientation() == 0 ? "horz" : "vert");
        sb.append(" val=");
        sb.append(this.getValue());
        return sb.toString();
    }

    @Override
    public void validate() {
        super.validate();
        if (this.invalid) {
            ProgressBarRenderer renderer = this.getRenderer();
            ImageReference newValue = renderer == null ? null : renderer.drawProgressBar(this);
            this.setProperty(PROPERTY_PROGRESSBAR_IMAGE, newValue);
            this.invalid = false;
        }
    }

    static {
        MutableStyleEx style = new MutableStyleEx();
        style.setProperty("border", new Border(1, ColorKit.makeColor("#D6D3CE"), 1));
        style.setProperty("height", new ExtentEx("30px"));
        style.setProperty("width", new ExtentEx("146px"));
        style.setProperty(PROPERTY_COMPLETED_COLOR, Color.ORANGE);
        style.setProperty(PROPERTY_UNCOMPLETED_COLOR, Color.LIGHTGRAY);
        DEFAULT_STYLE = style;
    }

    private class InternalModelListener
    implements ChangeListener,
    Serializable {
        private InternalModelListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ProgressBar.this.invalidate();
            ProgressBar.this.fireStateChanged();
        }
    }
}

