/*
 * Decompiled with CFR 0.152.
 */
package echopointng;

import echopointng.ComponentEx;
import echopointng.KeyStrokes;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;

public class KeyStrokeListener
extends ComponentEx
implements KeyStrokes {
    public static final String ACTION_LISTENERS_CHANGED_PROPERTY = "actionListeners";
    public static final String KEYSTROKE_CHANGED_PROPERTY = "keyStroke";
    public static final String PROPERTY_CANCEL_MODE = "cancelMode";
    public static final String PROPERTY_TARGET = "target";
    private Map keyCombos = new HashMap();

    @Override
    public boolean isValidChild(Component child) {
        return false;
    }

    @Override
    public void processInput(String inputName, Object inputValue) {
        Integer key;
        super.processInput(inputName, inputValue);
        if (KEYSTROKE_CHANGED_PROPERTY.equals(inputName) && (key = (Integer)inputValue) != null && this.hasKeyCombination(key)) {
            if (!this.hasEventListenerList()) {
                return;
            }
            String command = this.getKeyCombinationCommand(key);
            ActionEvent ae = new ActionEvent(this, command);
            EventListener[] listeners = this.getEventListenerList().getListeners(ActionListener.class);
            for (int index = 0; index < listeners.length; ++index) {
                ((ActionListener)listeners[index]).actionPerformed(ae);
            }
        }
    }

    public void addKeyCombination(int keyCombination, String command) {
        Integer key = new Integer(keyCombination);
        this.keyCombos.put(key, command);
        this.firePropertyChange(KEYSTROKE_CHANGED_PROPERTY, key, null);
    }

    public void addKeyCombination(int keyCombination) {
        this.addKeyCombination(keyCombination, KeyStrokeListener.getMnemonic(keyCombination));
    }

    public boolean hasKeyCombination(int keyCombination) {
        Integer key = new Integer(keyCombination);
        return this.keyCombos.containsKey(key);
    }

    public void removeKeyCombination(int keyCombination) {
        Integer key = new Integer(keyCombination);
        this.keyCombos.remove(key);
        this.firePropertyChange(KEYSTROKE_CHANGED_PROPERTY, key, null);
    }

    public int[] getKeyCombinations() {
        int len = this.keyCombos.size();
        int[] keyArray = new int[len];
        len = 0;
        for (Integer key : this.keyCombos.keySet()) {
            keyArray[len] = key;
            ++len;
        }
        Arrays.sort(keyArray);
        return keyArray;
    }

    public String getKeyCombinationCommand(int keyCombination) {
        Integer key = new Integer(keyCombination);
        return (String)this.keyCombos.get(key);
    }

    public void addActionListener(ActionListener l) {
        this.getEventListenerList().addListener(ActionListener.class, l);
        this.firePropertyChange(ACTION_LISTENERS_CHANGED_PROPERTY, null, l);
    }

    public boolean hasActionListeners() {
        return this.hasEventListenerList() && this.getEventListenerList().getListenerCount(ActionListener.class) != 0;
    }

    public void removeActionListener(ActionListener l) {
        if (!this.hasEventListenerList()) {
            return;
        }
        this.getEventListenerList().removeListener(ActionListener.class, l);
        this.firePropertyChange(ACTION_LISTENERS_CHANGED_PROPERTY, l, null);
    }

    public boolean getCancelMode() {
        return this.getProperty(PROPERTY_CANCEL_MODE, false);
    }

    public void setCancelMode(boolean newValue) {
        this.setProperty(PROPERTY_CANCEL_MODE, newValue);
    }

    public Component getTarget() {
        return (Component)this.getProperty(PROPERTY_TARGET);
    }

    public void setTarget(Component newValue) {
        this.setProperty(PROPERTY_TARGET, newValue);
    }

    public static String getMnemonic(int keyCombination) {
        StringBuffer sb = new StringBuffer();
        KeyStrokeListener.getMnemonicBase(keyCombination, sb);
        if ((keyCombination & 0x4000) == 16384) {
            sb.insert(0, "Shift-");
        }
        if ((keyCombination & 0x2000) == 8192) {
            sb.insert(0, "Ctrl-");
        }
        if ((keyCombination & 0x1000) == 4096) {
            sb.insert(0, "Alt-");
        }
        return sb.toString();
    }

    private static void getMnemonicBase(int keyCombination, StringBuffer sb) {
        keyCombination &= 0xFFFFEFFF;
        keyCombination &= 0xFFFFDFFF;
        keyCombination &= 0xFFFFBFFF;
        switch (keyCombination &= 0xFFFF7FFF) {
            case 3: {
                sb.append("Cancel");
                break;
            }
            case 6: {
                sb.append("Help");
                break;
            }
            case 8: {
                sb.append("Backspace");
                break;
            }
            case 9: {
                sb.append("Tab");
                break;
            }
            case 12: {
                sb.append("Clear");
                break;
            }
            case 13: {
                sb.append("Return");
                break;
            }
            case 14: {
                sb.append("Enter");
                break;
            }
            case 16: {
                sb.append("Shift");
                break;
            }
            case 17: {
                sb.append("Control");
                break;
            }
            case 18: {
                sb.append("Alt");
                break;
            }
            case 19: {
                sb.append("Pause");
                break;
            }
            case 20: {
                sb.append("Capslock");
                break;
            }
            case 27: {
                sb.append("Escape");
                break;
            }
            case 32: {
                sb.append("Space");
                break;
            }
            case 33: {
                sb.append("PgUp");
                break;
            }
            case 34: {
                sb.append("PgDown");
                break;
            }
            case 35: {
                sb.append("End");
                break;
            }
            case 36: {
                sb.append("Home");
                break;
            }
            case 37: {
                sb.append("Left");
                break;
            }
            case 38: {
                sb.append("Up");
                break;
            }
            case 39: {
                sb.append("Right");
                break;
            }
            case 40: {
                sb.append("Down");
                break;
            }
            case 44: {
                sb.append("Printscreen");
                break;
            }
            case 45: {
                sb.append("Insert");
                break;
            }
            case 46: {
                sb.append("Delete");
                break;
            }
            case 48: {
                sb.append('0');
                break;
            }
            case 49: {
                sb.append('1');
                break;
            }
            case 50: {
                sb.append('2');
                break;
            }
            case 51: {
                sb.append('3');
                break;
            }
            case 52: {
                sb.append('4');
                break;
            }
            case 53: {
                sb.append('5');
                break;
            }
            case 54: {
                sb.append('6');
                break;
            }
            case 55: {
                sb.append('7');
                break;
            }
            case 56: {
                sb.append('8');
                break;
            }
            case 57: {
                sb.append('9');
                break;
            }
            case 59: {
                sb.append(';');
                break;
            }
            case 61: {
                sb.append('=');
                break;
            }
            case 65: {
                sb.append('A');
                break;
            }
            case 66: {
                sb.append('B');
                break;
            }
            case 67: {
                sb.append('C');
                break;
            }
            case 68: {
                sb.append('D');
                break;
            }
            case 69: {
                sb.append('E');
                break;
            }
            case 70: {
                sb.append('F');
                break;
            }
            case 71: {
                sb.append('G');
                break;
            }
            case 72: {
                sb.append('H');
                break;
            }
            case 73: {
                sb.append('I');
                break;
            }
            case 74: {
                sb.append('J');
                break;
            }
            case 75: {
                sb.append('K');
                break;
            }
            case 76: {
                sb.append('L');
                break;
            }
            case 77: {
                sb.append('M');
                break;
            }
            case 78: {
                sb.append('N');
                break;
            }
            case 79: {
                sb.append('O');
                break;
            }
            case 80: {
                sb.append('P');
                break;
            }
            case 81: {
                sb.append('Q');
                break;
            }
            case 82: {
                sb.append('R');
                break;
            }
            case 83: {
                sb.append('S');
                break;
            }
            case 84: {
                sb.append('T');
                break;
            }
            case 85: {
                sb.append('U');
                break;
            }
            case 86: {
                sb.append('V');
                break;
            }
            case 87: {
                sb.append('W');
                break;
            }
            case 88: {
                sb.append('X');
                break;
            }
            case 89: {
                sb.append('Y');
                break;
            }
            case 90: {
                sb.append('Z');
                break;
            }
            case 93: {
                sb.append("Contextmenu");
                break;
            }
            case 96: {
                sb.append("Numpad0");
                break;
            }
            case 97: {
                sb.append("Numpad1");
                break;
            }
            case 98: {
                sb.append("Numpad2");
                break;
            }
            case 99: {
                sb.append("Numpad3");
                break;
            }
            case 100: {
                sb.append("Numpad4");
                break;
            }
            case 101: {
                sb.append("Numpad5");
                break;
            }
            case 102: {
                sb.append("Numpad6");
                break;
            }
            case 103: {
                sb.append("Numpad7");
                break;
            }
            case 104: {
                sb.append("Numpad8");
                break;
            }
            case 105: {
                sb.append("Numpad9");
                break;
            }
            case 106: {
                sb.append("Multiply");
                break;
            }
            case 107: {
                sb.append("Add");
                break;
            }
            case 108: {
                sb.append("Separator");
                break;
            }
            case 109: {
                sb.append("Subtract");
                break;
            }
            case 110: {
                sb.append("Decimal");
                break;
            }
            case 111: {
                sb.append("Divide");
                break;
            }
            case 112: {
                sb.append("F1");
                break;
            }
            case 113: {
                sb.append("F2");
                break;
            }
            case 114: {
                sb.append("F3");
                break;
            }
            case 115: {
                sb.append("F4");
                break;
            }
            case 116: {
                sb.append("F5");
                break;
            }
            case 117: {
                sb.append("F6");
                break;
            }
            case 118: {
                sb.append("F7");
                break;
            }
            case 119: {
                sb.append("F8");
                break;
            }
            case 120: {
                sb.append("F9");
                break;
            }
            case 121: {
                sb.append("F10");
                break;
            }
            case 122: {
                sb.append("F11");
                break;
            }
            case 123: {
                sb.append("F12");
                break;
            }
            case 124: {
                sb.append("F13");
                break;
            }
            case 125: {
                sb.append("F14");
                break;
            }
            case 126: {
                sb.append("F15");
                break;
            }
            case 127: {
                sb.append("F16");
                break;
            }
            case 128: {
                sb.append("F17");
                break;
            }
            case 129: {
                sb.append("F18");
                break;
            }
            case 130: {
                sb.append("F19");
                break;
            }
            case 131: {
                sb.append("F20");
                break;
            }
            case 132: {
                sb.append("F21");
                break;
            }
            case 133: {
                sb.append("F22");
                break;
            }
            case 134: {
                sb.append("F23");
                break;
            }
            case 135: {
                sb.append("F24");
                break;
            }
            case 144: {
                sb.append("Numlock");
                break;
            }
            case 145: {
                sb.append("Scrolllock");
                break;
            }
            case 188: {
                sb.append(",");
                break;
            }
            case 190: {
                sb.append(".");
                break;
            }
            case 191: {
                sb.append("/");
                break;
            }
            case 192: {
                sb.append("`");
                break;
            }
            case 219: {
                sb.append("[");
                break;
            }
            case 220: {
                sb.append("\\");
                break;
            }
            case 221: {
                sb.append("]");
                break;
            }
            case 222: {
                sb.append("'");
                break;
            }
            case 224: {
                sb.append("Meta");
            }
        }
    }
}

