/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.console;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.nn.adapterframework.lifecycle.DynamicRegistration;
import nl.nn.adapterframework.util.ClassUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Scope;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
@Scope(value="singleton")
public class ConsoleFrontend
extends HttpServlet
implements DynamicRegistration.Servlet,
EnvironmentAware,
InitializingBean {
    private static final Logger log = LogManager.getLogger(ConsoleFrontend.class);
    private static final long serialVersionUID = 1L;
    private static final String WELCOME_FILE = "index.html";
    private static final String DEFAULT_CONSOLE_PATH = "console";
    private String frontendPath = null;
    private transient Environment environment;

    public void afterPropertiesSet() {
        if (this.environment != null && Arrays.asList(this.environment.getActiveProfiles()).contains("dev")) {
            String devFrontendLocation = this.environment.getProperty("frontend.resources.location");
            if (devFrontendLocation == null) {
                Path rootPath = Paths.get("", new String[0]).toAbsolutePath();
                devFrontendLocation = rootPath.resolve("console/frontend/target/frontend/").toString();
            }
            this.frontendPath = "file:" + FilenameUtils.getFullPath((String)devFrontendLocation);
            log.info("found frontend path [{}]", (Object)this.frontendPath);
        }
        this.frontendPath = DEFAULT_CONSOLE_PATH;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        try {
            this.doGetSafely(req, resp);
        }
        catch (IOException e) {
            log.error("unable to process request", (Throwable)e);
        }
    }

    private void doGetSafely(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        URL resource;
        String path = req.getPathInfo();
        if (StringUtils.isBlank((CharSequence)path)) {
            String fullPath = req.getRequestURI();
            if (!fullPath.endsWith("/")) {
                resp.sendRedirect(req.getContextPath() + req.getServletPath() + "/");
                return;
            }
            if (path == null) {
                path = "/";
            } else {
                resp.sendError(404);
                return;
            }
        }
        if (path.equals("/")) {
            path = path + WELCOME_FILE;
        }
        if ((resource = this.findResource(path)) == null) {
            resp.sendError(404);
            return;
        }
        String mimeType = this.getServletContext().getMimeType(path);
        resp.setContentType(mimeType != null ? mimeType : "application/octet-stream");
        try (InputStream in = resource.openStream();){
            IOUtils.copy((InputStream)in, (OutputStream)resp.getOutputStream());
            resp.flushBuffer();
        }
        catch (IOException e) {
            log.debug("error reading resource [{}]", (Object)resource, (Object)e);
        }
    }

    @Nullable
    private URL findResource(String path) {
        try {
            String normalized = FilenameUtils.normalize((String)(this.frontendPath + path), (boolean)true);
            log.trace("trying to find resource [{}]", (Object)normalized);
            URL resource = ClassUtils.getResourceURL((String)normalized);
            if (resource == null) {
                log.debug("unable to locate resource [{}]", (Object)path);
            }
            return resource;
        }
        catch (IOException e) {
            log.warn("exception while locating file [{}]", (Object)path, (Object)e);
            return null;
        }
    }

    public String getName() {
        return "Console";
    }

    public String[] getAccessGrantingRoles() {
        return ALL_IBIS_USER_ROLES;
    }

    public String getUrlMapping() {
        return "iaf/gui/*";
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

