/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.web.filters;

import java.lang.reflect.Method;
import javax.annotation.Priority;
import javax.ws.rs.Path;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

@Provider
@Priority(value=5000)
public class DeprecationFilter
implements ContainerRequestFilter,
EnvironmentAware {
    public static final String ALLOW_DEPRECATED_ENDPOINTS_KEY = "iaf-api.allowDeprecated";
    private static final Response DEPRECATION_ERROR = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    private static final Response SERVER_ERROR = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
    private Logger log = LogManager.getLogger((Object)this);
    private boolean allowDeprecatedEndpoints = false;

    public void filter(ContainerRequestContext requestContext) {
        Message message = JAXRSUtils.getCurrentMessage();
        Method method = (Method)message.get((Object)"org.apache.cxf.resource.method");
        if (method == null) {
            this.log.error("unable to fetch resource method from CXF Message");
            requestContext.abortWith(SERVER_ERROR);
            return;
        }
        if (!this.allowDeprecatedEndpoints && method.isAnnotationPresent(Deprecated.class)) {
            this.log.warn("endpoint [{}] has been deprecated, set property [{}=true] to restore functionality", (Object)this.getFullPath(method), (Object)ALLOW_DEPRECATED_ENDPOINTS_KEY);
            requestContext.abortWith(DEPRECATION_ERROR);
        }
    }

    private String getFullPath(Method method) {
        Path classPath = method.getDeclaringClass().getAnnotation(Path.class);
        String basePath = classPath != null ? classPath.value() : "/";
        StringBuilder pathToUse = new StringBuilder();
        if (!basePath.startsWith("/")) {
            pathToUse.append("/");
        }
        pathToUse.append(basePath);
        Path methodPath = method.getAnnotation(Path.class);
        if (methodPath != null) {
            String path = methodPath.value();
            pathToUse.append(basePath.endsWith("/") && path.startsWith("/") ? path.substring(1) : path);
        }
        return pathToUse.toString();
    }

    public void setEnvironment(Environment environment) {
        this.allowDeprecatedEndpoints = (Boolean)environment.getProperty(ALLOW_DEPRECATED_ENDPOINTS_KEY, Boolean.TYPE, (Object)false);
    }
}

