/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.web.filters;

import java.io.IOException;
import java.util.LinkedList;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.web.header.writers.ContentSecurityPolicyHeaderWriter;

public class CspFilter
implements Filter {
    private ContentSecurityPolicyHeaderWriter cspWriter;
    @Value(value="${cspheader.reportOnly:false}")
    private boolean reportOnly;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.cspWriter = new ContentSecurityPolicyHeaderWriter();
        LinkedList<String> policyDirectives = new LinkedList<String>();
        policyDirectives.add("default-src 'self';");
        policyDirectives.add("style-src 'self' https://fonts.googleapis.com/css 'unsafe-inline';");
        policyDirectives.add("font-src 'self' https://fonts.gstatic.com;");
        policyDirectives.add("script-src 'self' 'sha256-nTT9HlzZYsLZk5BbdhMKiMCvEgbfaqTeueMbRW8r6Ak=';");
        policyDirectives.add("connect-src 'self' https://ibissource.org/iaf/releases/;");
        policyDirectives.add("img-src 'self' data:;");
        policyDirectives.add("frame-ancestors 'self';");
        policyDirectives.add("form-action 'none';");
        this.cspWriter.setPolicyDirectives(StringUtils.join(policyDirectives, (String)" "));
        this.cspWriter.setReportOnly(this.reportOnly);
    }

    public void doFilter(ServletRequest request, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)resp;
        this.cspWriter.writeHeaders((HttpServletRequest)request, response);
        response.setHeader("X-Content-Type-Options", "nosniff");
        response.setHeader("X-Frame-Options", "SAMEORIGIN");
        response.setHeader("X-XSS-Protection", "1; mode=block");
        chain.doFilter(request, (ServletResponse)response);
    }

    public void destroy() {
    }
}

