/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.management.web;

import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import nl.nn.adapterframework.management.bus.BusAction;
import nl.nn.adapterframework.management.bus.BusTopic;
import nl.nn.adapterframework.management.web.ApiException;
import nl.nn.adapterframework.management.web.FrankApiBase;
import nl.nn.adapterframework.management.web.Relation;
import nl.nn.adapterframework.management.web.RequestMessageBuilder;
import org.apache.commons.lang3.StringUtils;

@Path(value="/")
public final class Webservices
extends FrankApiBase {
    @GET
    @RolesAllowed(value={"IbisObserver", "IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/webservices")
    @Relation(value="webservices")
    @Produces(value={"application/json"})
    public Response getWebServices() {
        return this.callSyncGateway(RequestMessageBuilder.create(this, BusTopic.WEBSERVICES, BusAction.GET));
    }

    @GET
    @RolesAllowed(value={"IbisObserver", "IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/webservices/openapi.json")
    @Produces(value={"application/json"})
    public Response getOpenApiSpec(@QueryParam(value="uri") String uri) {
        RequestMessageBuilder request = RequestMessageBuilder.create(this, BusTopic.WEBSERVICES, BusAction.DOWNLOAD);
        request.addHeader("type", "openapi");
        if (StringUtils.isNotBlank((CharSequence)uri)) {
            request.addHeader("uri", uri);
        }
        return this.callSyncGateway(request);
    }

    @GET
    @RolesAllowed(value={"IbisObserver", "IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/webservices/{configuration}/{resourceName}")
    @Relation(value="webservices")
    @Produces(value={"application/xml"})
    public Response getWsdl(@PathParam(value="configuration") String configuration, @PathParam(value="resourceName") String resourceName, @DefaultValue(value="true") @QueryParam(value="indent") boolean indent, @DefaultValue(value="false") @QueryParam(value="useIncludes") boolean useIncludes) {
        String adapterName;
        RequestMessageBuilder request = RequestMessageBuilder.create(this, BusTopic.WEBSERVICES, BusAction.DOWNLOAD);
        request.addHeader("indent", indent);
        request.addHeader("useIncludes", useIncludes);
        request.addHeader("type", "wsdl");
        int dotPos = resourceName.lastIndexOf(46);
        if (dotPos >= 0) {
            adapterName = resourceName.substring(0, dotPos);
            boolean zip = resourceName.substring(dotPos).equals(".zip");
            request.addHeader("zip", zip);
        } else {
            adapterName = resourceName;
        }
        if (StringUtils.isEmpty((CharSequence)adapterName)) {
            throw new ApiException("no adapter specified");
        }
        request.addHeader("adapter", adapterName);
        request.addHeader("configuration", configuration);
        return this.callSyncGateway(request);
    }
}

