/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.management.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import nl.nn.adapterframework.management.bus.BusAction;
import nl.nn.adapterframework.management.bus.BusTopic;
import nl.nn.adapterframework.management.web.ApiException;
import nl.nn.adapterframework.management.web.FrankApiBase;
import nl.nn.adapterframework.management.web.Relation;
import nl.nn.adapterframework.management.web.RequestMessageBuilder;
import nl.nn.adapterframework.util.RequestUtils;
import nl.nn.adapterframework.util.StreamUtil;
import nl.nn.adapterframework.util.XmlEncodingUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;

@Path(value="/")
public class TestServiceListener
extends FrankApiBase {
    @GET
    @RolesAllowed(value={"IbisObserver", "IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/test-servicelistener")
    @Relation(value="servicelistener")
    @Produces(value={"application/json"})
    public Response getServiceListeners() throws ApiException {
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.SERVICE_LISTENER, BusAction.GET);
        return this.callSyncGateway(builder);
    }

    @POST
    @RolesAllowed(value={"IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/test-servicelistener")
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    public Response postServiceListeners(MultipartBody inputDataMap) throws ApiException {
        if (inputDataMap == null) {
            throw new ApiException("Missing post parameters");
        }
        String message = null;
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.SERVICE_LISTENER, BusAction.UPLOAD);
        builder.addHeader("service", RequestUtils.resolveStringFromMap(inputDataMap, "service"));
        String fileEncoding = RequestUtils.resolveTypeFromMap(inputDataMap, "encoding", String.class, StreamUtil.DEFAULT_INPUT_STREAM_ENCODING);
        Attachment filePart = inputDataMap.getAttachment("file");
        if (filePart != null) {
            InputStream file = (InputStream)filePart.getObject(InputStream.class);
            try {
                message = XmlEncodingUtils.readXml((InputStream)file, (String)fileEncoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new ApiException("unsupported file encoding [" + fileEncoding + "]");
            }
            catch (IOException e) {
                throw new ApiException("error reading file", e);
            }
        } else {
            message = RequestUtils.resolveStringWithEncoding(inputDataMap, "message", fileEncoding);
        }
        if (StringUtils.isEmpty((CharSequence)message)) {
            throw new ApiException("Neither a file nor a message was supplied", 400);
        }
        builder.setPayload(message);
        return this.callSyncGateway(builder);
    }
}

