/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.management.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import nl.nn.adapterframework.management.bus.BusAction;
import nl.nn.adapterframework.management.bus.BusMessageUtils;
import nl.nn.adapterframework.management.bus.BusTopic;
import nl.nn.adapterframework.management.web.ApiException;
import nl.nn.adapterframework.management.web.FrankApiBase;
import nl.nn.adapterframework.management.web.Relation;
import nl.nn.adapterframework.management.web.RequestMessageBuilder;
import nl.nn.adapterframework.util.RequestUtils;
import nl.nn.adapterframework.util.StreamUtil;
import nl.nn.adapterframework.util.XmlEncodingUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.springframework.messaging.Message;

@Path(value="/")
public class TestPipeline
extends FrankApiBase {
    @POST
    @RolesAllowed(value={"IbisTester"})
    @Path(value="/test-pipeline")
    @Relation(value="pipeline")
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    public Response postTestPipeLine(MultipartBody inputDataMap) throws ApiException {
        String message = null;
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.TEST_PIPELINE, BusAction.UPLOAD);
        String configuration = RequestUtils.resolveStringFromMap(inputDataMap, "configuration");
        builder.addHeader("configuration", configuration);
        String adapterName = RequestUtils.resolveStringFromMap(inputDataMap, "adapter");
        builder.addHeader("adapter", adapterName);
        String sessionKeys = RequestUtils.resolveTypeFromMap(inputDataMap, "sessionKeys", String.class, "");
        if (StringUtils.isNotEmpty((CharSequence)sessionKeys)) {
            builder.addHeader("sessionKeys", sessionKeys);
        }
        String fileEncoding = RequestUtils.resolveTypeFromMap(inputDataMap, "encoding", String.class, StreamUtil.DEFAULT_INPUT_STREAM_ENCODING);
        Attachment filePart = inputDataMap.getAttachment("file");
        if (filePart != null) {
            String fileName = filePart.getContentDisposition().getParameter("filename");
            InputStream file = (InputStream)filePart.getObject(InputStream.class);
            if (StringUtils.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)".zip")) {
                try {
                    String zipResults = this.processZipFile(file, builder);
                    return this.testPipelineResponse(zipResults);
                }
                catch (Exception e) {
                    throw new ApiException("An exception occurred while processing zip file", e);
                }
            }
            try {
                message = XmlEncodingUtils.readXml((InputStream)file, (String)fileEncoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new ApiException("unsupported file encoding [" + fileEncoding + "]");
            }
            catch (IOException e) {
                throw new ApiException("error reading file", e);
            }
        } else {
            message = RequestUtils.resolveStringWithEncoding(inputDataMap, "message", fileEncoding);
        }
        if (StringUtils.isEmpty((CharSequence)message)) {
            throw new ApiException("Neither a file nor a message was supplied", 400);
        }
        builder.setPayload(message);
        Message<?> response = this.sendSyncMessage(builder);
        String state = BusMessageUtils.getHeader(response, (String)"state");
        return this.testPipelineResponse(this.getPayload(response), state, message);
    }

    private String getPayload(Message<?> response) {
        Object payload = response.getPayload();
        if (payload instanceof String) {
            return (String)payload;
        }
        if (payload instanceof byte[]) {
            return new String((byte[])payload);
        }
        if (payload instanceof InputStream) {
            try {
                return StreamUtil.streamToString((InputStream)((InputStream)payload));
            }
            catch (IOException e) {
                throw new ApiException("unable to read response payload", e);
            }
        }
        throw new ApiException("unexpected response payload type [" + payload.getClass().getCanonicalName() + "]");
    }

    private Response testPipelineResponse(String payload) {
        return this.testPipelineResponse(payload, "SUCCESS", null);
    }

    private Response testPipelineResponse(String payload, String state, String message) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("state", state);
        result.put("result", payload);
        if (message != null) {
            result.put("message", message);
        }
        return Response.status((int)200).entity(result).build();
    }

    private String processZipFile(InputStream file, RequestMessageBuilder builder) throws IOException {
        StringBuilder result = new StringBuilder();
        ZipInputStream archive = new ZipInputStream(file);
        ZipEntry entry = archive.getNextEntry();
        while (entry != null) {
            String name = entry.getName();
            int size = (int)entry.getSize();
            if (size > 0) {
                byte[] b = new byte[size];
                int rb = 0;
                int chunk = 0;
                while (size - rb > 0 && (chunk = archive.read(b, rb, size - rb)) != -1) {
                    rb += chunk;
                }
                String currentMessage = XmlEncodingUtils.readXml((byte[])b, null);
                builder.setPayload(currentMessage);
                Message<?> response = this.sendSyncMessage(builder);
                result.append(name);
                result.append(": ");
                result.append(BusMessageUtils.getHeader(response, (String)"state"));
                result.append("\n");
            }
            archive.closeEntry();
            entry = archive.getNextEntry();
        }
        archive.close();
        return result.toString();
    }
}

