/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.management.web;

import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import nl.nn.adapterframework.management.bus.BusTopic;
import nl.nn.adapterframework.management.web.FrankApiBase;
import nl.nn.adapterframework.management.web.RequestMessageBuilder;

@Path(value="/")
public final class ShowIbisstoreSummary
extends FrankApiBase {
    @POST
    @RolesAllowed(value={"IbisObserver", "IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/jdbc/summary")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response execute(Map<String, Object> json) {
        String query = null;
        String datasource = null;
        for (Map.Entry<String, Object> entry : json.entrySet()) {
            String key = entry.getKey();
            if (key.equalsIgnoreCase("datasource")) {
                datasource = entry.getValue().toString();
            }
            if (!key.equalsIgnoreCase("query")) continue;
            query = entry.getValue().toString();
        }
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.IBISSTORE_SUMMARY);
        builder.addHeader("datasourceName", datasource);
        builder.addHeader("query", query);
        return this.callSyncGateway(builder);
    }
}

