/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.management.web;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.nn.adapterframework.lifecycle.DynamicRegistration;
import nl.nn.adapterframework.util.HttpUtils;
import org.apache.cxf.Bus;
import org.apache.cxf.transport.servlet.CXFServlet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
@Scope(value="singleton")
public class ServletDispatcher
extends CXFServlet
implements DynamicRegistration.ServletWithParameters {
    private static final long serialVersionUID = 3L;
    private final Logger secLog = LogManager.getLogger((String)"SEC");
    private final Logger log = LogManager.getLogger((Object)((Object)this));
    @Value(value="${iaf-api.enabled:true}")
    private boolean isEnabled;

    public void init(ServletConfig servletConfig) throws ServletException {
        if (!this.isEnabled) {
            return;
        }
        this.log.debug("initialize {} servlet", new Supplier[]{this::getName});
        super.init(servletConfig);
    }

    public void invoke(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (!this.isEnabled) {
            try {
                response.sendError(404, "api backend not enabled");
            }
            catch (IOException e) {
                this.log.debug("unable to send 404 error to client", (Throwable)e);
            }
            return;
        }
        String method = request.getMethod();
        if (!method.equalsIgnoreCase("GET") && !method.equalsIgnoreCase("OPTIONS")) {
            this.secLog.debug("received http request from URI [{}:{}] issued by [{}]", (Object)method, (Object)request.getRequestURI(), (Object)HttpUtils.getCommandIssuedBy((HttpServletRequest)request));
        }
        super.invoke(request, response);
    }

    public void setBus(Bus bus) {
        if (bus != null) {
            String busInfo = String.format("Successfully created %s with SpringBus [%s]", this.getName(), bus.getId());
            this.log.info(busInfo);
            this.getServletContext().log(busInfo);
        }
        super.setBus(bus);
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
    }

    public String getName() {
        return "IAF-API";
    }

    public int loadOnStartUp() {
        return 0;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public String[] getAccessGrantingRoles() {
        return ALL_IBIS_USER_ROLES;
    }

    public String getUrlMapping() {
        return "iaf/api/*,!/iaf/api/server/health";
    }

    public Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("config-location", "FrankFrameworkApiContext.xml");
        parameters.put("bus", "ff-api-bus");
        return parameters;
    }
}

