/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.management.web;

import java.util.HashMap;
import javax.annotation.security.PermitAll;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import nl.nn.adapterframework.management.bus.BusAction;
import nl.nn.adapterframework.management.bus.BusTopic;
import nl.nn.adapterframework.management.web.ApiException;
import nl.nn.adapterframework.management.web.FrankApiBase;
import nl.nn.adapterframework.management.web.RequestMessageBuilder;
import org.springframework.messaging.MessageHandlingException;

@Path(value="/")
public class ServerStatistics
extends FrankApiBase {
    @GET
    @PermitAll
    @Path(value="/server/info")
    @Produces(value={"application/json"})
    public Response getServerInformation() {
        return this.callSyncGateway(RequestMessageBuilder.create(this, BusTopic.APPLICATION, BusAction.GET));
    }

    @GET
    @PermitAll
    @Path(value="/server/configurations")
    @Produces(value={"application/json"})
    public Response getAllConfigurations() {
        return this.callSyncGateway(RequestMessageBuilder.create(this, BusTopic.CONFIGURATION, BusAction.FIND));
    }

    @GET
    @PermitAll
    @Path(value="/server/warnings")
    @Produces(value={"application/json"})
    public Response getServerConfiguration() {
        return this.callSyncGateway(RequestMessageBuilder.create(this, BusTopic.APPLICATION, BusAction.WARNINGS), true);
    }

    @GET
    @PermitAll
    @Path(value="/server/health")
    @Produces(value={"application/json"})
    public Response getIbisHealth() {
        try {
            return this.callSyncGateway(RequestMessageBuilder.create(this, BusTopic.HEALTH));
        }
        catch (ApiException e) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("status", Response.Status.INTERNAL_SERVER_ERROR);
            response.put("error", "unable to connect to backend system: " + e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(response).build();
        }
        catch (MessageHandlingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
    }
}

